/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.jgroups.Responses;
import org.infinispan.util.concurrent.TimeoutException;
import org.jgroups.Address;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.util.RspList;

public class RspListFuture
extends CompletableFuture<Responses>
implements Callable<Void>,
BiConsumer<RspList<Response>, Throwable> {
    private final Collection<Address> addresses;
    private final GroupRequest<Response> request;
    private volatile Future<?> timeoutFuture = null;

    RspListFuture(Collection<Address> addresses, GroupRequest<Response> request) {
        this.addresses = addresses;
        this.request = request;
        request.whenComplete((BiConsumer)this);
    }

    public void setTimeoutFuture(Future<?> timeoutFuture) {
        this.timeoutFuture = timeoutFuture;
        if (this.isDone()) {
            timeoutFuture.cancel(false);
        }
    }

    @Override
    public Void call() throws Exception {
        this.completeExceptionally(new TimeoutException("Timed out waiting for responses"));
        this.request.cancel(true);
        return null;
    }

    @Override
    public void accept(RspList<Response> rsps, Throwable throwable) {
        this.requestDone(rsps, throwable);
    }

    private void requestDone(RspList<Response> rsps, Throwable throwable) {
        if (throwable == null) {
            this.complete(new Responses(this.addresses, rsps));
        } else {
            this.completeExceptionally(throwable);
        }
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
    }
}

