/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Table;
import org.jgroups.util.Util;

public class bla6 {
    protected static final Message DUMMY_OOB_MSG = new Message().setFlag(Message.Flag.OOB);
    protected static final Predicate<Message> drop_oob_and_dont_loopback_msgs_filter = msg -> msg != null && msg != DUMMY_OOB_MSG && (!msg.isFlagSet(Message.Flag.OOB) || msg.setTransientFlagIfAbsent(Message.TransientFlag.OOB_DELIVERED)) && !msg.isTransientFlagSet(Message.TransientFlag.DONT_LOOPBACK);
    protected static final BiConsumer<MessageBatch, Message> BATCH_ACCUMULATOR = MessageBatch::add;

    public static void main(String[] args) {
        Table<Message> table = new Table<Message>();
        Address sender = Util.createRandomAddress("B");
        Address local = Util.createRandomAddress("A");
        Message msg = new Message(null, "hello").setFlag(Message.Flag.OOB).src(sender);
        table.add(1L, msg);
        System.out.println("table = " + table);
        MessageBatch batch = new MessageBatch(table.getNumDeliverable()).dest(local).sender(sender).multicast(false);
        Supplier<MessageBatch> batch_creator = () -> batch;
        try {
            batch.reset();
            table.removeMany(true, 0, drop_oob_and_dont_loopback_msgs_filter, batch_creator, BATCH_ACCUMULATOR);
        }
        catch (Throwable t) {
            System.err.println("failed removing msg: " + t);
        }
        if (!batch.isEmpty()) {
            System.err.printf("delivering batch %s: FAIL\n", batch);
        } else {
            System.out.println("batch is empty: CORRECT");
        }
    }
}

