/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataTransientCacheValue;
import org.infinispan.metadata.Metadata;

public class MetadataTransientCacheEntry
extends AbstractInternalCacheEntry
implements MetadataAware {
    protected Object value;
    protected Metadata metadata;
    protected long lastUsed;

    public MetadataTransientCacheEntry(Object key, Object value, Metadata metadata, long lastUsed) {
        super(key);
        this.value = value;
        this.metadata = metadata;
        this.lastUsed = lastUsed;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object setValue(Object value) {
        this.value = value;
        return this.value;
    }

    @Override
    public final void touch() {
        this.touch(System.currentTimeMillis());
    }

    @Override
    public final void touch(long currentTimeMillis) {
        this.lastUsed = currentTimeMillis;
    }

    @Override
    public final void reincarnate() {
    }

    @Override
    public void reincarnate(long now) {
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransient(this.metadata.maxIdle(), this.lastUsed, now);
    }

    @Override
    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    @Override
    public long getCreated() {
        return -1L;
    }

    @Override
    public final long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public long getLifespan() {
        return -1L;
    }

    @Override
    public long getExpiryTime() {
        long maxIdle = this.metadata.maxIdle();
        return maxIdle > -1L ? this.lastUsed + maxIdle : -1L;
    }

    @Override
    public final long getMaxIdle() {
        return this.metadata.maxIdle();
    }

    public InternalCacheValue toInternalCacheValue() {
        return new MetadataTransientCacheValue(this.value, this.metadata, this.lastUsed);
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataTransientCacheEntry that = (MetadataTransientCacheEntry)o;
        if (this.lastUsed != that.lastUsed) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
    }

    @Override
    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        result = 31 * result + (int)(this.lastUsed ^ this.lastUsed >>> 32);
        return result;
    }

    public static class Externalizer
    extends AbstractExternalizer<MetadataTransientCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, MetadataTransientCacheEntry ice) throws IOException {
            output.writeObject(ice.key);
            output.writeObject(ice.value);
            output.writeObject(ice.metadata);
            UnsignedNumeric.writeUnsignedLong(output, ice.lastUsed);
        }

        @Override
        public MetadataTransientCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            return new MetadataTransientCacheEntry(k, v, metadata, lastUsed);
        }

        @Override
        public Integer getId() {
            return 40;
        }

        @Override
        public Set<Class<? extends MetadataTransientCacheEntry>> getTypeClasses() {
            return Util.asSet(MetadataTransientCacheEntry.class);
        }
    }
}

