/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.distribution.Collector;
import org.infinispan.interceptors.distribution.PrimaryOwnerOnlyCollector;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class CommandAckCollector {
    private static final Log log = LogFactory.getLog(CommandAckCollector.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ConcurrentHashMap<Long, BaseCollector<?>> collectorMap = new ConcurrentHashMap();
    private ScheduledExecutorService timeoutExecutor;
    private long timeoutNanoSeconds;

    @Inject
    public void inject(@ComponentName(value="org.infinispan.executors.timeout") ScheduledExecutorService timeoutExecutor, Configuration configuration) {
        this.timeoutExecutor = timeoutExecutor;
        this.timeoutNanoSeconds = TimeUnit.MILLISECONDS.toNanos(configuration.clustering().remoteTimeout());
    }

    public Collector<Object> create(long id, Collection<Address> backupOwners, int topologyId) {
        if (backupOwners.isEmpty()) {
            return new PrimaryOwnerOnlyCollector<Object>();
        }
        SingleKeyCollector collector = new SingleKeyCollector(id, backupOwners, topologyId);
        this.collectorMap.put(id, collector);
        if (trace) {
            log.tracef("Created new collector for %s. BackupOwners=%s", id, (Object)backupOwners);
        }
        return collector;
    }

    public Collector<Map<Object, Object>> createMultiKeyCollector(long id, Collection<Address> primary, Map<Address, Collection<Integer>> backups, int topologyId) {
        if (backups.isEmpty()) {
            return new PrimaryOwnerOnlyCollector<Map<Object, Object>>();
        }
        MultiKeyCollector collector = new MultiKeyCollector(id, backups, topologyId);
        this.collectorMap.put(id, collector);
        if (trace) {
            log.tracef("Created new collector for %s. Primary=%s. BackupSegments=%s", id, (Object)primary, (Object)backups);
        }
        return collector;
    }

    public void multiKeyBackupAck(long id, Address from, int segment, int topologyId) {
        MultiKeyCollector collector = (MultiKeyCollector)this.collectorMap.get(id);
        if (collector != null) {
            collector.backupAck(from, segment, topologyId);
        }
    }

    public void backupAck(long id, Address from, int topologyId) {
        SingleKeyCollector collector = (SingleKeyCollector)this.collectorMap.get(id);
        if (collector != null) {
            collector.backupAck(topologyId, from);
        }
    }

    public void completeExceptionally(long id, Throwable throwable, int topologyId) {
        BaseCollector<?> collector = this.collectorMap.get(id);
        if (collector != null) {
            collector.completeExceptionally(throwable, topologyId);
        }
    }

    public List<Long> getPendingCommands() {
        return new ArrayList<Long>(this.collectorMap.keySet());
    }

    public boolean hasPendingBackupAcks(long id) {
        BaseCollector<?> collector = this.collectorMap.get(id);
        return collector != null && collector.hasPendingBackupAcks();
    }

    public void onMembersChange(Collection<Address> members) {
        HashSet<Address> currentMembers = new HashSet<Address>(members);
        for (BaseCollector<?> collector : this.collectorMap.values()) {
            collector.onMembersChange(currentMembers);
        }
    }

    private TimeoutException createTimeoutException(long id) {
        return log.timeoutWaitingForAcks(Util.prettyPrintTime(this.timeoutNanoSeconds, TimeUnit.NANOSECONDS), id);
    }

    private class MultiKeyCollector
    extends BaseCollector<Map<Object, Object>> {
        @GuardedBy(value="this")
        private final Map<Address, Collection<Integer>> backups;

        MultiKeyCollector(long id, Map<Address, Collection<Integer>> backups, int topologyId) {
            super(id, topologyId);
            this.backups = backups;
        }

        @Override
        public synchronized boolean hasPendingBackupAcks() {
            return !this.backups.isEmpty();
        }

        @Override
        public synchronized void onMembersChange(Collection<Address> members) {
            if (this.backups.keySet().retainAll(members)) {
                if (trace) {
                    log.tracef("[Collector#%s] Some backups left the cluster.", this.id);
                }
                this.checkCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void primaryResult(Map<Object, Object> result, boolean success) {
            this.primaryResult = result;
            this.primaryResultReceived = true;
            MultiKeyCollector multiKeyCollector = this;
            synchronized (multiKeyCollector) {
                this.checkCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void backupAck(Address from, int segment, int topologyId) {
            if (trace) {
                log.tracef("[Collector#%s] PutMap Backup ACK. Address=%s. TopologyId=%s (expected=%s). Segment=%s", this.id, from, topologyId, this.topologyId, segment);
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            MultiKeyCollector multiKeyCollector = this;
            synchronized (multiKeyCollector) {
                Collection pendingSegments = this.backups.getOrDefault(from, Collections.emptyList());
                if (pendingSegments.remove(segment) && pendingSegments.isEmpty()) {
                    this.backups.remove(from);
                }
                this.checkCompleted();
            }
        }

        @GuardedBy(value="this")
        private void checkCompleted() {
            if (this.primaryResultReceived && this.backups.isEmpty()) {
                if (trace) {
                    log.tracef("[Collector#%s] Ready! Return value=%ss.", this.id, this.primaryResult);
                }
                this.future.complete(this.primaryResult);
            }
        }
    }

    private class SingleKeyCollector
    extends BaseCollector<Object> {
        private final Collection<Address> backupOwners;

        private SingleKeyCollector(long id, Collection<Address> backupOwners, int topologyId) {
            super(id, topologyId);
            this.backupOwners = Collections.synchronizedSet(new HashSet<Address>(backupOwners));
        }

        @Override
        public boolean hasPendingBackupAcks() {
            return !this.backupOwners.isEmpty();
        }

        @Override
        public void onMembersChange(Collection<Address> members) {
            if (this.backupOwners.retainAll(members) && this.backupOwners.isEmpty() && this.primaryResultReceived) {
                if (trace) {
                    log.tracef("[Collector#%s] Some backups left the cluster.", this.id);
                }
                this.markReady();
            }
        }

        @Override
        public void primaryResult(Object result, boolean success) {
            this.primaryResult = result;
            this.primaryResultReceived = true;
            if (!success || this.backupOwners.isEmpty()) {
                this.markReady();
            }
        }

        void backupAck(int topologyId, Address from) {
            if (trace) {
                log.tracef("[Collector#%s] Backup ACK. Address=%s, TopologyId=%s (expected=%s)", this.id, from, topologyId, this.topologyId);
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            if (this.backupOwners.remove(from) && this.backupOwners.isEmpty() && this.primaryResultReceived) {
                this.markReady();
            }
        }

        private void markReady() {
            if (trace) {
                log.tracef("[Collector#%s] Ready!", this.id);
            }
            this.future.complete(this.primaryResult);
        }
    }

    private abstract class BaseCollector<T>
    implements Callable<Void>,
    BiConsumer<T, Throwable>,
    Collector<T> {
        final long id;
        final CompletableFuture<T> future;
        final int topologyId;
        private final ScheduledFuture<?> timeoutTask;
        volatile T primaryResult;
        volatile boolean primaryResultReceived = false;

        BaseCollector(long id, int topologyId) {
            this.id = id;
            this.topologyId = topologyId;
            this.future = new CompletableFuture();
            this.timeoutTask = CommandAckCollector.this.timeoutExecutor.schedule(this, CommandAckCollector.this.timeoutNanoSeconds, TimeUnit.NANOSECONDS);
        }

        @Override
        public final synchronized Void call() throws Exception {
            this.future.completeExceptionally(CommandAckCollector.this.createTimeoutException(this.id));
            return null;
        }

        @Override
        public final void accept(T t, Throwable throwable) {
            if (trace) {
                log.tracef("[Collector#%s] Collector completed with ret=%s, throw=%s", this.id, t, (Object)throwable);
            }
            CommandAckCollector.this.collectorMap.remove(this.id);
            this.timeoutTask.cancel(false);
        }

        @Override
        public final CompletableFuture<T> getFuture() {
            return this.future.whenComplete((BiConsumer)this);
        }

        @Override
        public void primaryException(Throwable throwable) {
            this.future.completeExceptionally(throwable);
        }

        final void completeExceptionally(Throwable throwable, int topologyId) {
            if (trace) {
                log.tracef(throwable, "[Collector#%s] completed exceptionally. TopologyId=%s (expected=%s)", this.id, (long)topologyId, (long)this.topologyId);
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            this.future.completeExceptionally(throwable);
        }

        abstract boolean hasPendingBackupAcks();

        abstract void onMembersChange(Collection<Address> var1);

        final boolean isWrongTopologyOrIsDone(int topologyId) {
            return this.topologyId != topologyId || this.future.isDone();
        }
    }
}

