/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.cache.impl.Caches;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.group.impl.GroupFilter;
import org.infinispan.distribution.group.impl.GroupManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.filter.CollectionKeyFilter;
import org.infinispan.filter.CompositeKeyFilter;
import org.infinispan.interceptors.impl.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.util.PersistenceManagerCloseableSupplier;
import org.infinispan.stream.impl.interceptor.AbstractDelegatingEntryCacheSet;
import org.infinispan.stream.impl.interceptor.AbstractDelegatingKeyCacheSet;
import org.infinispan.stream.impl.spliterators.IteratorAsSpliterator;
import org.infinispan.util.CloseableSuppliedIterator;
import org.infinispan.util.DistinctKeyDoubleEntryCloseableIterator;
import org.infinispan.util.TimeService;
import org.infinispan.util.function.CloseableSupplier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="CacheLoader", description="Component that handles loading entries from a CacheStore into memory.")
public class CacheLoaderInterceptor<K, V>
extends JmxStatsCommandInterceptor {
    private final AtomicLong cacheLoads = new AtomicLong(0L);
    private final AtomicLong cacheMisses = new AtomicLong(0L);
    protected PersistenceManager persistenceManager;
    protected CacheNotifier notifier;
    protected EntryFactory entryFactory;
    private TimeService timeService;
    private InternalEntryFactory iceFactory;
    private DataContainer<K, V> dataContainer;
    private GroupManager groupManager;
    private ExecutorService executorService;
    private Cache<K, V> cache;
    private boolean activation;
    private static final Log log = LogFactory.getLog(CacheLoaderInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Inject
    protected void injectDependencies(PersistenceManager clm, EntryFactory entryFactory, CacheNotifier notifier, TimeService timeService, InternalEntryFactory iceFactory, DataContainer<K, V> dataContainer, GroupManager groupManager, @ComponentName(value="org.infinispan.executors.persistence") ExecutorService persistenceExecutor, Cache<K, V> cache) {
        this.persistenceManager = clm;
        this.notifier = notifier;
        this.entryFactory = entryFactory;
        this.timeService = timeService;
        this.iceFactory = iceFactory;
        this.dataContainer = dataContainer;
        this.groupManager = groupManager;
        this.executorService = persistenceExecutor;
        this.cache = cache;
    }

    @Start
    public void start() {
        this.activation = this.cache.getCacheConfiguration().persistence().passivation();
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        for (Object key : command.getKeys()) {
            this.loadIfNeeded(ctx, key, command);
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        Object[] keys = command.getKeys();
        if (keys != null && keys.length > 0) {
            for (Object key : command.getKeys()) {
                this.loadIfNeeded(ctx, key, command);
            }
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.visitDataCommand(ctx, command);
    }

    private Object visitManyDataCommand(InvocationContext ctx, FlagAffectedCommand command, Collection<?> keys) throws Throwable {
        for (Object key : keys) {
            this.loadIfNeeded(ctx, key, command);
        }
        return this.invokeNext(ctx, command);
    }

    private Object visitDataCommand(InvocationContext ctx, AbstractDataCommand command) throws Throwable {
        Object key = command.getKey();
        if (key != null) {
            this.loadIfNeeded(ctx, key, command);
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitGetKeysInGroupCommand(final InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        String groupName = command.getGroupName();
        if (!command.isGroupOwner() || this.hasSkipLoadFlag(command)) {
            return this.invokeNext(ctx, command);
        }
        CompositeKeyFilter keyFilter = new CompositeKeyFilter(new GroupFilter(groupName, this.groupManager), new CollectionKeyFilter<Object>(ctx.getLookedUpEntries().keySet()));
        this.persistenceManager.processOnAllStores(keyFilter, new AdvancedCacheLoader.CacheLoaderTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processEntry(MarshalledEntry marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                InvocationContext invocationContext = ctx;
                synchronized (invocationContext) {
                    CacheLoaderInterceptor.this.entryFactory.wrapExternalEntry(ctx, marshalledEntry.getKey(), PersistenceUtil.convert(marshalledEntry, CacheLoaderInterceptor.this.iceFactory), true, false);
                }
            }
        }, true, true);
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            if (this.hasSkipLoadFlag(command)) {
                return rv;
            }
            CacheSet entrySet = (CacheSet)rv;
            return new WrappedEntrySet(command, entrySet);
        });
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            if (this.hasSkipLoadFlag(command)) {
                return rv;
            }
            CacheSet keySet = (CacheSet)rv;
            return new WrappedKeySet(command, keySet);
        });
    }

    @Override
    public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        return this.visitManyDataCommand(ctx, command, command.getKeys());
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.visitDataCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        return this.visitManyDataCommand(ctx, command, command.getAffectedKeys());
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        return this.visitManyDataCommand(ctx, command, command.getAffectedKeys());
    }

    protected final boolean isConditional(WriteCommand cmd) {
        return cmd.isConditional();
    }

    protected final boolean hasSkipLoadFlag(FlagAffectedCommand cmd) {
        return cmd.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD);
    }

    protected boolean canLoad(Object key) {
        return true;
    }

    protected final Boolean loadIfNeeded(InvocationContext ctx, Object key, FlagAffectedCommand cmd) {
        if (this.skipLoad(cmd, key, ctx)) {
            return null;
        }
        return this.loadInContext(ctx, key, cmd);
    }

    private Boolean loadInContext(InvocationContext ctx, Object key, FlagAffectedCommand cmd) {
        AtomicReference<Boolean> isLoaded = new AtomicReference<Boolean>();
        InternalCacheEntry<Object, V> entry = PersistenceUtil.loadAndStoreInDataContainer(this.dataContainer, this.persistenceManager, key, ctx, this.timeService, isLoaded);
        Boolean isLoadedValue = isLoaded.get();
        if (trace) {
            log.tracef("Entry was loaded? %s", (Object)isLoadedValue);
        }
        if (this.getStatisticsEnabled() && isLoadedValue != null) {
            if (isLoadedValue.booleanValue()) {
                this.cacheLoads.incrementAndGet();
            } else {
                this.cacheMisses.incrementAndGet();
            }
        }
        if (entry != null) {
            this.entryFactory.wrapExternalEntry(ctx, key, entry, true, cmd instanceof WriteCommand);
            if (isLoadedValue != null && isLoadedValue.booleanValue()) {
                Object value = entry.getValue();
                this.sendNotification(key, value, true, ctx, cmd);
                this.sendNotification(key, value, false, ctx, cmd);
            }
        }
        return isLoadedValue;
    }

    private boolean skipLoad(FlagAffectedCommand cmd, Object key, InvocationContext ctx) {
        boolean skip;
        CacheEntry e = ctx.lookupEntry(key);
        if (e == null) {
            if (trace) {
                log.tracef("Skip load for command %s. Entry is not in the context.", (Object)cmd);
            }
            return true;
        }
        if (e.getValue() != null) {
            if (trace) {
                log.tracef("Skip load for command %s. Entry %s (skipLookup=%s) has non-null value.", (Object)cmd, (Object)e, (Object)e.skipLookup());
            }
            return true;
        }
        if (e.skipLookup()) {
            if (trace) {
                log.tracef("Skip load for command %s. Entry %s (skipLookup=%s) is set to skip lookup.", (Object)cmd, (Object)e, (Object)e.skipLookup());
            }
            return true;
        }
        if (!this.canLoad(key)) {
            if (trace) {
                log.tracef("Skip load for command %s. Cannot load the key.", (Object)cmd);
            }
            return true;
        }
        if (cmd instanceof WriteCommand) {
            skip = this.skipLoadForWriteCommand((WriteCommand)cmd, key, ctx);
            if (trace) {
                log.tracef("Skip load for write command %s? %s", (Object)cmd, (Object)skip);
            }
        } else {
            skip = this.hasSkipLoadFlag(cmd);
            if (trace) {
                log.tracef("Skip load for command %s?. %s", (Object)cmd, (Object)skip);
            }
        }
        return skip;
    }

    protected boolean skipLoadForWriteCommand(WriteCommand cmd, Object key, InvocationContext ctx) {
        if (cmd.loadType() != VisitableCommand.LoadType.DONT_LOAD) {
            if (this.hasSkipLoadFlag(cmd)) {
                log.tracef("Skipping load for command that reads existing values %s", (Object)cmd);
                return true;
            }
            return false;
        }
        return true;
    }

    protected void sendNotification(Object key, Object value, boolean pre, InvocationContext ctx, FlagAffectedCommand cmd) {
        this.notifier.notifyCacheEntryLoaded(key, value, pre, ctx, cmd);
        if (this.activation) {
            this.notifier.notifyCacheEntryActivated(key, value, pre, ctx, cmd);
        }
    }

    @ManagedAttribute(description="Number of entries loaded from cache store", displayName="Number of cache store loads", measurementType=MeasurementType.TRENDSUP)
    public long getCacheLoaderLoads() {
        return this.cacheLoads.get();
    }

    @ManagedAttribute(description="Number of entries that did not exist in cache store", displayName="Number of cache store load misses", measurementType=MeasurementType.TRENDSUP)
    public long getCacheLoaderMisses() {
        return this.cacheMisses.get();
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset Statistics")
    public void resetStatistics() {
        this.cacheLoads.set(0L);
        this.cacheMisses.set(0L);
    }

    @ManagedAttribute(description="Returns a collection of cache loader types which are configured and enabled", displayName="Returns a collection of cache loader types which are configured and enabled", displayType=DisplayType.DETAIL)
    public Collection<String> getStores() {
        if (this.cacheConfiguration.persistence().usingStores()) {
            return this.persistenceManager.getStoresAsString();
        }
        return Collections.emptySet();
    }

    @ManagedOperation(description="Disable all stores of a given type, where type is a fully qualified class name of the cache loader to disable", displayName="Disable all stores of a given type")
    public void disableStore(@Parameter(name="storeType", description="Fully qualified class name of a store implementation") String storeType) {
        this.persistenceManager.disableStore(storeType);
    }

    private class WrappedKeySet
    extends AbstractDelegatingKeyCacheSet<K, V> {
        private final CacheSet<K> keySet;

        public WrappedKeySet(KeySetCommand command, CacheSet<K> keySet) {
            super(Caches.getCacheWithFlags(CacheLoaderInterceptor.this.cache, command), keySet);
            this.keySet = keySet;
        }

        @Override
        public CloseableIterator<K> iterator() {
            CloseableIterator iterator = Closeables.iterator(this.keySet.stream());
            HashSet seenKeys = new HashSet(CacheLoaderInterceptor.this.cache.getAdvancedCache().getDataContainer().size());
            return new DistinctKeyDoubleEntryCloseableIterator(iterator, new CloseableSuppliedIterator(new SupplierFunction(new PersistenceManagerCloseableSupplier(CacheLoaderInterceptor.this.executorService, CacheLoaderInterceptor.this.persistenceManager, CacheLoaderInterceptor.this.iceFactory, new CollectionKeyFilter(seenKeys), 10L, TimeUnit.SECONDS, 2048))), Function.identity(), seenKeys);
        }

        @Override
        public CloseableSpliterator<K> spliterator() {
            return this.spliteratorFromIterator((CloseableIterator)this.iterator());
        }

        private <E> CloseableSpliterator<E> spliteratorFromIterator(CloseableIterator<E> iterator) {
            return new IteratorAsSpliterator.Builder<E>(iterator).setCharacteristics(4353).get();
        }

        @Override
        public int size() {
            long size = this.stream().count();
            if (size > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)size;
        }
    }

    private class WrappedEntrySet
    extends AbstractDelegatingEntryCacheSet<K, V> {
        private final CacheSet<CacheEntry<K, V>> entrySet;

        public WrappedEntrySet(EntrySetCommand command, CacheSet<CacheEntry<K, V>> entrySet) {
            super(Caches.getCacheWithFlags(CacheLoaderInterceptor.this.cache, command), entrySet);
            this.entrySet = entrySet;
        }

        long calculateTimeoutSeconds() {
            int minimum = 10;
            int size = CacheLoaderInterceptor.this.dataContainer.sizeIncludingExpired();
            if (size < 10000) {
                return minimum;
            }
            return Math.round(Math.log1p(size) * 10.0);
        }

        @Override
        public CloseableIterator<CacheEntry<K, V>> iterator() {
            CloseableIterator iterator = Closeables.iterator(this.entrySet.stream());
            HashSet seenKeys = new HashSet(CacheLoaderInterceptor.this.cache.getAdvancedCache().getDataContainer().size());
            return new DistinctKeyDoubleEntryCloseableIterator<CacheEntry, Object>(iterator, new CloseableSuppliedIterator(new PersistenceManagerCloseableSupplier(CacheLoaderInterceptor.this.executorService, CacheLoaderInterceptor.this.persistenceManager, CacheLoaderInterceptor.this.iceFactory, new CollectionKeyFilter(seenKeys), this.calculateTimeoutSeconds(), TimeUnit.SECONDS, 2048)), CacheEntry::getKey, seenKeys);
        }

        @Override
        public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
            return this.spliteratorFromIterator((CloseableIterator)this.iterator());
        }

        private <E> CloseableSpliterator<E> spliteratorFromIterator(CloseableIterator<E> iterator) {
            return new IteratorAsSpliterator.Builder<E>(iterator).setCharacteristics(4353).get();
        }

        @Override
        public int size() {
            long size = this.stream().count();
            if (size > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)size;
        }
    }

    class SupplierFunction<K, V>
    implements CloseableSupplier<K> {
        private final CloseableSupplier<CacheEntry<K, V>> supplier;

        SupplierFunction(CloseableSupplier<CacheEntry<K, V>> supplier) {
            this.supplier = supplier;
        }

        @Override
        public K get() {
            CacheEntry entry = (CacheEntry)this.supplier.get();
            if (entry != null) {
                return entry.getKey();
            }
            return null;
        }

        @Override
        public void close() {
            this.supplier.close();
        }
    }
}

