/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.Serializable;
import org.infinispan.marshall.core.ExternalPojo;

final class ExternallyMarshallable {
    private ExternallyMarshallable() {
    }

    public static boolean isAllowed(Object obj) {
        Class<?> clazz = obj.getClass();
        return ExternallyMarshallable.isAllowed(clazz);
    }

    public static boolean isAllowed(Class<?> clazz) {
        Package pkg = clazz.getPackage();
        if (pkg == null) {
            if (clazz.isArray()) {
                return true;
            }
            throw new IllegalStateException("No package info for " + clazz + ", runtime-generated class?");
        }
        String pkgName = pkg.getName();
        boolean isBlackList = Serializable.class.isAssignableFrom(clazz) && ExternallyMarshallable.isMarshallablePackage(pkgName) && !ExternalPojo.class.isAssignableFrom(clazz) && !ExternallyMarshallable.isWhiteList(clazz.getName());
        return !isBlackList;
    }

    private static boolean isMarshallablePackage(String pkg) {
        return pkg.startsWith("java.") || pkg.startsWith("org.infinispan.") || pkg.startsWith("org.jgroups.") || pkg.startsWith("org.hibernate") || pkg.startsWith("org.apache") || pkg.startsWith("org.jboss") || pkg.startsWith("com.arjuna");
    }

    private static boolean isWhiteList(String className) {
        return className.endsWith("Exception") || className.contains("$$Lambda$") || className.equals("java.lang.Class") || className.equals("java.time.Instant") || className.equals("org.hibernate.search.query.engine.impl.LuceneHSQuery") || className.equals("org.infinispan.distexec.RunnableAdapter") || className.equals("org.infinispan.jcache.annotation.DefaultCacheKey") || className.equals("org.infinispan.query.clustered.QueryResponse") || className.equals("org.infinispan.server.core.transport.NettyTransport$ConnectionAdderTask") || className.equals("org.infinispan.server.hotrod.CheckAddressTask") || className.equals("org.infinispan.server.infinispan.task.DistributedServerTask") || className.equals("org.infinispan.scripting.impl.DataType") || className.equals("org.infinispan.scripting.impl.DistributedScript") || className.equals("org.infinispan.stats.impl.ClusterCacheStatsImpl$DistributedCacheStatsCallable") || className.equals("org.infinispan.xsite.BackupSender$TakeSiteOfflineResponse") || className.equals("org.infinispan.xsite.BackupSender$BringSiteOnlineResponse") || className.equals("org.infinispan.xsite.XSiteAdminCommand$Status") || className.equals("org.infinispan.util.logging.events.EventLogLevel") || className.equals("org.infinispan.util.logging.events.EventLogCategory") || className.equals("java.util.Date") || className.equals("java.lang.Byte") || className.equals("java.lang.Integer") || className.equals("java.lang.Double") || className.equals("java.lang.Short") || className.equals("java.lang.Long") || className.startsWith("org.infinispan.test") || className.startsWith("org.infinispan.server.test") || className.startsWith("org.infinispan.it") || className.startsWith("org.infinispan.all") || className.startsWith("org.infinispan.query.api") || className.contains("org.jboss.as.quickstarts.datagrid");
    }
}

