/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.UnknownFieldSet;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.MessageMarshallerDelegate;
import org.infinispan.protostream.impl.RawProtoStreamReaderImpl;
import org.infinispan.protostream.impl.ReadMessageContext;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.infinispan.protostream.impl.WireFormat;
import org.jboss.logging.Logger;

final class ProtoStreamReaderImpl
implements MessageMarshaller.ProtoStreamReader {
    private static final Log log = Log.LogFactory.getLog(ProtoStreamReaderImpl.class);
    private static final EnumSet<Type> primitiveTypes = EnumSet.of(Type.DOUBLE, new Type[]{Type.FLOAT, Type.INT64, Type.UINT64, Type.INT32, Type.FIXED64, Type.FIXED32, Type.BOOL, Type.STRING, Type.BYTES, Type.UINT32, Type.SFIXED32, Type.SFIXED64, Type.SINT32, Type.SINT64});
    private final SerializationContextImpl ctx;
    private ReadMessageContext messageContext;

    ProtoStreamReaderImpl(SerializationContextImpl ctx) {
        this.ctx = ctx;
    }

    ReadMessageContext pushContext(FieldDescriptor fd, MessageMarshallerDelegate<?> marshallerDelegate, RawProtoStreamReader in) {
        this.messageContext = new ReadMessageContext(this.messageContext, fd == null ? null : fd.getName(), marshallerDelegate, in);
        return this.messageContext;
    }

    void popContext() {
        this.messageContext = (ReadMessageContext)this.messageContext.getParentContext();
    }

    UnknownFieldSet getUnknownFieldSet() {
        return this.messageContext.unknownFieldSet;
    }

    private Object readPrimitive(String fieldName, JavaType javaType) throws IOException {
        int tag;
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        Type type = fd.getType();
        if (type == Type.ENUM || type == Type.GROUP || type == Type.MESSAGE) {
            throw new IllegalArgumentException("Declared field type is not a primitive : " + fd.getFullName());
        }
        if (fd.getJavaType() != javaType) {
            throw new IllegalArgumentException("Declared field type is not of the expected type : " + fd.getFullName());
        }
        this.checkFieldRead(fd, false);
        int expectedTag = WireFormat.makeTag(fd.getNumber(), type.getWireType());
        Object o = this.messageContext.unknownFieldSet.consumeTag(expectedTag);
        if (o != null) {
            return this.convertWireTypeToJavaType(type, o);
        }
        RawProtoStreamReader in = this.messageContext.in;
        while ((tag = in.readTag()) != 0) {
            if (tag == expectedTag) {
                switch (type) {
                    case DOUBLE: {
                        return in.readDouble();
                    }
                    case FLOAT: {
                        return Float.valueOf(in.readFloat());
                    }
                    case BOOL: {
                        return in.readBool();
                    }
                    case STRING: {
                        return in.readString();
                    }
                    case BYTES: {
                        return in.readByteArray();
                    }
                    case INT32: {
                        return in.readInt32();
                    }
                    case SFIXED32: {
                        return in.readSFixed32();
                    }
                    case FIXED32: {
                        return in.readFixed32();
                    }
                    case UINT32: {
                        return in.readUInt32();
                    }
                    case SINT32: {
                        return in.readSInt32();
                    }
                    case INT64: {
                        return in.readInt64();
                    }
                    case UINT64: {
                        return in.readUInt64();
                    }
                    case FIXED64: {
                        return in.readFixed64();
                    }
                    case SFIXED64: {
                        return in.readSFixed64();
                    }
                    case SINT64: {
                        return in.readSInt64();
                    }
                }
                throw new IOException("Unexpected field type : " + (Object)((Object)type));
            }
            this.messageContext.unknownFieldSet.readSingleField(tag, in);
        }
        if (fd.hasDefaultValue()) {
            return fd.getDefaultValue();
        }
        if (fd.isRequired()) {
            throw new IOException("Field " + fd.getFullName() + " is required but is not present in the stream");
        }
        return null;
    }

    private Object convertWireTypeToJavaType(Type type, Object o) {
        switch (type) {
            case STRING: {
                try {
                    o = new String((byte[])o, "UTF-8");
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("UTF-8 not supported", e);
                }
            }
            case BYTES: {
                o = (byte[])o;
                break;
            }
            case INT32: 
            case UINT32: 
            case SINT32: {
                o = ((Long)o).intValue();
                break;
            }
            case SFIXED32: 
            case FIXED32: {
                o = (Integer)o;
                break;
            }
            case INT64: 
            case UINT64: 
            case FIXED64: 
            case SFIXED64: 
            case SINT64: {
                o = (Long)o;
                break;
            }
            case BOOL: {
                o = (Long)o != 0L;
                break;
            }
            case FLOAT: {
                o = Float.valueOf(Float.intBitsToFloat((Integer)o));
                break;
            }
            case DOUBLE: {
                o = Double.longBitsToDouble((Long)o);
            }
        }
        return o;
    }

    @Override
    public ImmutableSerializationContext getSerializationContext() {
        return this.ctx;
    }

    @Override
    public Integer readInt(String fieldName) throws IOException {
        return (Integer)this.readPrimitive(fieldName, JavaType.INT);
    }

    @Override
    public int[] readInts(String fieldName) throws IOException {
        List values = this.readCollection(fieldName, new ArrayList(), Integer.class);
        int[] result = new int[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            result[i] = (Integer)values.get(i);
        }
        return result;
    }

    @Override
    public Long readLong(String fieldName) throws IOException {
        return (Long)this.readPrimitive(fieldName, JavaType.LONG);
    }

    @Override
    public long[] readLongs(String fieldName) throws IOException {
        List values = this.readCollection(fieldName, new ArrayList(), Long.class);
        long[] result = new long[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            result[i] = (Long)values.get(i);
        }
        return result;
    }

    @Override
    public Date readDate(String fieldName) throws IOException {
        Long tstamp = this.readLong(fieldName);
        return tstamp == null ? null : new Date(tstamp);
    }

    @Override
    public Instant readInstant(String fieldName) throws IOException {
        Long tstamp = this.readLong(fieldName);
        return tstamp == null ? null : Instant.ofEpochMilli(tstamp);
    }

    @Override
    public Float readFloat(String fieldName) throws IOException {
        return (Float)this.readPrimitive(fieldName, JavaType.FLOAT);
    }

    @Override
    public float[] readFloats(String fieldName) throws IOException {
        List values = this.readCollection(fieldName, new ArrayList(), Float.class);
        float[] result = new float[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            result[i] = ((Float)values.get(i)).floatValue();
        }
        return result;
    }

    @Override
    public Double readDouble(String fieldName) throws IOException {
        return (Double)this.readPrimitive(fieldName, JavaType.DOUBLE);
    }

    @Override
    public double[] readDoubles(String fieldName) throws IOException {
        List values = this.readCollection(fieldName, new ArrayList(), Double.class);
        double[] result = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            result[i] = (Double)values.get(i);
        }
        return result;
    }

    @Override
    public Boolean readBoolean(String fieldName) throws IOException {
        return (Boolean)this.readPrimitive(fieldName, JavaType.BOOLEAN);
    }

    @Override
    public boolean[] readBooleans(String fieldName) throws IOException {
        List values = this.readCollection(fieldName, new ArrayList(), Boolean.class);
        boolean[] result = new boolean[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            result[i] = (Boolean)values.get(i);
        }
        return result;
    }

    @Override
    public String readString(String fieldName) throws IOException {
        return (String)this.readPrimitive(fieldName, JavaType.STRING);
    }

    @Override
    public byte[] readBytes(String fieldName) throws IOException {
        return (byte[])this.readPrimitive(fieldName, JavaType.BYTE_STRING);
    }

    @Override
    public InputStream readBytesAsInputStream(String fieldName) throws IOException {
        byte[] bytes = this.readBytes(fieldName);
        return bytes != null ? new ByteArrayInputStream(bytes) : null;
    }

    @Override
    public <E extends Enum<E>> E readEnum(String fieldName, Class<E> clazz) throws IOException {
        return (E)((Enum)this.readObject(fieldName, clazz));
    }

    @Override
    public <E> E readObject(String fieldName, Class<E> clazz) throws IOException {
        int tag;
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldRead(fd, false);
        if (fd.getType() == Type.ENUM) {
            return this.ctx.getMarshallerDelegate(clazz).unmarshall(fd, this, this.messageContext.in);
        }
        int expectedTag = WireFormat.makeTag(fd.getNumber(), fd.getType().getWireType());
        Object o = this.messageContext.unknownFieldSet.consumeTag(expectedTag);
        if (o != null) {
            byte[] byteArray = (byte[])o;
            return this.readNestedObject(fd, clazz, RawProtoStreamReaderImpl.newInstance(byteArray), byteArray.length);
        }
        while ((tag = this.messageContext.in.readTag()) != 0) {
            if (tag == expectedTag) {
                return this.readNestedObject(fd, clazz, this.messageContext.in, -1);
            }
            this.messageContext.unknownFieldSet.readSingleField(tag, this.messageContext.in);
        }
        return null;
    }

    private <A> A readNestedObject(FieldDescriptor fd, Class<A> clazz, RawProtoStreamReader in, int length) throws IOException {
        A a;
        BaseMarshallerDelegate<A> marshallerDelegate = this.ctx.getMarshallerDelegate(clazz);
        if (fd.getType() == Type.GROUP) {
            a = marshallerDelegate.unmarshall(fd, this, in);
            in.checkLastTagWas(WireFormat.makeTag(fd.getNumber(), 4));
        } else if (fd.getType() == Type.MESSAGE) {
            if (length < 0) {
                length = in.readRawVarint32();
            }
            int oldLimit = in.pushLimit(length);
            a = marshallerDelegate.unmarshall(fd, this, in);
            in.checkLastTagWas(0);
            in.popLimit(oldLimit);
        } else {
            throw new IllegalArgumentException("Declared field type is not a message or an enum : " + fd.getFullName());
        }
        return a;
    }

    @Override
    public <E, C extends Collection<? super E>> C readCollection(String fieldName, C collection, Class<E> elementClass) throws IOException {
        int tag;
        Object o;
        FieldDescriptor fd = this.messageContext.marshallerDelegate.getFieldByName(fieldName);
        this.checkFieldRead(fd, true);
        if (primitiveTypes.contains((Object)fd.getType())) {
            this.readPrimitiveCollection(fd, collection, elementClass);
            return collection;
        }
        int expectedTag = WireFormat.makeTag(fd.getNumber(), fd.getType().getWireType());
        while ((o = this.messageContext.unknownFieldSet.consumeTag(expectedTag)) != null) {
            byte[] byteArray = (byte[])o;
            RawProtoStreamReader in = RawProtoStreamReaderImpl.newInstance(byteArray);
            collection.add(this.readNestedObject(fd, elementClass, in, byteArray.length));
        }
        while ((tag = this.messageContext.in.readTag()) != 0) {
            if (tag == expectedTag) {
                collection.add(this.readNestedObject(fd, elementClass, this.messageContext.in, -1));
                continue;
            }
            this.messageContext.unknownFieldSet.readSingleField(tag, this.messageContext.in);
        }
        return collection;
    }

    private void readPrimitiveCollection(FieldDescriptor fd, Collection<? super Object> collection, Class<?> elementClass) throws IOException {
        int tag;
        Object o;
        int expectedTag = WireFormat.makeTag(fd.getNumber(), fd.getType().getWireType());
        Type type = fd.getType();
        while ((o = this.messageContext.unknownFieldSet.consumeTag(expectedTag)) != null) {
            collection.add(this.convertWireTypeToJavaType(type, o));
        }
        while ((tag = this.messageContext.in.readTag()) != 0) {
            if (tag == expectedTag) {
                Object value;
                switch (type) {
                    case DOUBLE: {
                        value = this.messageContext.in.readDouble();
                        break;
                    }
                    case FLOAT: {
                        value = Float.valueOf(this.messageContext.in.readFloat());
                        break;
                    }
                    case BOOL: {
                        value = this.messageContext.in.readBool();
                        break;
                    }
                    case STRING: {
                        value = this.messageContext.in.readString();
                        break;
                    }
                    case BYTES: {
                        value = this.messageContext.in.readByteArray();
                        break;
                    }
                    case INT64: {
                        value = this.messageContext.in.readInt64();
                        break;
                    }
                    case UINT64: {
                        value = this.messageContext.in.readUInt64();
                        break;
                    }
                    case FIXED64: {
                        value = this.messageContext.in.readFixed64();
                        break;
                    }
                    case SFIXED64: {
                        value = this.messageContext.in.readSFixed64();
                        break;
                    }
                    case SINT64: {
                        value = this.messageContext.in.readSInt64();
                        break;
                    }
                    case INT32: {
                        value = this.messageContext.in.readInt32();
                        break;
                    }
                    case FIXED32: {
                        value = this.messageContext.in.readFixed32();
                        break;
                    }
                    case UINT32: {
                        value = this.messageContext.in.readUInt32();
                        break;
                    }
                    case SFIXED32: {
                        value = this.messageContext.in.readSFixed32();
                        break;
                    }
                    case SINT32: {
                        value = this.messageContext.in.readSInt32();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected field type : " + (Object)((Object)type));
                    }
                }
                collection.add(value);
                continue;
            }
            this.messageContext.unknownFieldSet.readSingleField(tag, this.messageContext.in);
        }
    }

    @Override
    public <E> E[] readArray(String fieldName, Class<? extends E> elementClass) throws IOException {
        List values = this.readCollection(fieldName, new ArrayList(), elementClass);
        return values.toArray((Object[])Array.newInstance(elementClass, values.size()));
    }

    private void checkFieldRead(FieldDescriptor fd, boolean expectRepeated) {
        if (expectRepeated) {
            if (!fd.isRepeated()) {
                throw new IllegalArgumentException("This field is not repeated and cannot be read with the methods intended for collections or arrays: " + fd.getFullName());
            }
        } else if (fd.isRepeated()) {
            throw new IllegalArgumentException("A repeated field should be read with one of the methods intended for collections or arrays: " + fd.getFullName());
        }
        if (!this.messageContext.markField(fd.getNumber())) {
            throw new IllegalStateException("A field cannot be read twice : " + fd.getFullName());
        }
        if (this.ctx.getConfiguration().logOutOfSequenceReads() && log.isEnabled(Logger.Level.WARN) && this.messageContext.getMaxSeenFieldNumber() > fd.getNumber()) {
            log.fieldReadOutOfSequence(fd.getFullName());
        }
    }
}

