package org.jgroups.tests;

import java.security.*;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla2  {
    protected SecureRandom random;
    protected KeyPair pair;
    protected PrivateKey priv;
    protected PublicKey pub;
    protected static final byte[] message="hello world from Bela Ban".getBytes(); // to be signed

    protected void start() throws Exception {
        KeyPairGenerator keyGen=KeyPairGenerator.getInstance("DSA");
        random = SecureRandom.getInstance("SHA1PRNG");
        keyGen.initialize(1024, random);
        pair = keyGen.generateKeyPair();
        priv = pair.getPrivate();
        pub = pair.getPublic();

        Signature dsa = Signature.getInstance("SHA1withDSA");
        dsa.initSign(priv);
        dsa.update(message);
        byte[] signature=dsa.sign();
        System.out.printf("signature (%d bytes): %s\n", signature.length, Arrays.toString(signature));


        // now 'send' the following items to the receiver: (1) message, (2) signature and (3) public key
        byte[] public_key=pub.getEncoded();
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(public_key);
        System.out.println("pubKeySpec = " + pubKeySpec);

        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
        System.out.println("pubKey = " + pubKey);

        Signature sig = Signature.getInstance("SHA1withDSA");
        sig.initVerify(pubKey);
        sig.update(message);

        boolean verified=sig.verify(signature);
        System.out.println("verified = " + verified);
    }

    public static void main(String[] args) throws Exception {
        new bla2().start();
    }



}



