package org.jgroups.tests;

import javax.crypto.Cipher;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.util.Enumeration;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla7 {
    protected KeyStore store;
     //protected String keystore_type="JKS";
     //protected String keystore="/home/bela/keys/mykeystore.jks";

    // protected String keystore_type="PKCS12";
    // protected String keystore="/home/bela/keystore.p12";
    protected String keystore_type="JCEKS";
    protected String keystore="/home/bela/JGroups/keystore/defaultStore.keystore";

    protected String pwd="changeit";
    protected String alias="mykey";
    protected String sym_algorithm;
    protected Cipher encrypter, decrypter;

    protected void start() throws Exception {
        store=KeyStore.getInstance(keystore_type != null? keystore_type : KeyStore.getDefaultType());
        try(InputStream in=new FileInputStream(keystore)) {
            store.load(in, pwd.toCharArray());
        }

        Enumeration<String> en=store.aliases();
        while(en.hasMoreElements())
            System.out.printf("alias: %s\n", en.nextElement());

        Key secret_key=store.getKey(alias, pwd.toCharArray());
        // Key secret_key=KeyGenerator.getInstance("AES").generateKey();

        //Certificate cert=store.getCertificate(alias);
        //PublicKey pub_key=cert.getPublicKey();


        sym_algorithm=secret_key.getAlgorithm();
        // sym_algorithm="AES/CBC/PKCS5PADDING";

        System.out.printf("sym_algorithm=%s\n", sym_algorithm);

        // encrypter=createCipher(Cipher.ENCRYPT_MODE, pub_key, sym_algorithm); // works with asymmetric encryption (e.g. RSA)
        encrypter=createCipher(Cipher.ENCRYPT_MODE, secret_key, sym_algorithm);
        decrypter=createCipher(Cipher.DECRYPT_MODE, secret_key, sym_algorithm);

        String secret_info="this is highly classified information";
        byte[] input_buf=secret_info.getBytes();

        byte[] encrypted=encrypt(input_buf, 0, input_buf.length);
        byte[] decrypted=decrypt(encrypted, 0, encrypted.length);
        String decrypted_info=new String(decrypted);
        System.out.println("decrypted_info = " + decrypted_info);
    }


    protected byte[] encrypt(byte[] buf, int offset, int length) throws Exception {
        return encrypter.doFinal(buf, offset, length);
    }

    protected byte[] decrypt(byte[] buf, int offset, int length) throws Exception {
        return decrypter.doFinal(buf, offset, length);
    }


    protected static Cipher createCipher(int mode, Key secret_key, String algorithm) throws Exception {
        Cipher cipher=Cipher.getInstance(algorithm);
        cipher.init(mode, secret_key);
        return cipher;
    }



    public static void main(String[] args) throws Exception {
        new bla7().start();
    }
}
