/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.cache.L1Configuration;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.configuration.cache.SyncConfiguration;

public class ClusteringConfiguration {
    public static final AttributeDefinition<CacheMode> CACHE_MODE = AttributeDefinition.builder("cacheMode", CacheMode.LOCAL).immutable().build();
    public static final AttributeDefinition<Long> REMOTE_TIMEOUT = AttributeDefinition.builder("remoteTimeout", TimeUnit.SECONDS.toMillis(15L)).build();
    public static final AttributeDefinition<Integer> INVALIDATION_BATCH_SIZE = AttributeDefinition.builder("invalidationBatchSize", 128).immutable().build();
    private final Attribute<CacheMode> cacheMode;
    private final HashConfiguration hashConfiguration;
    private final L1Configuration l1Configuration;
    private final StateTransferConfiguration stateTransferConfiguration;
    private final SyncConfiguration syncConfiguration;
    private final PartitionHandlingConfiguration partitionHandlingConfiguration;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ClusteringConfiguration.class, CACHE_MODE, REMOTE_TIMEOUT, INVALIDATION_BATCH_SIZE);
    }

    ClusteringConfiguration(AttributeSet attributes, HashConfiguration hashConfiguration, L1Configuration l1Configuration, StateTransferConfiguration stateTransferConfiguration, SyncConfiguration syncConfiguration, PartitionHandlingConfiguration partitionHandlingStrategy) {
        this.attributes = attributes.checkProtection();
        this.cacheMode = attributes.attribute(CACHE_MODE);
        this.hashConfiguration = hashConfiguration;
        this.l1Configuration = l1Configuration;
        this.stateTransferConfiguration = stateTransferConfiguration;
        this.syncConfiguration = syncConfiguration;
        this.partitionHandlingConfiguration = partitionHandlingStrategy;
    }

    public CacheMode cacheMode() {
        return this.cacheMode.get();
    }

    public long remoteTimeout() {
        return this.syncConfiguration.replTimeout();
    }

    public void remoteTimeout(long timeoutMillis) {
        this.syncConfiguration.replTimeout(timeoutMillis);
    }

    public PartitionHandlingConfiguration partitionHandling() {
        return this.partitionHandlingConfiguration;
    }

    public String cacheModeString() {
        return this.cacheMode() == null ? "none" : this.cacheMode().toString();
    }

    public int invalidationBatchSize() {
        return this.attributes.attribute(INVALIDATION_BATCH_SIZE).get();
    }

    public HashConfiguration hash() {
        return this.hashConfiguration;
    }

    public L1Configuration l1() {
        return this.l1Configuration;
    }

    @Deprecated
    public SyncConfiguration sync() {
        return this.syncConfiguration;
    }

    public StateTransferConfiguration stateTransfer() {
        return this.stateTransferConfiguration;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "ClusteringConfiguration [hashConfiguration=" + this.hashConfiguration + ", l1Configuration=" + this.l1Configuration + ", stateTransferConfiguration=" + this.stateTransferConfiguration + ", syncConfiguration=" + this.syncConfiguration + ", partitionHandlingConfiguration=" + this.partitionHandlingConfiguration + ", attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusteringConfiguration other = (ClusteringConfiguration)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.hashConfiguration == null ? other.hashConfiguration != null : !this.hashConfiguration.equals(other.hashConfiguration)) {
            return false;
        }
        if (this.l1Configuration == null ? other.l1Configuration != null : !this.l1Configuration.equals(other.l1Configuration)) {
            return false;
        }
        if (this.partitionHandlingConfiguration == null ? other.partitionHandlingConfiguration != null : !this.partitionHandlingConfiguration.equals(other.partitionHandlingConfiguration)) {
            return false;
        }
        if (this.stateTransferConfiguration == null ? other.stateTransferConfiguration != null : !this.stateTransferConfiguration.equals(other.stateTransferConfiguration)) {
            return false;
        }
        return !(this.syncConfiguration == null ? other.syncConfiguration != null : !this.syncConfiguration.equals(other.syncConfiguration));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.hashConfiguration == null ? 0 : this.hashConfiguration.hashCode());
        result = 31 * result + (this.l1Configuration == null ? 0 : this.l1Configuration.hashCode());
        result = 31 * result + (this.partitionHandlingConfiguration == null ? 0 : this.partitionHandlingConfiguration.hashCode());
        result = 31 * result + (this.stateTransferConfiguration == null ? 0 : this.stateTransferConfiguration.hashCode());
        result = 31 * result + (this.syncConfiguration == null ? 0 : this.syncConfiguration.hashCode());
        return result;
    }
}

