package org.jgroups.tests;

import org.jgroups.JChannel;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.util.TimeScheduler;

import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla extends ReceiverAdapter {
    protected JChannel            ch;
    protected String              name;
    protected static final String props="/home/bela/fast.xml";
    protected static final long   SLEEP_TIME=15000;
    protected TimeScheduler       timer;
    protected Future<?>           rejoin_task;
    protected Runnable            rejoin_function=() -> {
        System.out.printf("[%s] disconnecting\n", ch.getAddress());
        ch.disconnect();
        try {
            System.out.printf("reconnecting\n");
            ch.connect("demo");
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    };

    protected void start(String name) throws Exception {
        this.name=name;
        createChannel();
    }

    protected void createChannel() throws Exception {
        ch=new JChannel(props).name(name).setReceiver(this);
        timer=ch.getProtocolStack().getTransport().getTimer();
        ch.connect("demo");
    }

    public void viewAccepted(View view) {
        System.out.printf("-- view: %s, address: %s\n", view, ch.getAddress());

        if(Objects.equals(view.getCoord(), ch.getAddress())) {
            if(rejoin_task == null || rejoin_task.isDone()) {
                System.out.printf("I'm the coordinator, starting rejoin task\n");
                rejoin_task=timer.schedule(rejoin_function, SLEEP_TIME, TimeUnit.MILLISECONDS);
            }
        }
        else {
            if(rejoin_task != null) {
                rejoin_task.cancel(false);
                rejoin_task=null;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new bla().start(args[0]);
    }




}



