package org.jgroups.tests;

import org.jgroups.JChannel;
import org.jgroups.ReceiverAdapter;
import org.jgroups.blocks.locking.LockService;
import org.jgroups.protocols.Locking;
import org.jgroups.util.Util;

import java.util.concurrent.locks.Lock;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla extends ReceiverAdapter {
    protected JChannel            ch, coord;
    protected LockService         lock_service, coord_lock_service;
    protected static final String props="/home/bela/lock.xml";

    protected void start(String name) throws Exception {
        coord=new JChannel(props).name("coord");
        coord_lock_service=new LockService(coord);
        coord.connect("demo");

        ch=new JChannel(props).name(name);
        lock_service=new LockService(ch);
        Locking locking=ch.getProtocolStack().findProtocol(Locking.class);
        ch.connect("demo");

        System.out.printf("view: %s\n", ch.getView());

        final Lock lock=lock_service.getLock("mylock");

        Thread one=new Thread(() -> {
            lock.lock();
            try {
                System.out.printf("%d: locked %s\n", Thread.currentThread().getId(), lock);
                Util.sleep(2000);
            }
            finally {
                lock.unlock();
                System.out.printf("%d: unlocked %s\n", Thread.currentThread().getId(), lock);
            }
        });
        one.start();

        Util.sleep(500);
        Thread two=new Thread(() -> {
            lock.lock();
            try {
                System.out.printf("%d: locked %s\n", Thread.currentThread().getId(), lock);
                System.out.printf("lock_table (after two.lock()): %s\n", locking.printLocks());
            }
            finally {
                lock.unlock();
                System.out.printf("%d: unlocked %s\n", Thread.currentThread().getId(), lock);
            }
        });
        two.start();

        Util.sleep(500);

        System.out.printf("lock_table: %s\n", locking.printLocks());


        one.join();
        two.join();

        Util.close(ch, coord);
    }



    public static void main(String[] args) throws Exception {
        new bla().start(args[0]);
    }




}



