package org.jgroups.tests;


import java.net.*;
import java.nio.ByteBuffer;
import java.nio.channels.*;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla9 {

    public static void main(String[] args) throws Exception {
        InetAddress addr=InetAddress.getByName("232.5.5.5");
        NetworkInterface ni=NetworkInterface.getByName("en0");
        SocketAddress mcast_addr=new InetSocketAddress(addr, 7500);
        DatagramChannel ch=DatagramChannel.open(StandardProtocolFamily.INET)
          .setOption(StandardSocketOptions.SO_REUSEADDR, true)
          .bind(new InetSocketAddress(7500))
          .setOption(StandardSocketOptions.IP_MULTICAST_IF, ni);

        ch.connect(mcast_addr);
        // ch.connect(new InetSocketAddress("192.168.1.3", 5555));

        ch.configureBlocking(false);
        Selector sel=Selector.open();
        joinAll(ch, addr);

        ch.register(sel, SelectionKey.OP_READ);

        for(;;) {
            sel.select();
            Set<SelectionKey> keys=sel.selectedKeys();
            for(Iterator<SelectionKey> it=keys.iterator(); it.hasNext();) {
                SelectionKey key=it.next();
                it.remove();
                if(key.isReadable()) {
                    ByteBuffer[] buffers=new ByteBuffer[2];
                    for(int i=0; i < buffers.length; i++)
                        buffers[i]=ByteBuffer.allocate(10);
                    long num=ch.read(buffers);
                    System.out.println("num = " + num);

                    //ByteBuffer buffer=ByteBuffer.allocate(10);
                    //SocketAddress sender=ch.receive(buffer);
                    //System.out.printf("read from %s: %s\n", sender, new String(buffer.array()));
                }
            }
        }
    }


    protected static void joinAll(MulticastChannel mcast_sock, InetAddress mcast_addr) throws Exception {
        for(Enumeration<NetworkInterface> en=NetworkInterface.getNetworkInterfaces(); en.hasMoreElements();) {
            NetworkInterface ni=en.nextElement();
            MembershipKey key=mcast_sock.join(mcast_addr, ni);
            System.out.printf("joined %s on %s\n", mcast_addr, ni);
        }
    }
}
