/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalRolesConfigurationChildBuilder;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Role;
import org.infinispan.security.impl.CacheRoleImpl;

public class GlobalRoleConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements GlobalRolesConfigurationChildBuilder,
Builder<Role> {
    private Set<AuthorizationPermission> permissions = new HashSet<AuthorizationPermission>();
    private final GlobalAuthorizationConfigurationBuilder builder;
    private final String name;

    public GlobalRoleConfigurationBuilder(String name, GlobalAuthorizationConfigurationBuilder builder) {
        super(builder.getGlobalConfig());
        this.builder = builder;
        this.name = name;
    }

    public GlobalRoleConfigurationBuilder permission(String permission) {
        this.permissions.add(AuthorizationPermission.valueOf(permission));
        return this;
    }

    public GlobalRoleConfigurationBuilder permission(AuthorizationPermission permission) {
        this.permissions.add(permission);
        return this;
    }

    @Override
    public GlobalRoleConfigurationBuilder role(String name) {
        return this.builder.role(name);
    }

    @Override
    public void validate() {
    }

    @Override
    public Role create() {
        return new CacheRoleImpl(this.name, this.permissions);
    }

    @Override
    public Builder<?> read(Role template) {
        this.permissions.clear();
        this.permissions.addAll(template.getPermissions());
        return this;
    }
}

