/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.remoting.transport.Address;

public class RemoteMetadata
implements InternalMetadata {
    private final Address address;
    private final int topologyId;
    private final long version;

    public RemoteMetadata(Address address, EntryVersion version) {
        this.address = address;
        SimpleClusteredVersion scv = (SimpleClusteredVersion)version;
        this.topologyId = scv.topologyId;
        this.version = scv.version;
    }

    private RemoteMetadata(Address address, int topologyId, long version) {
        this.address = address;
        this.topologyId = topologyId;
        this.version = version;
    }

    public Address getAddress() {
        return this.address;
    }

    @Override
    public long created() {
        return -1L;
    }

    @Override
    public long lastUsed() {
        return -1L;
    }

    @Override
    public boolean isExpired(long now) {
        return false;
    }

    @Override
    public long expiryTime() {
        return -1L;
    }

    @Override
    public long lifespan() {
        return -1L;
    }

    @Override
    public long maxIdle() {
        return -1L;
    }

    @Override
    public EntryVersion version() {
        return new SimpleClusteredVersion(this.topologyId, this.version);
    }

    @Override
    public Metadata.Builder builder() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RemoteMetadata{");
        sb.append("address=").append(this.address);
        sb.append(", version=").append(this.version);
        sb.append('}');
        return sb.toString();
    }

    public static class Externalizer
    implements AdvancedExternalizer<RemoteMetadata> {
        @Override
        public Set<Class<? extends RemoteMetadata>> getTypeClasses() {
            return Util.asSet(RemoteMetadata.class);
        }

        @Override
        public Integer getId() {
            return 129;
        }

        @Override
        public void writeObject(ObjectOutput output, RemoteMetadata entry) throws IOException {
            output.writeObject(entry.getAddress());
            output.writeInt(entry.topologyId);
            output.writeLong(entry.version);
        }

        @Override
        public RemoteMetadata readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Address address = (Address)input.readObject();
            int topologyId = input.readInt();
            long version = input.readLong();
            return new RemoteMetadata(address, topologyId, version);
        }
    }
}

