/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors.namespace;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.namespace.CompositeNamespace;
import org.infinispan.protostream.descriptors.namespace.ExportedNamespace;
import org.infinispan.protostream.descriptors.namespace.ImportedNamespace;
import org.infinispan.protostream.descriptors.namespace.LocalNamespace;
import org.infinispan.protostream.descriptors.namespace.Namespace;

public final class FileNamespace
extends CompositeNamespace {
    private final FileDescriptor fileDescriptor;
    private final Map<String, GenericDescriptor> localDefinitions = new LinkedHashMap<String, GenericDescriptor>();
    private final LocalNamespace localNamespace;
    private final Namespace exportedNamespace;
    private final Namespace[] namespaces;

    public FileNamespace(FileDescriptor fileDescriptor, Collection<FileDescriptor> publicDependencies, Collection<FileDescriptor> privateDependencies) {
        this.fileDescriptor = fileDescriptor;
        this.localNamespace = new LocalNamespace(this.localDefinitions);
        ImportedNamespace publicImports = new ImportedNamespace(publicDependencies);
        ImportedNamespace privateImports = new ImportedNamespace(privateDependencies);
        this.exportedNamespace = new ExportedNamespace(fileDescriptor, this.localNamespace, publicImports);
        this.namespaces = new Namespace[]{this.localNamespace, publicImports, privateImports};
    }

    public void put(String name, GenericDescriptor d) {
        GenericDescriptor existing = this.get(name);
        if (existing != null) {
            this.foundDuplicateDefinition(name, existing);
        }
        this.localDefinitions.put(name, d);
    }

    private void foundDuplicateDefinition(String name, GenericDescriptor existing) {
        List<String> locations = Arrays.asList(this.fileDescriptor.getName(), existing.getFileDescriptor().getName());
        if (locations.get(0).equals(locations.get(1))) {
            throw new DescriptorParserException("Duplicate definition of " + name + " in " + locations.get(0));
        }
        Collections.sort(locations);
        throw new DescriptorParserException("Duplicate definition of " + name + " in " + locations.get(0) + " and " + locations.get(1));
    }

    public LocalNamespace getLocalNamespace() {
        return this.localNamespace;
    }

    public Namespace getExportedNamespace() {
        return this.exportedNamespace;
    }

    @Override
    protected Namespace[] getNamespaces() {
        return this.namespaces;
    }
}

