/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.Arrays;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.remoting.LocalInvocation;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BaseBackupReceiver;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferControlCommand;

public class LocalCacheBackupReceiver
extends BaseBackupReceiver {
    private static final Log log = LogFactory.getLog(LocalCacheBackupReceiver.class);
    private static final boolean trace = log.isTraceEnabled();

    public LocalCacheBackupReceiver(Cache<Object, Object> cache) {
        super(cache);
    }

    @Override
    public void handleStateTransferControl(XSiteStateTransferControlCommand command) throws Exception {
        XSiteStateTransferControlCommand invokeCommand = command;
        if (!command.getCacheName().equals(this.cacheName)) {
            invokeCommand = command.copyForCache(this.cacheName);
        }
        invokeCommand.setSiteName(command.getOriginSite());
        LocalInvocation.newInstanceFromCache(this.cache, invokeCommand).call();
    }

    @Override
    public void handleStateTransferState(XSiteStatePushCommand cmd) throws Exception {
        this.assertAllowInvocation();
        List<XSiteState> localChunks = Arrays.asList(cmd.getChunk());
        if (trace) {
            log.tracef("Local node will apply %s", (Object)localChunks);
        }
        LocalInvocation.newInstanceFromCache(this.cache, LocalCacheBackupReceiver.newStatePushCommand(this.cache, localChunks)).call();
        if (!this.cache.getStatus().allowInvocations()) {
            throw new CacheException("Cache is stopping or terminated: " + (Object)((Object)this.cache.getStatus()));
        }
    }
}

