/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.client.hotrod.VersionedMetadata;
import org.infinispan.client.hotrod.impl.transport.Transport;

@NotThreadSafe
class TransportInputStream
extends InputStream
implements VersionedMetadata {
    private final Transport transport;
    private final int totalLength;
    private final Runnable afterClose;
    private final VersionedMetadata versionedMetadata;
    private int totalPosition;
    private byte[] buffer;
    private int bufferPosition;
    private int bufferLimit;

    TransportInputStream(Transport transport, VersionedMetadata versionedMetadata, Runnable afterClose) {
        this.transport = transport;
        this.totalLength = transport.readVInt();
        this.buffer = new byte[8192];
        this.versionedMetadata = versionedMetadata;
        this.afterClose = afterClose;
    }

    @Override
    public long getVersion() {
        return this.versionedMetadata.getVersion();
    }

    @Override
    public long getCreated() {
        return this.versionedMetadata.getCreated();
    }

    @Override
    public int getLifespan() {
        return this.versionedMetadata.getLifespan();
    }

    @Override
    public long getLastUsed() {
        return this.versionedMetadata.getLastUsed();
    }

    @Override
    public int getMaxIdle() {
        return this.versionedMetadata.getMaxIdle();
    }

    private void fill() {
        this.bufferLimit = Math.min(8192, this.totalLength - this.totalPosition);
        if (this.bufferLimit > 0) {
            this.transport.readByteArray(this.buffer, this.bufferLimit);
            this.totalPosition += this.bufferLimit;
        }
        this.bufferPosition = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.bufferPosition >= this.bufferLimit) {
            this.fill();
            if (this.bufferPosition >= this.bufferLimit) {
                return -1;
            }
        }
        return this.buffer[this.bufferPosition++] & 0xFF;
    }

    private int read1(byte[] b, int off, int len) {
        int available = this.bufferLimit - this.bufferPosition;
        if (available <= 0) {
            this.fill();
            available = this.bufferLimit - this.bufferPosition;
            if (available <= 0) {
                return -1;
            }
        }
        int amount = available < len ? available : len;
        System.arraycopy(this.buffer, this.bufferPosition, b, off, amount);
        this.bufferPosition += amount;
        return amount;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int nread;
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = 0;
        do {
            if ((nread = this.read1(b, off + n, len - n)) > 0) continue;
            return n == 0 ? nread : n;
        } while ((n += nread) < len);
        return n;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.afterClose != null) {
            this.afterClose.run();
        }
    }
}

