/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractCloseableIteratorCollection;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.commons.util.RemovableIterator;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.stream.impl.local.EntryStreamSupplier;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.util.DataContainerRemoveIterator;
import org.infinispan.util.EntryWrapper;

public class EntrySetCommand<K, V>
extends AbstractLocalCommand
implements VisitableCommand {
    private final Cache<K, V> cache;

    public EntrySetCommand(Cache<K, V> cache, long flagsBitSet) {
        this.setFlagsBitSet(flagsBitSet);
        cache = AbstractDelegatingCache.unwrapCache(cache);
        this.cache = flagsBitSet != 0L ? cache.getAdvancedCache().withFlags((Flag[])EnumUtil.enumArrayOf((long)flagsBitSet, Flag.class)) : cache;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitEntrySetCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<CacheEntry<K, V>> perform(InvocationContext ctx) throws Throwable {
        Object lockOwner = ctx.getLockOwner();
        if (ctx.getLockOwner() != null) {
            return new BackingEntrySet((Cache)this.cache.getAdvancedCache().lockAs(lockOwner));
        }
        return new BackingEntrySet((Cache)this.cache);
    }

    public String toString() {
        return "EntrySetCommand{cache=" + this.cache.getName() + '}';
    }

    static class BackingEntrySet<K, V>
    extends AbstractCloseableIteratorCollection<CacheEntry<K, V>, K, V>
    implements CacheSet<CacheEntry<K, V>> {
        BackingEntrySet(Cache cache) {
            super(cache);
        }

        @Override
        public CloseableIterator<CacheEntry<K, V>> iterator() {
            DataContainerRemoveIterator iterator = new DataContainerRemoveIterator(this.cache);
            RemovableIterator<CacheEntry> removableIterator = new RemovableIterator<CacheEntry>(iterator, e -> this.cache.remove(e.getKey(), e.getValue()));
            return Closeables.iterator(new IteratorMapper<CacheEntry, EntryWrapper>(removableIterator, e -> new EntryWrapper(this.cache, e)));
        }

        @Override
        public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
            DataContainer dc = this.cache.getAdvancedCache().getDataContainer();
            return Closeables.spliterator(Closeables.iterator(new DataContainerRemoveIterator(this.cache, dc)), dc.sizeIncludingExpired(), 4353);
        }

        @Override
        public int size() {
            return this.cache.getAdvancedCache().getDataContainer().size();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry<K, V> entry = this.toEntry(o);
            if (entry != null) {
                Object value = this.cache.get(entry.getKey());
                return value != null && value.equals(entry.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry<K, V> entry = this.toEntry(o);
            return entry != null && this.cache.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean add(CacheEntry<K, V> internalCacheEntry) {
            throw new UnsupportedOperationException();
        }

        private Map.Entry<K, V> toEntry(Object obj) {
            if (obj instanceof Map.Entry) {
                return (Map.Entry)obj;
            }
            return null;
        }

        private ConsistentHash getConsistentHash(Cache<K, V> cache) {
            DistributionManager dm = cache.getAdvancedCache().getDistributionManager();
            if (dm != null) {
                return dm.getReadConsistentHash();
            }
            return null;
        }

        @Override
        public CacheStream<CacheEntry<K, V>> stream() {
            return new LocalCacheStream<CacheEntry<K, V>>(new EntryStreamSupplier(this.cache, this.getConsistentHash(this.cache), () -> super.stream()), false, this.cache.getAdvancedCache().getComponentRegistry());
        }

        @Override
        public CacheStream<CacheEntry<K, V>> parallelStream() {
            return new LocalCacheStream<CacheEntry<K, V>>(new EntryStreamSupplier(this.cache, this.getConsistentHash(this.cache), () -> super.stream()), true, this.cache.getAdvancedCache().getComponentRegistry());
        }
    }
}

