/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.persistence.Store;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.executors.ExecutorAllCompletionService;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Store
@ConfiguredBy(value=SingleFileStoreConfiguration.class)
public class SingleFileStore<K, V>
implements AdvancedLoadWriteStore<K, V> {
    private static final Log log = LogFactory.getLog(SingleFileStore.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final byte[] MAGIC = new byte[]{70, 67, 83, 49};
    private static final byte[] ZERO_INT = new byte[]{0, 0, 0, 0};
    private static final int KEYLEN_POS = 4;
    private static final int KEY_POS = 24;
    private static final int SMALLEST_ENTRY_SIZE = 128;
    private SingleFileStoreConfiguration configuration;
    protected InitializationContext ctx;
    private FileChannel channel;
    private Map<K, FileEntry> entries;
    private SortedSet<FileEntry> freeList;
    private long filePos = MAGIC.length;
    private File file;
    private float fragmentationFactor = 0.75f;
    private ReadWriteLock resizeLock = new ReentrantReadWriteLock();
    private TimeService timeService;

    @Override
    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.configuration = (SingleFileStoreConfiguration)ctx.getConfiguration();
        this.timeService = ctx.getTimeService();
    }

    @Override
    public void start() {
        try {
            File dir;
            String location = this.configuration.location();
            if (location == null || location.trim().length() == 0) {
                location = "Infinispan-SingleFileStore";
            }
            this.file = new File(location, this.ctx.getCache().getName() + ".dat");
            if (!(this.file.exists() || (dir = this.file.getParentFile()).mkdirs() || dir.exists())) {
                throw log.directoryCannotBeCreated(dir.getAbsolutePath());
            }
            this.channel = new RandomAccessFile(this.file, "rw").getChannel();
            HashMap entryMap = this.configuration.maxEntries() > 0 ? new LinkedHashMap(16, 0.75f, true) : new HashMap();
            this.entries = Collections.synchronizedMap(entryMap);
            this.freeList = Collections.synchronizedSortedSet(new TreeSet());
            byte[] header = new byte[MAGIC.length];
            if (this.channel.read(java.nio.ByteBuffer.wrap(header), 0L) == MAGIC.length && Arrays.equals(MAGIC, header)) {
                this.rebuildIndex();
                this.processFreeEntries();
            } else {
                this.clear();
            }
            this.fragmentationFactor = this.configuration.fragmentationFactor();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void stop() {
        try {
            if (this.channel != null) {
                log.tracef("Stopping store %s, size = %d, file size = %d", (Object)this.ctx.getCache().getName(), (Object)this.entries.size(), (Object)this.channel.size());
                this.channel.close();
                this.channel = null;
                this.entries = null;
                this.freeList = null;
                this.filePos = MAGIC.length;
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    private void rebuildIndex() throws Exception {
        java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(24);
        while (true) {
            buf.clear().limit(24);
            this.channel.read(buf, this.filePos);
            if (buf.remaining() > 0) {
                return;
            }
            buf.flip();
            int entrySize = buf.getInt();
            int keyLen = buf.getInt();
            int dataLen = buf.getInt();
            int metadataLen = buf.getInt();
            long expiryTime = buf.getLong();
            FileEntry fe = new FileEntry(this.filePos, entrySize, keyLen, dataLen, metadataLen, expiryTime);
            if (fe.size < 24 + fe.keyLen + fe.dataLen + fe.metadataLen) {
                throw log.errorReadingFileStore(this.file.getPath(), this.filePos);
            }
            this.filePos += (long)fe.size;
            if (fe.keyLen > 0) {
                if (buf.capacity() < fe.keyLen) {
                    buf = java.nio.ByteBuffer.allocate(fe.keyLen);
                }
                buf.clear().limit(fe.keyLen);
                this.channel.read(buf, fe.offset + 24L);
                Object key = this.ctx.getMarshaller().objectFromByteBuffer(buf.array(), 0, fe.keyLen);
                this.entries.put(key, fe);
                continue;
            }
            this.freeList.add(fe);
        }
    }

    @Override
    public boolean contains(Object key) {
        FileEntry entry = this.entries.get(key);
        return entry != null && !entry.isExpired(this.timeService.wallClockTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileEntry allocate(int len) {
        SortedSet<FileEntry> sortedSet = this.freeList;
        synchronized (sortedSet) {
            SortedSet<FileEntry> candidates = this.freeList.tailSet(new FileEntry(0L, len));
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                FileEntry free = (FileEntry)it.next();
                if (free.isLocked()) continue;
                it.remove();
                return this.allocateExistingEntry(free, len);
            }
            FileEntry fe = new FileEntry(this.filePos, len);
            this.filePos += (long)len;
            if (trace) {
                log.tracef("New entry allocated at %d:%d, %d free entries, file size is %d", fe.offset, fe.size, this.freeList.size(), this.filePos);
            }
            return fe;
        }
    }

    private FileEntry allocateExistingEntry(FileEntry free, int len) {
        int remainder = free.size - len;
        if (remainder >= 128 && (float)len <= (float)free.size * this.fragmentationFactor) {
            try {
                FileEntry newFreeEntry = new FileEntry(free.offset + (long)len, remainder);
                this.addNewFreeEntry(newFreeEntry);
                FileEntry newEntry = new FileEntry(free.offset, len);
                if (trace) {
                    log.tracef("Split entry at %d:%d, allocated %d:%d, free %d:%d, %d free entries", free.offset, free.size, newEntry.offset, newEntry.size, newFreeEntry.offset, newFreeEntry.size, this.freeList.size());
                }
                return newEntry;
            }
            catch (IOException e) {
                throw new PersistenceException("Cannot add new free entry", e);
            }
        }
        if (trace) {
            log.tracef("Existing free entry allocated at %d:%d, %d free entries", free.offset, (long)free.size, (long)this.freeList.size());
        }
        return free;
    }

    private void addNewFreeEntry(FileEntry fe) throws IOException {
        java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(24);
        buf.putInt(fe.size);
        buf.putInt(0);
        buf.putInt(0);
        buf.putInt(0);
        buf.putLong(-1L);
        buf.flip();
        this.channel.write(buf, fe.offset);
        this.freeList.add(fe);
    }

    private void free(FileEntry fe) throws IOException {
        if (fe != null) {
            this.channel.write(java.nio.ByteBuffer.wrap(ZERO_INT), fe.offset + 4L);
            if (!this.freeList.add(fe)) {
                throw new IllegalStateException(String.format("Trying to free an entry that was not allocated: %s", fe));
            }
            if (trace) {
                log.tracef("Deleted entry at %d:%d, there are now %d free entries", fe.offset, (long)fe.size, (long)this.freeList.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(MarshalledEntry<? extends K, ? extends V> marshalledEntry) {
        try {
            FileEntry oldEntry;
            block12: {
                ByteBuffer key = marshalledEntry.getKeyBytes();
                ByteBuffer data = marshalledEntry.getValueBytes();
                ByteBuffer metadata = marshalledEntry.getMetadataBytes();
                int metadataLength = metadata == null ? 0 : metadata.getLength();
                int len = 24 + key.getLength() + data.getLength() + metadataLength;
                oldEntry = null;
                this.resizeLock.readLock().lock();
                try {
                    FileEntry newEntry = this.allocate(len);
                    long expiryTime = metadata != null ? marshalledEntry.getMetadata().expiryTime() : -1L;
                    newEntry = new FileEntry(newEntry, key.getLength(), data.getLength(), metadataLength, expiryTime);
                    java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(len);
                    buf.putInt(newEntry.size);
                    buf.putInt(newEntry.keyLen);
                    buf.putInt(newEntry.dataLen);
                    buf.putInt(newEntry.metadataLen);
                    buf.putLong(newEntry.expiryTime);
                    buf.put(key.getBuf(), key.getOffset(), key.getLength());
                    buf.put(data.getBuf(), data.getOffset(), data.getLength());
                    if (metadata != null) {
                        buf.put(metadata.getBuf(), metadata.getOffset(), metadata.getLength());
                    }
                    buf.flip();
                    this.channel.write(buf, newEntry.offset);
                    if (trace) {
                        log.tracef("Wrote entry %s:%d at %d:%d", marshalledEntry.getKey(), len, newEntry.offset, newEntry.size);
                    }
                    if ((oldEntry = this.entries.put(marshalledEntry.getKey(), newEntry)) != null) break block12;
                    oldEntry = this.evict();
                }
                catch (Throwable throwable) {
                    try {
                        this.free(oldEntry);
                    }
                    finally {
                        this.resizeLock.readLock().unlock();
                    }
                    throw throwable;
                }
            }
            try {
                this.free(oldEntry);
            }
            finally {
                this.resizeLock.readLock().unlock();
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileEntry evict() {
        if (this.configuration.maxEntries() > 0) {
            Map<K, FileEntry> map = this.entries;
            synchronized (map) {
                if (this.entries.size() > this.configuration.maxEntries()) {
                    Iterator<FileEntry> it = this.entries.values().iterator();
                    FileEntry fe = it.next();
                    it.remove();
                    return fe;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.resizeLock.writeLock().lock();
        try {
            Map<K, FileEntry> map = this.entries;
            synchronized (map) {
                SortedSet<FileEntry> sortedSet = this.freeList;
                synchronized (sortedSet) {
                    for (FileEntry fe : this.entries.values()) {
                        fe.waitUnlocked();
                    }
                    for (FileEntry fe : this.freeList) {
                        fe.waitUnlocked();
                    }
                    this.entries.clear();
                    this.freeList.clear();
                    if (trace) {
                        log.tracef("Truncating file, current size is %d", this.filePos);
                    }
                    this.channel.truncate(0L);
                    this.channel.write(java.nio.ByteBuffer.wrap(MAGIC), 0L);
                    this.filePos = MAGIC.length;
                }
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            this.resizeLock.writeLock().unlock();
        }
    }

    @Override
    public boolean delete(Object key) {
        this.resizeLock.readLock().lock();
        try {
            FileEntry fe = this.entries.remove(key);
            this.free(fe);
            boolean bl = fe != null;
            return bl;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            this.resizeLock.readLock().unlock();
        }
    }

    @Override
    public MarshalledEntry<K, V> load(Object key) {
        return this._load(key, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private MarshalledEntry<K, V> _load(Object key, boolean loadValue, boolean loadMetadata) {
        byte[] data;
        FileEntry fe;
        block20: {
            this.resizeLock.readLock().lock();
            Map<K, FileEntry> map = this.entries;
            // MONITORENTER : map
            fe = this.entries.get(key);
            if (fe == null) {
                MarshalledEntry<K, V> marshalledEntry = null;
                // MONITOREXIT : map
                this.resizeLock.readLock().unlock();
                return marshalledEntry;
            }
            if (!fe.isExpired(this.timeService.wallClockTime())) break block20;
            MarshalledEntry<K, V> marshalledEntry = null;
            this.resizeLock.readLock().unlock();
            return marshalledEntry;
        }
        try {
            fe.lock();
            // MONITOREXIT : map
        }
        finally {
            this.resizeLock.readLock().unlock();
        }
        ByteBuffer valueBb = null;
        ByteBuffer metadataBb = null;
        if (!loadValue && !loadMetadata) {
            try {
                MarshalledEntry marshalledEntry = this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, valueBb, metadataBb);
                return marshalledEntry;
            }
            finally {
                fe.unlock();
            }
        }
        try {
            data = new byte[fe.keyLen + fe.dataLen + (loadMetadata ? fe.metadataLen : 0)];
            this.channel.read(java.nio.ByteBuffer.wrap(data), fe.offset + 24L);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            fe.unlock();
        }
        if (trace) {
            log.tracef("Read entry %s at %d:%d", key, (Object)fe.offset, (Object)fe.actualSize());
        }
        ByteBufferFactory factory = this.ctx.getByteBufferFactory();
        ByteBuffer keyBb = factory.newByteBuffer(data, 0, fe.keyLen);
        if (loadValue) {
            valueBb = factory.newByteBuffer(data, fe.keyLen, fe.dataLen);
        }
        if (!loadMetadata) return this.ctx.getMarshalledEntryFactory().newMarshalledEntry(keyBb, valueBb, metadataBb);
        if (fe.metadataLen <= 0) return this.ctx.getMarshalledEntryFactory().newMarshalledEntry(keyBb, valueBb, metadataBb);
        metadataBb = factory.newByteBuffer(data, fe.keyLen + fe.dataLen, fe.metadataLen);
        return this.ctx.getMarshalledEntryFactory().newMarshalledEntry(keyBb, valueBb, metadataBb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(KeyFilter<? super K> filter, AdvancedCacheLoader.CacheLoaderTask<K, V> task, Executor executor, boolean fetchValue, boolean fetchMetadata) {
        filter = PersistenceUtil.notNull(filter);
        ArrayList<KeyValuePair<K, FileEntry>> keysToLoad = new ArrayList<KeyValuePair<K, FileEntry>>(this.entries.size());
        Map<K, FileEntry> map = this.entries;
        synchronized (map) {
            for (Map.Entry<K, FileEntry> e : this.entries.entrySet()) {
                if (!filter.accept(e.getKey())) continue;
                keysToLoad.add(new KeyValuePair<K, FileEntry>(e.getKey(), e.getValue()));
            }
        }
        keysToLoad.sort((o1, o2) -> {
            long offset1 = ((FileEntry)o1.getValue()).offset;
            long offset2 = ((FileEntry)o2.getValue()).offset;
            return offset1 < offset2 ? -1 : (offset1 == offset2 ? 0 : 1);
        });
        ExecutorAllCompletionService eacs = new ExecutorAllCompletionService(executor);
        TaskContextImpl taskContext = new TaskContextImpl();
        for (KeyValuePair keyValuePair : keysToLoad) {
            if (taskContext.isStopped()) break;
            Object key = keyValuePair.getKey();
            eacs.submit(() -> {
                try {
                    MarshalledEntry<K, V> marshalledEntry = this._load(key, fetchValue, fetchMetadata);
                    if (marshalledEntry != null) {
                        task.processEntry(marshalledEntry, taskContext);
                    }
                    return null;
                }
                catch (Exception e) {
                    log.errorExecutingParallelStoreTask(e);
                    throw e;
                }
            });
        }
        eacs.waitUntilAllCompleted();
        if (eacs.isExceptionThrown()) {
            throw new PersistenceException("Execution exception!", eacs.getFirstException());
        }
    }

    private void processFreeEntries() {
        ArrayList<FileEntry> l = new ArrayList<FileEntry>(this.freeList);
        l.sort((o1, o2) -> {
            long diff = o1.offset - o2.offset;
            return diff == 0L ? 0 : (diff > 0L ? -1 : 1);
        });
        this.truncateFile(l);
        this.mergeFreeEntries(l);
    }

    private void truncateFile(List<FileEntry> entries) {
        FileEntry fe;
        long startTime = 0L;
        if (trace) {
            startTime = this.timeService.wallClockTime();
        }
        int reclaimedSpace = 0;
        int removedEntries = 0;
        long truncateOffset = -1L;
        Iterator<FileEntry> it = entries.iterator();
        while (it.hasNext() && !(fe = it.next()).isLocked() && fe.offset + (long)fe.size == this.filePos) {
            truncateOffset = fe.offset;
            this.filePos = fe.offset;
            this.freeList.remove(fe);
            it.remove();
            reclaimedSpace += fe.size;
            ++removedEntries;
        }
        if (truncateOffset > 0L) {
            try {
                this.channel.truncate(truncateOffset);
            }
            catch (IOException e) {
                throw new PersistenceException("Error while truncating file", e);
            }
        }
        if (trace) {
            log.tracef("Removed entries: %d, Reclaimed Space: %d, Free Entries %d", removedEntries, reclaimedSpace, this.freeList.size());
            log.tracef("Time taken for truncateFile: %d (ms)", this.timeService.wallClockTime() - startTime);
        }
    }

    private void mergeFreeEntries(List<FileEntry> entries) {
        long startTime = 0L;
        if (trace) {
            startTime = this.timeService.wallClockTime();
        }
        FileEntry lastEntry = null;
        FileEntry newEntry = null;
        int mergeCounter = 0;
        for (FileEntry fe : entries) {
            if (fe.isLocked()) continue;
            if (lastEntry != null && lastEntry.offset == fe.offset + (long)fe.size) {
                if (newEntry == null) {
                    newEntry = new FileEntry(fe.offset, fe.size + lastEntry.size);
                    this.freeList.remove(lastEntry);
                    ++mergeCounter;
                } else {
                    newEntry = new FileEntry(fe.offset, fe.size + newEntry.size);
                }
                this.freeList.remove(fe);
                ++mergeCounter;
            } else if (newEntry != null) {
                this.mergeAndLogEntry(newEntry, mergeCounter);
                newEntry = null;
                mergeCounter = 0;
            }
            lastEntry = fe;
        }
        if (newEntry != null) {
            this.mergeAndLogEntry(newEntry, mergeCounter);
        }
        if (trace) {
            log.tracef("Total time taken for mergeFreeEntries: " + (this.timeService.wallClockTime() - startTime) + " (ms)", new Object[0]);
        }
    }

    private void mergeAndLogEntry(FileEntry entry, int mergeCounter) {
        try {
            this.addNewFreeEntry(entry);
            if (trace) {
                log.tracef("Merged %d entries at %d:%d, %d free entries", mergeCounter, entry.offset, entry.size, this.freeList.size());
            }
        }
        catch (IOException e) {
            throw new PersistenceException("Could not add new merged entry", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener task) {
        long now = this.timeService.wallClockTime();
        ArrayList<KeyValuePair<K, FileEntry>> entriesToPurge = new ArrayList<KeyValuePair<K, FileEntry>>();
        Object object = this.entries;
        synchronized (object) {
            Iterator<Map.Entry<K, FileEntry>> it = this.entries.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<K, FileEntry> next = it.next();
                FileEntry fe = next.getValue();
                if (!fe.isExpired(now)) continue;
                it.remove();
                entriesToPurge.add(new KeyValuePair<K, FileEntry>(next.getKey(), fe));
            }
        }
        this.resizeLock.readLock().lock();
        try {
            Iterator it = entriesToPurge.iterator();
            while (it.hasNext()) {
                KeyValuePair next = (KeyValuePair)it.next();
                FileEntry fe = (FileEntry)next.getValue();
                if (!fe.isExpired(now)) continue;
                it.remove();
                try {
                    this.free(fe);
                }
                catch (Exception e) {
                    throw new PersistenceException(e);
                }
                if (task == null) continue;
                task.entryPurged(next.getKey());
            }
            object = this.freeList;
            synchronized (object) {
                this.processFreeEntries();
            }
        }
        finally {
            this.resizeLock.readLock().unlock();
        }
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    Map<K, FileEntry> getEntries() {
        return this.entries;
    }

    SortedSet<FileEntry> getFreeList() {
        return this.freeList;
    }

    long getFileSize() {
        return this.filePos;
    }

    public SingleFileStoreConfiguration getConfiguration() {
        return this.configuration;
    }

    private static class FileEntry
    implements Comparable<FileEntry> {
        final long offset;
        final int size;
        final int keyLen;
        final int dataLen;
        final int metadataLen;
        final long expiryTime;
        transient int readers = 0;

        FileEntry(long offset, int size) {
            this(offset, size, 0, 0, 0, -1L);
        }

        FileEntry(long offset, int size, int keyLen, int dataLen, int metadataLen, long expiryTime) {
            this.offset = offset;
            this.size = size;
            this.keyLen = keyLen;
            this.dataLen = dataLen;
            this.metadataLen = metadataLen;
            this.expiryTime = expiryTime;
        }

        FileEntry(FileEntry fe, int keyLen, int dataLen, int metadataLen, long expiryTime) {
            this(fe.offset, fe.size, keyLen, dataLen, metadataLen, expiryTime);
        }

        synchronized boolean isLocked() {
            return this.readers > 0;
        }

        synchronized void lock() {
            ++this.readers;
        }

        synchronized void unlock() {
            --this.readers;
            if (this.readers == 0) {
                this.notifyAll();
            }
        }

        synchronized void waitUnlocked() {
            while (this.readers > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        boolean isExpired(long now) {
            return this.expiryTime > 0L && this.expiryTime < now;
        }

        int actualSize() {
            return 24 + this.keyLen + this.dataLen + this.metadataLen;
        }

        @Override
        public int compareTo(FileEntry fe) {
            int diff = this.size - fe.size;
            if (diff != 0) {
                return diff;
            }
            return this.offset < fe.offset ? -1 : (this.offset == fe.offset ? 0 : 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileEntry fileEntry = (FileEntry)o;
            if (this.offset != fileEntry.offset) {
                return false;
            }
            return this.size == fileEntry.size;
        }

        public int hashCode() {
            int result = (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + this.size;
            return result;
        }

        public String toString() {
            return "FileEntry@" + this.offset + "{size=" + this.size + ", actual=" + this.actualSize() + '}';
        }
    }
}

