/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;

public class TableManipulationConfiguration {
    public static final AttributeDefinition<String> ID_COLUMN_NAME = AttributeDefinition.builder("idColumnName", null, String.class).immutable().build();
    public static final AttributeDefinition<String> ID_COLUMN_TYPE = AttributeDefinition.builder("idColumnType", null, String.class).immutable().build();
    public static final AttributeDefinition<String> TABLE_NAME_PREFIX = AttributeDefinition.builder("tableNamePrefix", null, String.class).immutable().build();
    public static final AttributeDefinition<String> CACHE_NAME = AttributeDefinition.builder("cacheName", null, String.class).immutable().build();
    public static final AttributeDefinition<String> DATA_COLUMN_NAME = AttributeDefinition.builder("dataColumnName", null, String.class).immutable().build();
    public static final AttributeDefinition<String> DATA_COLUMN_TYPE = AttributeDefinition.builder("dataColumnType", null, String.class).immutable().build();
    public static final AttributeDefinition<String> TIMESTAMP_COLUMN_NAME = AttributeDefinition.builder("timestampColumnName", null, String.class).immutable().build();
    public static final AttributeDefinition<String> TIMESTAMP_COLUMN_TYPE = AttributeDefinition.builder("timestampColumnType", null, String.class).immutable().build();
    public static final AttributeDefinition<Integer> BATCH_SIZE = AttributeDefinition.builder("batchSize", AbstractStoreConfiguration.MAX_BATCH_SIZE.getDefaultValue()).immutable().build();
    public static final AttributeDefinition<Integer> FETCH_SIZE = AttributeDefinition.builder("fetchSize", 100).immutable().build();
    public static final AttributeDefinition<Boolean> CREATE_ON_START = AttributeDefinition.builder("createOnStart", true).immutable().build();
    public static final AttributeDefinition<Boolean> DROP_ON_EXIT = AttributeDefinition.builder("dropOnExit", false).immutable().build();
    private final Attribute<String> idColumnName;
    private final Attribute<String> idColumnType;
    private final Attribute<String> tableNamePrefix;
    private final Attribute<String> cacheName;
    private final Attribute<String> dataColumnName;
    private final Attribute<String> dataColumnType;
    private final Attribute<String> timestampColumnName;
    private final Attribute<String> timestampColumnType;
    private final Attribute<Integer> batchSize;
    private final Attribute<Integer> fetchSize;
    private final Attribute<Boolean> createOnStart;
    private final Attribute<Boolean> dropOnExit;
    private final AttributeSet attributes;

    static AttributeSet attributeSet() {
        return new AttributeSet(TableManipulationConfiguration.class, ID_COLUMN_NAME, ID_COLUMN_TYPE, TABLE_NAME_PREFIX, CACHE_NAME, DATA_COLUMN_NAME, DATA_COLUMN_TYPE, TIMESTAMP_COLUMN_NAME, TIMESTAMP_COLUMN_TYPE, BATCH_SIZE, FETCH_SIZE, CREATE_ON_START, DROP_ON_EXIT);
    }

    TableManipulationConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.idColumnName = attributes.attribute(ID_COLUMN_NAME);
        this.idColumnType = attributes.attribute(ID_COLUMN_TYPE);
        this.tableNamePrefix = attributes.attribute(TABLE_NAME_PREFIX);
        this.cacheName = attributes.attribute(CACHE_NAME);
        this.dataColumnName = attributes.attribute(DATA_COLUMN_NAME);
        this.dataColumnType = attributes.attribute(DATA_COLUMN_TYPE);
        this.timestampColumnName = attributes.attribute(TIMESTAMP_COLUMN_NAME);
        this.timestampColumnType = attributes.attribute(TIMESTAMP_COLUMN_TYPE);
        this.batchSize = attributes.attribute(BATCH_SIZE);
        this.fetchSize = attributes.attribute(FETCH_SIZE);
        this.createOnStart = attributes.attribute(CREATE_ON_START);
        this.dropOnExit = attributes.attribute(DROP_ON_EXIT);
    }

    public boolean createOnStart() {
        return this.createOnStart.get();
    }

    public boolean dropOnExit() {
        return this.dropOnExit.get();
    }

    public String idColumnName() {
        return this.idColumnName.get();
    }

    public String idColumnType() {
        return this.idColumnType.get();
    }

    public String tableNamePrefix() {
        return this.tableNamePrefix.get();
    }

    public String cacheName() {
        return this.cacheName.get();
    }

    public String dataColumnName() {
        return this.dataColumnName.get();
    }

    public String dataColumnType() {
        return this.dataColumnType.get();
    }

    public String timestampColumnName() {
        return this.timestampColumnName.get();
    }

    public String timestampColumnType() {
        return this.timestampColumnType.get();
    }

    public int fetchSize() {
        return this.fetchSize.get();
    }

    @Deprecated
    public int batchSize() {
        return this.batchSize.get();
    }

    AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "TableManipulationConfiguration [attributes=" + this.attributes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableManipulationConfiguration other = (TableManipulationConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }
}

