/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.infinispan.AdvancedCache;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.endpoints.EndpointsCacheFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.endpoints.ReplEmbeddedRestHotRodTest")
public class ReplEmbeddedRestHotRodTest
extends AbstractInfinispanTest {
    EndpointsCacheFactory<Object, Object> cacheFactory1;
    EndpointsCacheFactory<Object, Object> cacheFactory2;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory1 = new EndpointsCacheFactory(CacheMode.REPL_SYNC).setup();
        this.cacheFactory2 = new EndpointsCacheFactory(CacheMode.REPL_SYNC).setup();
    }

    @AfterClass
    protected void teardown() {
        EndpointsCacheFactory.killCacheFactories(this.cacheFactory1, this.cacheFactory2);
    }

    public void testRestPutEmbeddedHotRodGet() throws Exception {
        String key = "1";
        PutMethod put = new PutMethod(this.cacheFactory1.getRestUrl() + "/" + "1");
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity("<hey>ho</hey>".getBytes(), "text/plain"));
        HttpClient restClient = this.cacheFactory1.getRestClient();
        restClient.executeMethod((HttpMethod)put);
        AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
        AssertJUnit.assertEquals((String)"", (String)put.getResponseBodyAsString().trim());
        AdvancedCache embeddedCache = this.cacheFactory2.getEmbeddedCache().getAdvancedCache();
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)embeddedCache.get((Object)"1"));
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)this.cacheFactory2.getHotRodCache().get((Object)"1"));
    }

    public void testEmbeddedPutRestHotRodGet() throws Exception {
        String key = "2";
        AdvancedCache cache = this.cacheFactory2.getEmbeddedCache().getAdvancedCache().withEncoding(IdentityEncoder.class);
        AssertJUnit.assertEquals(null, (Object)cache.put((Object)"2", (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory1.getHotRodCache().get((Object)"2"));
        GetMethod get = new GetMethod(this.cacheFactory2.getRestUrl() + "/" + "2");
        get.setRequestHeader("Accept", "text/plain");
        this.cacheFactory2.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((String)"v1", (String)get.getResponseBodyAsString());
    }

    public void testHotRodPutEmbeddedRestGet() throws Exception {
        String key = "3";
        RemoteCache<Object, Object> remote = this.cacheFactory1.getHotRodCache();
        AssertJUnit.assertEquals(null, (Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"3", (Object)"v1"));
        AdvancedCache embeddedCache = this.cacheFactory2.getEmbeddedCache().getAdvancedCache().withEncoding(IdentityEncoder.class);
        AssertJUnit.assertEquals((Object)"v1", (Object)embeddedCache.get((Object)"3"));
        GetMethod get = new GetMethod(this.cacheFactory2.getRestUrl() + "/" + "3");
        get.setRequestHeader("Accept", "text/plain");
        this.cacheFactory2.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((String)"v1", (String)get.getResponseBodyAsString());
    }
}

