/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.endpoints.EndpointsCacheFactory;
import org.infinispan.it.endpoints.MemcachedEncoder;
import org.infinispan.it.endpoints.SpyMemcachedMarshaller;
import org.infinispan.it.endpoints.TestCacheListener;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.endpoints.EmbeddedMemcachedCacheListenerTest")
public class EmbeddedMemcachedCacheListenerTest
extends AbstractInfinispanTest {
    EndpointsCacheFactory<String, String> cacheFactory;

    @BeforeMethod
    protected void setup() throws Exception {
        this.cacheFactory = new EndpointsCacheFactory("memcachedCache", (Marshaller)new SpyMemcachedMarshaller(), CacheMode.LOCAL, (Encoder)new MemcachedEncoder()).setup();
    }

    @AfterMethod
    protected void teardown() {
        EndpointsCacheFactory.killCacheFactories(this.cacheFactory);
    }

    public void testLoadingAndStoringEventsMemcached() throws InterruptedException, ExecutionException, TimeoutException {
        Cache<String, String> embedded = this.cacheFactory.getEmbeddedCache();
        MemcachedClient remote = this.cacheFactory.getMemcachedClient();
        TestCacheListener l = new TestCacheListener();
        embedded.addListener((Object)l);
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        OperationFuture future1 = remote.add("k", 0, (Object)"v");
        AssertJUnit.assertTrue((boolean)((Boolean)future1.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((int)1, (int)l.createdCounter);
        AssertJUnit.assertEquals((Object)"v", (Object)l.created.get("k"));
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        OperationFuture future2 = remote.set("key", 0, (Object)"value");
        AssertJUnit.assertTrue((boolean)((Boolean)future2.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        OperationFuture future3 = remote.set("key", 0, (Object)"modifiedValue");
        AssertJUnit.assertTrue((boolean)((Boolean)future3.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.modifiedCounter);
        AssertJUnit.assertEquals((Object)"modifiedValue", (Object)l.modified.get("key"));
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        OperationFuture future4 = remote.replace("k", 0, (Object)"replacedValue");
        AssertJUnit.assertTrue((boolean)((Boolean)future4.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)2, (int)l.modifiedCounter);
        AssertJUnit.assertEquals((Object)"replacedValue", (Object)l.modified.get("k"));
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        l.reset();
        OperationFuture future5 = remote.delete("key");
        AssertJUnit.assertTrue((boolean)((Boolean)future5.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.removedCounter);
        AssertJUnit.assertEquals((Object)"modifiedValue", (Object)l.removed.get("key"));
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        l.reset();
        String value = (String)remote.get("k");
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.visitedCounter);
        AssertJUnit.assertEquals((Object)"replacedValue", (Object)l.visited.get("k"));
        AssertJUnit.assertEquals((String)"replacedValue", (String)value);
        l.reset();
    }
}

