/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.MemcachedClient;
import org.apache.commons.httpclient.HttpClient;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.TranscoderMarshallerAdapter;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.test.MemcachedTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;

public class EndpointsCacheFactory<K, V> {
    private static final int DEFAULT_NUM_OWNERS = 2;
    private EmbeddedCacheManager cacheManager;
    private HotRodServer hotrod;
    private RemoteCacheManager hotrodClient;
    private RestServer rest;
    private MemcachedServer memcached;
    private Cache<K, V> embeddedCache;
    private RemoteCache<K, V> hotrodCache;
    private HttpClient restClient;
    private MemcachedClient memcachedClient;
    private net.spy.memcached.transcoders.Transcoder transcoder;
    private final String cacheName;
    private final Marshaller marshaller;
    private final CacheMode cacheMode;
    private final SerializationContextInitializer contextInitializer;
    private final int numOwners;
    private final boolean l1Enable;
    private final boolean memcachedWithDecoder;
    private int restPort;

    EndpointsCacheFactory(CacheMode cacheMode) {
        this(cacheMode, 2, false);
    }

    EndpointsCacheFactory(CacheMode cacheMode, SerializationContextInitializer contextInitializer) {
        this("test", null, cacheMode, 2, false, null, null, contextInitializer);
    }

    EndpointsCacheFactory(CacheMode cacheMode, int numOwners, boolean l1Enable) {
        this("test", null, cacheMode, numOwners, l1Enable, null, null, null);
    }

    EndpointsCacheFactory(CacheMode cacheMode, int numOwners, boolean l1Enable, Encoder encoder) {
        this("test", null, cacheMode, numOwners, l1Enable, null, encoder, null);
    }

    EndpointsCacheFactory(String cacheName, Marshaller marshaller, CacheMode cacheMode) {
        this(cacheName, marshaller, cacheMode, 2, null);
    }

    EndpointsCacheFactory(String cacheName, Marshaller marshaller, CacheMode cacheMode, Encoder encoder) {
        this(cacheName, marshaller, cacheMode, 2, false, null, encoder, null);
    }

    EndpointsCacheFactory(String cacheName, Marshaller marshaller, CacheMode cacheMode, int numOwners, Encoder encoder) {
        this(cacheName, marshaller, cacheMode, numOwners, false, null, encoder, null);
    }

    public EndpointsCacheFactory(String cacheName, Marshaller marshaller, CacheMode cacheMode, net.spy.memcached.transcoders.Transcoder transcoder) {
        this(cacheName, marshaller, cacheMode, 2, false, transcoder, null, null);
    }

    EndpointsCacheFactory(String cacheName, Marshaller marshaller, CacheMode cacheMode, int numOwners, boolean l1Enable, net.spy.memcached.transcoders.Transcoder transcoder, Encoder encoder, SerializationContextInitializer contextInitializer) {
        this.cacheName = cacheName;
        this.marshaller = marshaller;
        this.cacheMode = cacheMode;
        this.numOwners = numOwners;
        this.l1Enable = l1Enable;
        this.transcoder = transcoder;
        this.memcachedWithDecoder = transcoder != null;
        this.contextInitializer = contextInitializer;
    }

    public EndpointsCacheFactory<K, V> setup() throws Exception {
        this.createEmbeddedCache();
        this.createHotRodCache();
        this.createRestMemcachedCaches();
        return this;
    }

    void addRegexWhiteList(String regex) {
        this.cacheManager.getClassWhiteList().addRegexps(new String[]{regex});
    }

    private void createRestMemcachedCaches() throws Exception {
        this.createRestCache();
        this.createMemcachedCache();
    }

    private void createEmbeddedCache() {
        boolean isConversionSupported;
        GlobalConfigurationBuilder globalBuilder;
        if (this.cacheMode.isClustered()) {
            globalBuilder = new GlobalConfigurationBuilder();
            globalBuilder.transport().defaultTransport();
        } else {
            globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        }
        ((PrivateGlobalConfigurationBuilder)globalBuilder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        globalBuilder.defaultCacheName(this.cacheName);
        if (this.contextInitializer != null) {
            globalBuilder.serialization().addContextInitializer(this.contextInitializer);
        }
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.clustering().cacheMode(this.cacheMode).encoding().key().mediaType("application/x-java-object").encoding().value().mediaType("application/x-java-object");
        if (this.cacheMode.isDistributed() && this.numOwners != 2) {
            builder.clustering().hash().numOwners(this.numOwners);
        }
        if (this.cacheMode.isDistributed() && this.l1Enable) {
            builder.clustering().l1().enable();
        }
        this.cacheManager = this.cacheMode.isClustered() ? TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalBuilder, (org.infinispan.configuration.cache.ConfigurationBuilder)builder) : TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)globalBuilder, (org.infinispan.configuration.cache.ConfigurationBuilder)builder);
        this.embeddedCache = this.cacheManager.getCache(this.cacheName);
        EncoderRegistry encoderRegistry = (EncoderRegistry)this.embeddedCache.getAdvancedCache().getComponentRegistry().getGlobalComponentRegistry().getComponent(EncoderRegistry.class);
        if (this.marshaller != null && !(isConversionSupported = encoderRegistry.isConversionSupported(this.marshaller.mediaType(), MediaType.APPLICATION_OBJECT))) {
            encoderRegistry.registerTranscoder((Transcoder)new TranscoderMarshallerAdapter(this.marshaller));
        }
    }

    private void createHotRodCache() {
        this.createHotRodCache(HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager));
    }

    private void createHotRodCache(HotRodServer server) {
        this.hotrod = server;
        this.hotrodClient = new RemoteCacheManager(new ConfigurationBuilder().addServers("localhost:" + this.hotrod.getPort()).addJavaSerialWhiteList(new String[]{".*Person.*", ".*CustomEvent.*"}).marshaller(this.marshaller).addContextInitializer(this.contextInitializer).build());
        this.hotrodCache = this.cacheName.isEmpty() ? this.hotrodClient.getCache() : this.hotrodClient.getCache(this.cacheName);
    }

    private void createRestCache() {
        RestServer restServer = (RestServer)ServerTestingUtil.startProtocolServer((int)ServerTestingUtil.findFreePort(), p -> {
            RestServerConfigurationBuilder builder = new RestServerConfigurationBuilder();
            builder.port(p.intValue());
            this.rest = new RestServer();
            this.rest.start((ProtocolServerConfiguration)builder.build(), this.cacheManager);
            return this.rest;
        });
        this.restPort = restServer.getPort();
        this.restClient = new HttpClient();
    }

    private void createMemcachedCache() throws IOException {
        MediaType clientEncoding = this.marshaller == null ? MediaType.APPLICATION_OCTET_STREAM : this.marshaller.mediaType();
        this.memcached = (MemcachedServer)ServerTestingUtil.startProtocolServer((int)ServerTestingUtil.findFreePort(), p -> {
            if (this.memcachedWithDecoder) {
                return MemcachedTestingUtil.startMemcachedTextServer((EmbeddedCacheManager)this.cacheManager, (int)p, (String)this.cacheName, (MediaType)clientEncoding);
            }
            return MemcachedTestingUtil.startMemcachedTextServer((EmbeddedCacheManager)this.cacheManager, (int)p, (MediaType)clientEncoding);
        });
        this.memcachedClient = this.createMemcachedClient(60000L, this.memcached.getPort());
    }

    private MemcachedClient createMemcachedClient(final long timeout, int port) throws IOException {
        DefaultConnectionFactory cf = new DefaultConnectionFactory(){

            public long getOperationTimeout() {
                return timeout;
            }
        };
        if (this.transcoder != null) {
            cf = new ConnectionFactoryBuilder((ConnectionFactory)cf).setTranscoder(this.transcoder).build();
        }
        return new MemcachedClient((ConnectionFactory)cf, Collections.singletonList(new InetSocketAddress("127.0.0.1", port)));
    }

    public static void killCacheFactories(EndpointsCacheFactory ... cacheFactories) {
        if (cacheFactories != null) {
            for (EndpointsCacheFactory cacheFactory : cacheFactories) {
                if (cacheFactory == null) continue;
                cacheFactory.teardown();
            }
        }
    }

    void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheManager)this.hotrodClient);
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotrod});
        this.killRestServer(this.rest);
        MemcachedTestingUtil.killMemcachedClient((MemcachedClient)this.memcachedClient);
        MemcachedTestingUtil.killMemcachedServer((MemcachedServer)this.memcached);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    private void killRestServer(RestServer rest) {
        if (rest != null) {
            try {
                rest.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public Cache<K, V> getEmbeddedCache() {
        return this.embeddedCache.getAdvancedCache().withEncoding(IdentityEncoder.class);
    }

    public RemoteCache<K, V> getHotRodCache() {
        return this.hotrodCache;
    }

    public HttpClient getRestClient() {
        return this.restClient;
    }

    public MemcachedClient getMemcachedClient() {
        return this.memcachedClient;
    }

    int getMemcachedPort() {
        return this.memcached.getPort();
    }

    public String getRestUrl() {
        return String.format("http://localhost:%s/rest/%s", this.restPort, this.cacheName);
    }

    HotRodServer getHotrodServer() {
        return this.hotrod;
    }
}

