/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import org.infinispan.Cache;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.CustomEventLogListener;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.event.RemoteCacheSupplier;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.endpoints.EndpointITSCI;
import org.infinispan.it.endpoints.EndpointsCacheFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.endpoints.EmbeddedHotRodTest")
public class EmbeddedHotRodTest
extends AbstractInfinispanTest {
    EndpointsCacheFactory<Integer, String> cacheFactory;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory = new EndpointsCacheFactory(CacheMode.LOCAL, EndpointITSCI.INSTANCE).setup();
        HotRodServer hotrod = this.cacheFactory.getHotrodServer();
        hotrod.addCacheEventFilterFactory("static-filter-factory", (CacheEventFilterFactory)new EventLogListener.StaticCacheEventFilterFactory((Object)2));
        hotrod.addCacheEventFilterFactory("dynamic-filter-factory", (CacheEventFilterFactory)new EventLogListener.DynamicCacheEventFilterFactory());
        hotrod.addCacheEventConverterFactory("static-converter-factory", (CacheEventConverterFactory)new CustomEventLogListener.StaticConverterFactory());
        hotrod.addCacheEventConverterFactory("dynamic-converter-factory", (CacheEventConverterFactory)new CustomEventLogListener.DynamicConverterFactory());
    }

    @AfterClass
    protected void teardown() {
        EndpointsCacheFactory.killCacheFactories(this.cacheFactory);
    }

    private Cache<Integer, String> getEmbeddedCache() {
        return this.cacheFactory.getEmbeddedCache().getAdvancedCache();
    }

    public void testEmbeddedPutHotRodGet() {
        Integer key = 1;
        Cache<Integer, String> embedded = this.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.get((Object)key)));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.put((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)remote.get((Object)key)));
        AssertJUnit.assertEquals((String)"v2", (String)((String)embedded.remove((Object)key)));
    }

    public void testHotRodPutEmbeddedGet() {
        Integer key = 2;
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        Cache<Integer, String> embedded = this.getEmbeddedCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.get((Object)key)));
        AssertJUnit.assertEquals(null, (String)((String)remote.put((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v3")));
        AssertJUnit.assertEquals((String)"v3", (String)((String)embedded.get((Object)key)));
        AssertJUnit.assertEquals((String)"v3", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)key)));
    }

    public void testEmbeddedPutIfAbsentHotRodGet() {
        Integer key = 3;
        Cache<Integer, String> embedded = this.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.putIfAbsent((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.get((Object)key)));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.putIfAbsent((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.get((Object)key)));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.remove((Object)key)));
    }

    public void testHotRodPutIfAbsentEmbeddedGet() {
        Integer key = 4;
        Cache<Integer, String> embedded = this.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsent((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.get((Object)key)));
        AssertJUnit.assertEquals(null, (String)((String)remote.putIfAbsent((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsent((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.get((Object)key)));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)key)));
    }

    public void testEmbeddedReplaceHotRodGet() {
        Integer key = 5;
        Cache<Integer, String> embedded = this.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.replace((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals(null, (String)((String)embedded.put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.replace((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)remote.get((Object)key)));
        AssertJUnit.assertEquals((String)"v2", (String)((String)embedded.remove((Object)key)));
    }

    public void testHotRodReplaceEmbeddedGet() {
        Integer key = 6;
        Cache<Integer, String> embedded = this.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).replace((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).replace((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)embedded.get((Object)key)));
    }

    public void testEmbeddedReplaceConditionalHotRodGet() {
        Integer key = 7;
        Cache<Integer, String> embedded = this.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.put((Object)key, (Object)"v1")));
        AssertJUnit.assertTrue((boolean)embedded.replace((Object)key, (Object)"v1", (Object)"v2"));
        AssertJUnit.assertEquals((String)"v2", (String)((String)remote.get((Object)key)));
        AssertJUnit.assertEquals((String)"v2", (String)((String)embedded.remove((Object)key)));
    }

    public void testHotRodReplaceConditionalEmbeddedGet() {
        Integer key = 8;
        Cache<Integer, String> embedded = this.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.put((Object)key, (Object)"v1")));
        VersionedValue versioned = remote.getVersioned((Object)key);
        AssertJUnit.assertEquals((String)"v1", (String)((String)versioned.getValue()));
        AssertJUnit.assertTrue((0L != versioned.getVersion() ? 1 : 0) != 0);
        AssertJUnit.assertFalse((boolean)remote.replaceWithVersion((Object)key, (Object)"v2", Long.MAX_VALUE));
        AssertJUnit.assertTrue((boolean)remote.replaceWithVersion((Object)key, (Object)"v2", versioned.getVersion()));
        AssertJUnit.assertEquals((String)"v2", (String)((String)embedded.get((Object)key)));
        AssertJUnit.assertEquals((String)"v2", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)key)));
    }

    public void testEmbeddedRemoveHotRodGet() {
        Integer key = 9;
        Cache<Integer, String> embedded = this.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.remove((Object)key)));
        AssertJUnit.assertEquals(null, (String)((String)remote.get((Object)key)));
    }

    public void testHotRodRemoveEmbeddedGet() {
        Integer key = 10;
        Cache<Integer, String> embedded = this.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)key)));
        AssertJUnit.assertEquals(null, (String)((String)embedded.get((Object)key)));
    }

    public void testEmbeddedRemoveConditionalHotRodGet() {
        Integer key = 11;
        Cache<Integer, String> embedded = this.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.put((Object)key, (Object)"v1")));
        AssertJUnit.assertFalse((boolean)embedded.remove((Object)key, (Object)"vX"));
        AssertJUnit.assertTrue((boolean)embedded.remove((Object)key, (Object)"v1"));
        AssertJUnit.assertEquals(null, (String)((String)remote.get((Object)key)));
    }

    public void testHotRodRemoveConditionalEmbeddedGet() {
        Integer key = 12;
        Cache<Integer, String> embedded = this.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1")));
        VersionedValue versioned = remote.getVersioned((Object)key);
        AssertJUnit.assertFalse((boolean)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).removeWithVersion((Object)key, Long.MAX_VALUE));
        AssertJUnit.assertTrue((boolean)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).removeWithVersion((Object)key, versioned.getVersion()));
        AssertJUnit.assertEquals(null, (String)((String)embedded.get((Object)key)));
    }

    public void testEventReceiveBasic() {
        EventLogListener l = new EventLogListener(this.cacheFactory.getHotRodCache());
        HotRodClientTestingUtil.withClientListener((RemoteCacheSupplier)l, remote -> {
            l.expectNoEvents();
            remote.remove((Object)1);
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            AssertJUnit.assertEquals((String)"one", (String)((String)this.getEmbeddedCache().get((Object)1)));
            l.expectOnlyCreatedEvent((Object)1);
            remote.put((Object)1, (Object)"new-one");
            AssertJUnit.assertEquals((String)"new-one", (String)((String)this.getEmbeddedCache().get((Object)1)));
            l.expectOnlyModifiedEvent((Object)1);
            remote.remove((Object)1);
            l.expectOnlyRemovedEvent((Object)1);
        });
    }

    public void testEventReceiveConditional() {
        EventLogListener l = new EventLogListener(this.cacheFactory.getHotRodCache());
        HotRodClientTestingUtil.withClientListener((RemoteCacheSupplier)l, remote -> {
            l.expectNoEvents();
            remote.putIfAbsent((Object)1, (Object)"one");
            l.expectOnlyCreatedEvent((Object)1);
            remote.putIfAbsent((Object)1, (Object)"again");
            l.expectNoEvents();
            remote.replace((Object)1, (Object)"newone");
            l.expectOnlyModifiedEvent((Object)1);
            remote.replaceWithVersion((Object)1, (Object)"one", 0L);
            l.expectNoEvents();
            VersionedValue versioned = remote.getVersioned((Object)1);
            remote.replaceWithVersion((Object)1, (Object)"one", versioned.getVersion());
            l.expectOnlyModifiedEvent((Object)1);
            remote.removeWithVersion((Object)1, 0L);
            l.expectNoEvents();
            versioned = remote.getVersioned((Object)1);
            remote.removeWithVersion((Object)1, versioned.getVersion());
            l.expectOnlyRemovedEvent((Object)1);
        });
    }

    public void testEventReplayAfterAddingListener() {
        EventLogWithStateListener<Integer> l = new EventLogWithStateListener<Integer>(this.cacheFactory.getHotRodCache());
        this.createRemove();
        l.expectNoEvents();
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectUnorderedEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, new Integer[]{1, 2});
            remote.remove((Object)1);
            l.expectOnlyRemovedEvent(1);
            remote.remove((Object)2);
            l.expectOnlyRemovedEvent(2);
        });
    }

    public void testEventNoReplayAfterAddingListener() {
        this.createRemove();
        EventLogListener l = new EventLogListener(this.cacheFactory.getHotRodCache());
        l.expectNoEvents();
        HotRodClientTestingUtil.withClientListener((RemoteCacheSupplier)l, remote -> {
            l.expectNoEvents();
            remote.remove((Object)1);
            l.expectOnlyRemovedEvent((Object)1);
            remote.remove((Object)2);
            l.expectOnlyRemovedEvent((Object)2);
        });
    }

    private void createRemove() {
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        Cache<Integer, String> embedded = this.getEmbeddedCache();
        remote.put((Object)1, (Object)"one");
        AssertJUnit.assertEquals((String)"one", (String)((String)embedded.get((Object)1)));
        remote.put((Object)2, (Object)"two");
        AssertJUnit.assertEquals((String)"two", (String)((String)embedded.get((Object)2)));
        remote.put((Object)3, (Object)"three");
        AssertJUnit.assertEquals((String)"three", (String)((String)embedded.get((Object)3)));
        remote.remove((Object)3);
        AssertJUnit.assertNull((Object)embedded.get((Object)3));
    }

    public void testEventFilteringStatic() {
        EventLogListener.StaticFilteredEventLogListener l = new EventLogListener.StaticFilteredEventLogListener(this.cacheFactory.getHotRodCache());
        HotRodClientTestingUtil.withClientListener((RemoteCacheSupplier)l, remote -> {
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            Cache<Integer, String> embedded = this.getEmbeddedCache();
            AssertJUnit.assertEquals((String)"one", (String)((String)embedded.get((Object)1)));
            l.expectNoEvents();
            remote.put((Object)2, (Object)"two");
            AssertJUnit.assertEquals((String)"two", (String)((String)embedded.get((Object)2)));
            l.expectOnlyCreatedEvent((Object)2);
            remote.remove((Object)1);
            AssertJUnit.assertNull((Object)embedded.get((Object)1));
            l.expectNoEvents();
            remote.remove((Object)2);
            AssertJUnit.assertNull((Object)embedded.get((Object)2));
            l.expectOnlyRemovedEvent((Object)2);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventFilteringDynamic() {
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        EventLogListener.DynamicFilteredEventLogListener eventListener = new EventLogListener.DynamicFilteredEventLogListener(remote);
        Cache<Integer, String> embedded = this.getEmbeddedCache();
        remote.addClientListener((Object)eventListener, new Object[]{3}, null);
        try {
            eventListener.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            AssertJUnit.assertEquals((String)"one", (String)((String)embedded.get((Object)1)));
            eventListener.expectNoEvents();
            remote.put((Object)2, (Object)"two");
            AssertJUnit.assertEquals((String)"two", (String)((String)embedded.get((Object)2)));
            eventListener.expectNoEvents();
            remote.put((Object)3, (Object)"three");
            AssertJUnit.assertEquals((String)"three", (String)((String)embedded.get((Object)3)));
            eventListener.expectOnlyCreatedEvent((Object)3);
            remote.replace((Object)1, (Object)"new-one");
            AssertJUnit.assertEquals((String)"new-one", (String)((String)embedded.get((Object)1)));
            eventListener.expectNoEvents();
            remote.replace((Object)2, (Object)"new-two");
            AssertJUnit.assertEquals((String)"new-two", (String)((String)embedded.get((Object)2)));
            eventListener.expectNoEvents();
            remote.replace((Object)3, (Object)"new-three");
            AssertJUnit.assertEquals((String)"new-three", (String)((String)embedded.get((Object)3)));
            eventListener.expectOnlyModifiedEvent((Object)3);
            remote.remove((Object)1);
            AssertJUnit.assertNull((Object)embedded.get((Object)1));
            eventListener.expectNoEvents();
            remote.remove((Object)2);
            AssertJUnit.assertNull((Object)embedded.get((Object)2));
            eventListener.expectNoEvents();
            remote.remove((Object)3);
            AssertJUnit.assertNull((Object)embedded.get((Object)3));
            eventListener.expectOnlyRemovedEvent((Object)3);
        }
        finally {
            remote.removeClientListener((Object)eventListener);
        }
    }

    public void testCustomEvents() {
        CustomEventLogListener.StaticCustomEventLogListener l = new CustomEventLogListener.StaticCustomEventLogListener(this.cacheFactory.getHotRodCache());
        HotRodClientTestingUtil.withClientListener((RemoteCacheSupplier)l, remote -> {
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            Cache<Integer, String> embedded = this.getEmbeddedCache();
            AssertJUnit.assertEquals((String)"one", (String)((String)embedded.get((Object)1)));
            l.expectCreatedEvent((Object)new CustomEventLogListener.CustomEvent((Object)1, "one", 0));
            remote.put((Object)1, (Object)"new-one");
            AssertJUnit.assertEquals((String)"new-one", (String)((String)embedded.get((Object)1)));
            l.expectModifiedEvent((Object)new CustomEventLogListener.CustomEvent((Object)1, "new-one", 0));
            remote.remove((Object)1);
            AssertJUnit.assertNull((Object)embedded.get((Object)1));
            l.expectRemovedEvent((Object)new CustomEventLogListener.CustomEvent((Object)1, null, 0));
        });
    }

    public void testCustomEventsDynamic() {
        CustomEventLogListener.DynamicCustomEventLogListener l = new CustomEventLogListener.DynamicCustomEventLogListener(this.cacheFactory.getHotRodCache());
        HotRodClientTestingUtil.withClientListener((RemoteCacheSupplier)l, null, (Object[])new Object[]{2}, remote -> {
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            Cache<Integer, String> embedded = this.getEmbeddedCache();
            AssertJUnit.assertEquals((String)"one", (String)((String)embedded.get((Object)1)));
            l.expectCreatedEvent((Object)new CustomEventLogListener.CustomEvent((Object)1, "one", 0));
            remote.put((Object)2, (Object)"two");
            AssertJUnit.assertEquals((String)"two", (String)((String)embedded.get((Object)2)));
            l.expectCreatedEvent((Object)new CustomEventLogListener.CustomEvent((Object)2, null, 0));
            remote.remove((Object)1);
            AssertJUnit.assertNull((Object)embedded.get((Object)1));
            l.expectRemovedEvent((Object)new CustomEventLogListener.CustomEvent((Object)1, null, 0));
            remote.remove((Object)2);
            AssertJUnit.assertNull((Object)embedded.get((Object)2));
            l.expectRemovedEvent((Object)new CustomEventLogListener.CustomEvent((Object)2, null, 0));
        });
    }

    @ClientListener(includeCurrentState=true)
    public static class EventLogWithStateListener<K>
    extends EventLogListener<K> {
        public EventLogWithStateListener(RemoteCache<K, ?> r) {
            super(r);
        }
    }
}

