/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.util.CloseableIteratorSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.endpoints.EndpointsCacheFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.endpoints.EmbeddedHotRodBulkTest")
public class EmbeddedHotRodBulkTest
extends AbstractInfinispanTest {
    EndpointsCacheFactory<Integer, Integer> cacheFactory;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory = new EndpointsCacheFactory(CacheMode.LOCAL).setup();
    }

    @AfterClass
    protected void teardown() {
        EndpointsCacheFactory.killCacheFactories(this.cacheFactory);
    }

    private void populateCacheManager(BasicCache cache) {
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)i);
        }
    }

    public void testEmbeddedPutHotRodKeySet() {
        Cache<Integer, Integer> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, Integer> remote = this.cacheFactory.getHotRodCache();
        this.populateCacheManager((BasicCache)embedded);
        CloseableIteratorSet keySet = remote.keySet();
        AssertJUnit.assertEquals((int)100, (int)keySet.size());
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)keySet.contains(i));
        }
    }

    public void testHotRodPutEmbeddedKeySet() {
        Cache<Integer, Integer> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, Integer> remote = this.cacheFactory.getHotRodCache();
        this.populateCacheManager((BasicCache)remote);
        CacheSet keySet = embedded.keySet();
        AssertJUnit.assertEquals((int)100, (int)keySet.size());
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)keySet.contains(i));
        }
    }
}

