/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.endpoints.EndpointsCacheFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.interop.CustomMemcachedHotRodTest")
public class CustomMemcachedHotRodTest
extends AbstractInfinispanTest {
    static final String CACHE_NAME = "memcachedCache";
    EndpointsCacheFactory<String, String> cacheFactory;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory = new EndpointsCacheFactory(CACHE_NAME, (Marshaller)new UTF8StringMarshaller(), CacheMode.LOCAL).setup();
    }

    @AfterClass
    protected void teardown() {
        EndpointsCacheFactory.killCacheFactories(this.cacheFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHotRodPutMemcachedGet() throws IOException {
        String key = "1";
        RemoteCache<String, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertNull((Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"1", (Object)"v1"));
        try (MemcachedClient memcached = new MemcachedClient("localhost", this.cacheFactory.getMemcachedPort());){
            AssertJUnit.assertEquals((byte[])"v1".getBytes(), (byte[])memcached.getBytes("1"));
        }
    }

    public void testMemcachedPutGet() throws IOException {
        String key = "1";
        try (MemcachedClient memcached = new MemcachedClient("localhost", this.cacheFactory.getMemcachedPort());){
            memcached.set("1", "v1");
            AssertJUnit.assertEquals((String)"v1", (String)memcached.get("1"));
        }
    }

    static class MemcachedClient {
        private static final int DEFAULT_TIMEOUT = 10000;
        private static final String DEFAULT_ENCODING = "UTF-8";
        private String encoding;
        private Socket socket;
        private PrintWriter out;
        private InputStream input;

        public MemcachedClient(String host, int port) throws IOException {
            this(DEFAULT_ENCODING, host, port, 10000);
        }

        public MemcachedClient(String enc, String host, int port, int timeout) throws IOException {
            this.encoding = enc;
            this.socket = new Socket(host, port);
            this.socket.setSoTimeout(timeout);
            this.out = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), this.encoding));
            this.input = this.socket.getInputStream();
        }

        public String get(String key) throws IOException {
            byte[] data = this.getBytes(key);
            return data == null ? null : new String(data, this.encoding);
        }

        public byte[] getBytes(String key) throws IOException {
            this.writeln("get " + key);
            this.flush();
            String valueStr = this.readln();
            if (valueStr.startsWith("VALUE")) {
                String[] value = valueStr.split(" ");
                AssertJUnit.assertEquals((String)key, (String)value[1]);
                int size = new Integer(value[3]);
                byte[] ret = this.read(size);
                AssertJUnit.assertEquals((int)13, (int)this.read());
                AssertJUnit.assertEquals((int)10, (int)this.read());
                AssertJUnit.assertEquals((String)"END", (String)this.readln());
                return ret;
            }
            return null;
        }

        public void set(String key, String value) throws IOException {
            this.writeln("set " + key + " 0 0 " + value.getBytes(this.encoding).length);
            this.writeln(value);
            this.flush();
            AssertJUnit.assertEquals((String)"STORED", (String)this.readln());
        }

        private byte[] read(int len) throws IOException {
            try {
                byte[] ret = new byte[len];
                this.input.read(ret, 0, len);
                return ret;
            }
            catch (SocketTimeoutException ste) {
                return null;
            }
        }

        private byte read() throws IOException {
            try {
                return (byte)this.input.read();
            }
            catch (SocketTimeoutException ste) {
                return -1;
            }
        }

        private String readln() throws IOException {
            byte[] buf = new byte[512];
            int maxlen = 512;
            int read = 0;
            buf[read] = this.read();
            while (buf[read] != 10) {
                if (++read == maxlen) {
                    buf = Arrays.copyOf(buf, maxlen += 512);
                }
                buf[read] = this.read();
            }
            if (read == 0) {
                return "";
            }
            if (buf[read - 1] == 13) {
                --read;
            }
            buf = Arrays.copyOf(buf, read);
            return new String(buf, this.encoding);
        }

        private void writeln(String str) {
            this.out.print(str + "\r\n");
        }

        private void flush() {
            this.out.flush();
        }

        public void close() throws IOException {
            this.socket.close();
        }
    }
}

