/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASValue;
import net.spy.memcached.internal.OperationFuture;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.endpoints.EndpointsCacheFactory;
import org.infinispan.it.endpoints.MemcachedEncoder;
import org.infinispan.it.endpoints.SpyMemcachedMarshaller;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="it.endpoints.EmbeddedRestMemcachedHotRodTest")
public class EmbeddedRestMemcachedHotRodTest
extends AbstractInfinispanTest {
    static final String CACHE_NAME = "memcachedCache";
    protected EndpointsCacheFactory<String, Object> cacheFactory;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory = new EndpointsCacheFactory(CACHE_NAME, (Marshaller)new SpyMemcachedMarshaller(), CacheMode.LOCAL, (Encoder)new MemcachedEncoder()).setup();
    }

    @AfterClass
    protected void teardown() {
        EndpointsCacheFactory.killCacheFactories(this.cacheFactory);
    }

    public void testMemcachedPutEmbeddedRestHotRodGetTest() throws Exception {
        String key = "1";
        OperationFuture f = this.cacheFactory.getMemcachedClient().set("1", 0, (Object)"v1");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getEmbeddedCache().get((Object)"1"));
        GetMethod get = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "1");
        get.setRequestHeader("Accept", "text/plain");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((String)"v1", (String)get.getResponseBodyAsString());
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getHotRodCache().get((Object)"1"));
    }

    public void testEmbeddedPutMemcachedRestHotRodGetTest() throws Exception {
        String key = "2";
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getEmbeddedCache().put((Object)"2", (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getMemcachedClient().get("2"));
        GetMethod get = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "2");
        get.setRequestHeader("Accept", "text/plain");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((String)"v1", (String)get.getResponseBodyAsString());
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getHotRodCache().get((Object)"2"));
    }

    public void testRestPutEmbeddedMemcachedHotRodGetTest() throws Exception {
        String key = "3";
        PutMethod put = new PutMethod(this.cacheFactory.getRestUrl() + "/" + "3");
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity("<hey>ho</hey>".getBytes(), "text/plain"));
        HttpClient restClient = this.cacheFactory.getRestClient();
        restClient.executeMethod((HttpMethod)put);
        AssertJUnit.assertEquals((int)204, (int)put.getStatusCode());
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)this.cacheFactory.getEmbeddedCache().get((Object)"3"));
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)this.cacheFactory.getMemcachedClient().get("3"));
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)this.cacheFactory.getHotRodCache().get((Object)"3"));
    }

    public void testHotRodPutEmbeddedMemcachedRestGetTest() throws Exception {
        String key = "4";
        RemoteCache<String, Object> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"4", (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getEmbeddedCache().get((Object)"4"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getMemcachedClient().get("4"));
        GetMethod get = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "4");
        get.setRequestHeader("Accept", "text/plain");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((String)"v1", (String)get.getResponseBodyAsString());
    }

    public void testEmbeddedReplaceMemcachedCASTest() throws Exception {
        String key1 = "5";
        OperationFuture f = this.cacheFactory.getMemcachedClient().set("5", 0, (Object)"v1");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        CASValue oldValue = this.cacheFactory.getMemcachedClient().gets("5");
        AssertJUnit.assertTrue((boolean)this.cacheFactory.getEmbeddedCache().replace((Object)"5", (Object)"v1", (Object)"v2"));
        CASValue newValue = this.cacheFactory.getMemcachedClient().gets("5");
        AssertJUnit.assertEquals((Object)"v2", (Object)newValue.getValue());
        AssertJUnit.assertNotSame((String)("The version (CAS) should have changed, oldCase=" + oldValue.getCas() + ", newCas=" + newValue.getCas()), (Object)oldValue.getCas(), (Object)newValue.getCas());
    }

    public void testHotRodReplaceMemcachedCASTest() throws Exception {
        String key1 = "6";
        OperationFuture f = this.cacheFactory.getMemcachedClient().set("6", 0, (Object)"v1");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        CASValue oldValue = this.cacheFactory.getMemcachedClient().gets("6");
        MetadataValue versioned = this.cacheFactory.getHotRodCache().getWithMetadata((Object)"6");
        AssertJUnit.assertTrue((boolean)this.cacheFactory.getHotRodCache().replaceWithVersion((Object)"6", (Object)"v2", versioned.getVersion()));
        CASValue newValue = this.cacheFactory.getMemcachedClient().gets("6");
        AssertJUnit.assertEquals((Object)"v2", (Object)newValue.getValue());
        AssertJUnit.assertTrue((String)"The version (CAS) should have changed", (oldValue.getCas() != newValue.getCas() ? 1 : 0) != 0);
    }

    public void testEmbeddedHotRodReplaceMemcachedCASTest() throws Exception {
        String key1 = "7";
        OperationFuture f = this.cacheFactory.getMemcachedClient().set("7", 0, (Object)"v1");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        CASValue oldValue = this.cacheFactory.getMemcachedClient().gets("7");
        MetadataValue versioned = this.cacheFactory.getHotRodCache().getWithMetadata((Object)"7");
        AssertJUnit.assertTrue((boolean)this.cacheFactory.getHotRodCache().replaceWithVersion((Object)"7", (Object)"v2", versioned.getVersion()));
        AssertJUnit.assertTrue((boolean)this.cacheFactory.getEmbeddedCache().replace((Object)"7", (Object)"v2", (Object)"v3"));
        CASValue newValue = this.cacheFactory.getMemcachedClient().gets("7");
        AssertJUnit.assertEquals((Object)"v3", (Object)newValue.getValue());
        AssertJUnit.assertTrue((String)"The version (CAS) should have changed", (oldValue.getCas() != newValue.getCas() ? 1 : 0) != 0);
    }
}

