/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.endpoints.EndpointsCacheFactory;
import org.infinispan.it.endpoints.TestCacheListener;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.endpoints.EmbeddedRestCacheListenerTest")
public class EmbeddedRestCacheListenerTest
extends AbstractInfinispanTest {
    EndpointsCacheFactory<String, String> cacheFactory;

    @BeforeMethod
    protected void setup() throws Exception {
        this.cacheFactory = new EndpointsCacheFactory(CacheMode.LOCAL).setup();
    }

    @AfterMethod
    protected void teardown() {
        EndpointsCacheFactory.killCacheFactories(this.cacheFactory);
    }

    public void testLoadingAndStoringEventsRest() {
        Cache<String, String> embedded = this.cacheFactory.getEmbeddedCache();
        RestCacheClient remote = this.cacheFactory.getRestCacheClient();
        TestCacheListener l = new TestCacheListener();
        embedded.addListener((Object)l);
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        RestEntity v = RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (byte[])"v".getBytes());
        CompletionStages.join((CompletionStage)remote.put("k", v));
        AssertJUnit.assertEquals((int)1, (int)l.createdCounter);
        AssertJUnit.assertEquals((byte[])"v".getBytes(), (byte[])((byte[])l.created.get("k")));
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)0, (int)l.modifiedCounter);
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        RestEntity value = RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (byte[])"value".getBytes());
        CompletionStages.join((CompletionStage)remote.put("key", value));
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)0, (int)l.modifiedCounter);
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        RestEntity modifiedValue = RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (byte[])"modifiedValue".getBytes());
        CompletionStages.join((CompletionStage)remote.put("key", modifiedValue));
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.modifiedCounter);
        AssertJUnit.assertEquals((byte[])"modifiedValue".getBytes(), (byte[])((byte[])l.modified.get("key")));
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        RestEntity replacedValue = RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (byte[])"replacedValue".getBytes());
        CompletionStages.join((CompletionStage)remote.put("k", replacedValue));
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)2, (int)l.modifiedCounter);
        AssertJUnit.assertEquals((byte[])"replacedValue".getBytes(), (byte[])((byte[])l.modified.get("k")));
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        l.reset();
        CompletionStages.join((CompletionStage)remote.remove("key"));
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.removedCounter);
        AssertJUnit.assertEquals((byte[])"modifiedValue".getBytes(), (byte[])((byte[])l.removed.get("key")));
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        l.reset();
        CompletionStages.join((CompletionStage)remote.get("k"));
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.visitedCounter);
        AssertJUnit.assertEquals((byte[])"replacedValue".getBytes(), (byte[])((byte[])l.visited.get("k")));
        l.reset();
    }
}

