/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import java.util.concurrent.CompletionStage;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.endpoints.EndpointsCacheFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.endpoints.EmbeddedRestHotRodWithStringTest")
public class EmbeddedRestHotRodWithStringTest
extends AbstractInfinispanTest {
    EndpointsCacheFactory<String, Object> cacheFactory;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory = new EndpointsCacheFactory("testCache", (Marshaller)new UTF8StringMarshaller(), CacheMode.LOCAL).setup();
    }

    @AfterClass
    protected void teardown() {
        EndpointsCacheFactory.killCacheFactories(this.cacheFactory);
    }

    public void testRestPutStringHotRodGet() {
        String key = "1";
        RestEntity value = RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (String)"<hey>ho</hey>");
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().put("1", value));
        AssertJUnit.assertEquals((int)204, (int)response.getStatus());
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)this.cacheFactory.getHotRodCache().get((Object)"1"));
        String newKey = "2";
        String newValue = "<let's>go</let's>";
        RemoteCache<String, Object> hotRodCache = this.cacheFactory.getHotRodCache();
        hotRodCache.put((Object)"2", (Object)"<let's>go</let's>");
        response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("2"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertEquals((String)"<let's>go</let's>", (String)response.getBody());
    }
}

