/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.endpoints.EndpointITSCI;
import org.infinispan.it.endpoints.EndpointsCacheFactory;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.rest.ResponseHeader;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.endpoints.EmbeddedRestHotRodTest")
public class EmbeddedRestHotRodTest
extends AbstractInfinispanTest {
    private static final DateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    EndpointsCacheFactory<String, Object> cacheFactory;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory = new EndpointsCacheFactory.Builder().withCacheMode(CacheMode.LOCAL).withContextInitializer(EndpointITSCI.INSTANCE).build();
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.cacheFactory.addRegexAllowList("org.infinispan.*Person");
    }

    @AfterClass
    protected void teardown() {
        EndpointsCacheFactory.killCacheFactories(this.cacheFactory);
    }

    public void testRestPutEmbeddedHotRodGet() {
        String key = "1";
        RestCacheClient restCacheClient = this.cacheFactory.getRestCacheClient();
        CompletionStage response = restCacheClient.put("1", RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (String)"<hey>ho</hey>"));
        AssertJUnit.assertEquals((int)204, (int)((RestResponse)CompletionStages.join((CompletionStage)response)).getStatus());
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)this.cacheFactory.getEmbeddedCache().get((Object)"1"));
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)this.cacheFactory.getHotRodCache().get((Object)"1"));
    }

    public void testEmbeddedPutRestHotRodGet() {
        String key = "2";
        AssertJUnit.assertNull((Object)this.cacheFactory.getEmbeddedCache().put((Object)"2", (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getHotRodCache().get((Object)"2"));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("2", "text/plain"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertEquals((String)"v1", (String)response.getBody());
    }

    public void testHotRodPutEmbeddedRestGet() {
        String key = "3";
        RemoteCache<String, Object> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertNull((Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"3", (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getEmbeddedCache().get((Object)"3"));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("3", "text/plain"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertEquals((String)"v1", (String)response.getBody());
    }

    public void testCustomObjectHotRodPutEmbeddedRestGet() throws Exception {
        String key = "4";
        Person p = new Person("Martin");
        RemoteCache<String, Object> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertNull((Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"4", (Object)p));
        AssertJUnit.assertEquals((Object)p, (Object)this.cacheFactory.getEmbeddedCache().get((Object)"4"));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("4", "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertEquals((Object)p, (Object)new ObjectInputStream(response.getBodyAsStream()).readObject());
    }

    public void testCustomObjectEmbeddedPutHotRodRestGet() throws Exception {
        String key = "5";
        Person p = new Person("Galder");
        AssertJUnit.assertNull((Object)this.cacheFactory.getEmbeddedCache().put((Object)"5", (Object)p));
        AssertJUnit.assertEquals((Object)p, (Object)this.cacheFactory.getHotRodCache().get((Object)"5"));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("5", "application/x-java-serialized-object, application/json;q=0.3"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertEquals((Object)p, (Object)new ObjectInputStream(response.getBodyAsStream()).readObject());
    }

    public void testCustomObjectEmbeddedPutRestGetAcceptJSONAndXML() {
        String key = "6";
        Person p = new Person("Anna");
        AssertJUnit.assertNull((Object)this.cacheFactory.getEmbeddedCache().put((Object)"6", (Object)p));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("6", "application/json"));
        String body = response.getBody();
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertEquals((String)this.asJson(p), (String)body);
        response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("6", "application/xml"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertTrue((boolean)response.getBody().contains("<name>Anna</name>"));
    }

    public void testCustomObjectHotRodPutRestGetAcceptJSONAndXML() {
        String key = "7";
        Person p = new Person("Jakub");
        RemoteCache<String, Object> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertNull((Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"7", (Object)p));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("7", "application/json"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertEquals((String)this.asJson(p), (String)response.getBody());
        response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("7", "application/xml"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertTrue((boolean)response.getBody().contains("<name>Jakub</name>"));
    }

    public void testCustomObjectRestPutHotRodEmbeddedGet() throws Exception {
        String key = "77";
        Person p = new Person("Iker");
        RestCacheClient restClient = this.cacheFactory.getRestCacheClient();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bout);){
            oos.writeObject(p);
        }
        RestEntity value = RestEntity.create((MediaType)MediaType.APPLICATION_SERIALIZED_OBJECT, (InputStream)new ByteArrayInputStream(bout.toByteArray()));
        CompletionStages.join((CompletionStage)restClient.put("77", value));
        RemoteCache<String, Object> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals((Object)p, (Object)remote.get((Object)"77"));
        AssertJUnit.assertEquals((Object)p, (Object)this.cacheFactory.getEmbeddedCache().getAdvancedCache().get((Object)"77"));
    }

    public void testHotRodEmbeddedPutRestHeadExpiry() throws Exception {
        String key1 = "8";
        String key2 = "9";
        AssertJUnit.assertNull((Object)this.cacheFactory.getHotRodCache().put((Object)"8", (Object)"v1", 5L, TimeUnit.SECONDS));
        AssertJUnit.assertNull((Object)this.cacheFactory.getEmbeddedCache().put((Object)"9", (Object)"v2", 5L, TimeUnit.SECONDS));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().head("8"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        String expires = response.getHeader(ResponseHeader.EXPIRES_HEADER.getValue());
        AssertJUnit.assertNotNull((Object)expires);
        AssertJUnit.assertTrue((boolean)dateFormat.parse(expires).after(new GregorianCalendar(2013, 0, 1).getTime()));
        response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().head("9"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        expires = response.getHeader(ResponseHeader.EXPIRES_HEADER.getValue());
        AssertJUnit.assertNotNull((Object)expires);
    }

    public void testHotRodEmbeddedPutRestGetExpiry() throws Exception {
        String key = "10";
        String key2 = "11";
        AssertJUnit.assertNull((Object)this.cacheFactory.getHotRodCache().put((Object)"10", (Object)"v1", 5L, TimeUnit.SECONDS));
        AssertJUnit.assertNull((Object)this.cacheFactory.getEmbeddedCache().put((Object)"11", (Object)"v2", 5L, TimeUnit.SECONDS));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("10"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        EmbeddedRestHotRodTest.assertDate(response, "Expires");
        response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("11"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        EmbeddedRestHotRodTest.assertDate(response, "Expires");
    }

    public void testHotRodEmbeddedPutRestGetLastModified() throws Exception {
        String key = "12";
        String key2 = "13";
        AssertJUnit.assertNull((Object)this.cacheFactory.getHotRodCache().put((Object)"12", (Object)"v1", 5L, TimeUnit.SECONDS));
        AssertJUnit.assertNull((Object)this.cacheFactory.getEmbeddedCache().put((Object)"13", (Object)"v2", 5L, TimeUnit.SECONDS));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("12"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        EmbeddedRestHotRodTest.assertDate(response, "Last-Modified");
        response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("13"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        EmbeddedRestHotRodTest.assertDate(response, "Last-Modified");
    }

    private static void assertDate(RestResponse response, String header) throws Exception {
        String dateHeader = response.getHeader(header);
        AssertJUnit.assertNotNull((Object)dateHeader);
        Date parsedDate = dateFormat.parse(dateHeader);
        AssertJUnit.assertTrue((String)("Parsed date is before this code was written: " + parsedDate), (boolean)parsedDate.after(new GregorianCalendar(2013, 0, 1).getTime()));
    }

    public void testByteArrayHotRodEmbeddedPutRestGet() {
        String key1 = "14";
        String key2 = "15";
        RemoteCache<String, Object> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertNull((Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"14", (Object)"v1".getBytes()));
        AssertJUnit.assertNull((Object)this.cacheFactory.getEmbeddedCache().put((Object)"15", (Object)"v2".getBytes()));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("14", "text/plain"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertEquals((String)"text/plain", (String)response.getHeader(ResponseHeader.CONTENT_TYPE_HEADER.getValue()));
        AssertJUnit.assertArrayEquals((byte[])"v1".getBytes(), (byte[])response.getBodyAsByteArray());
        response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("15", "text/plain"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertEquals((String)"text/plain", (String)response.getHeader(ResponseHeader.CONTENT_TYPE_HEADER.getValue()));
        AssertJUnit.assertArrayEquals((byte[])"v2".getBytes(), (byte[])response.getBodyAsByteArray());
    }

    public void testHotRodEmbeddedPutRestGetWrongAccept() {
        String key1 = "16";
        String key2 = "17";
        AssertJUnit.assertNull((Object)this.cacheFactory.getHotRodCache().put((Object)"16", (Object)"v1"));
        AssertJUnit.assertNull((Object)this.cacheFactory.getEmbeddedCache().put((Object)"17", (Object)"v2"));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("16", "unknown-media-type"));
        AssertJUnit.assertEquals((int)406, (int)response.getStatus());
        response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("17", "unknown-media-type"));
        AssertJUnit.assertEquals((int)406, (int)response.getStatus());
    }

    public void testHotRodEmbeddedPutRestGetCacheControlHeader() {
        String key1 = "18";
        String key2 = "19";
        AssertJUnit.assertNull((Object)this.cacheFactory.getHotRodCache().put((Object)"18", (Object)"v1", 7L, TimeUnit.SECONDS));
        AssertJUnit.assertNull((Object)this.cacheFactory.getEmbeddedCache().put((Object)"19", (Object)"v2", 7L, TimeUnit.SECONDS));
        Map<String, String> headers = Collections.singletonMap("Cache-Control", "min-fresh=20");
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("18", headers));
        AssertJUnit.assertEquals((int)404, (int)response.getStatus());
        response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("19", headers));
        AssertJUnit.assertEquals((int)404, (int)response.getStatus());
        headers = new HashMap<String, String>();
        headers.put("Accept", "text/plain");
        headers.put("Cache-Control", "min-fresh=3");
        response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("18", headers));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertNotNull((Object)response.getHeader("Cache-Control"));
        AssertJUnit.assertTrue((boolean)response.getHeader("Cache-Control").contains("max-age"));
        AssertJUnit.assertEquals((String)"v1", (String)response.getBody());
        response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory.getRestCacheClient().get("19", headers));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertTrue((boolean)response.getHeader("Cache-Control").contains("max-age"));
        AssertJUnit.assertEquals((String)"v2", (String)response.getBody());
    }

    private String asJson(Person p) {
        Json person = Json.object();
        person.set("_type", (Object)p.getClass().getName());
        person.set("name", (Object)p.name);
        return person.toString();
    }

    static class Person
    implements Serializable {
        @ProtoField(number=1)
        final String name;

        @ProtoFactory
        Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return this.name.equals(person.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

