/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.endpoints.EndpointsCacheFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.endpoints.ReplEmbeddedRestHotRodTest")
public class ReplEmbeddedRestHotRodTest
extends AbstractInfinispanTest {
    EndpointsCacheFactory<Object, Object> cacheFactory1;
    EndpointsCacheFactory<Object, Object> cacheFactory2;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory1 = new EndpointsCacheFactory.Builder().withCacheMode(CacheMode.REPL_SYNC).build();
        this.cacheFactory2 = new EndpointsCacheFactory.Builder().withCacheMode(CacheMode.REPL_SYNC).build();
    }

    @AfterClass
    protected void teardown() {
        EndpointsCacheFactory.killCacheFactories(this.cacheFactory1, this.cacheFactory2);
    }

    public void testRestPutEmbeddedHotRodGet() {
        String key = "1";
        RestEntity value = RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (byte[])"<hey>ho</hey>".getBytes());
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory1.getRestCacheClient().put("1", value));
        AssertJUnit.assertEquals((int)204, (int)response.getStatus());
        AdvancedCache embeddedCache = this.cacheFactory2.getEmbeddedCache().getAdvancedCache();
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)embeddedCache.get((Object)"1"));
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)this.cacheFactory2.getHotRodCache().get((Object)"1"));
    }

    public void testEmbeddedPutRestHotRodGet() {
        String key = "2";
        AdvancedCache cache = this.cacheFactory2.getEmbeddedCache().getAdvancedCache();
        AssertJUnit.assertNull((Object)cache.put((Object)"2", (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory1.getHotRodCache().get((Object)"2"));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory2.getRestCacheClient().get("2", "text/plain"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertEquals((String)"v1", (String)response.getBody());
    }

    public void testHotRodPutEmbeddedRestGet() {
        String key = "3";
        RemoteCache<Object, Object> remote = this.cacheFactory1.getHotRodCache();
        AssertJUnit.assertEquals(null, (Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"3", (Object)"v1"));
        AdvancedCache embeddedCache = this.cacheFactory2.getEmbeddedCache().getAdvancedCache();
        AssertJUnit.assertEquals((Object)"v1", (Object)embeddedCache.get((Object)"3"));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheFactory2.getRestCacheClient().get("3", "text/plain"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertEquals((String)"v1", (String)response.getBody());
    }
}

