/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.endpoints.EndpointsCacheFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.interop.ByteArrayValueReplEmbeddedHotRodTest")
public class ByteArrayValueReplEmbeddedHotRodTest
extends AbstractInfinispanTest {
    EndpointsCacheFactory<Object, Object> cacheFactory1;
    EndpointsCacheFactory<Object, Object> cacheFactory2;

    public void testHotRodPutEmbeddedGet() {
        String key = "4";
        byte[] value = "v1".getBytes();
        RemoteCache<Object, Object> remote = this.cacheFactory1.getHotRodCache();
        AssertJUnit.assertNull((Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"4", (Object)value));
        AssertJUnit.assertArrayEquals((byte[])value, (byte[])((byte[])this.cacheFactory2.getEmbeddedCache().get((Object)"4")));
    }

    public void testHotRodReplace() {
        String key = "5";
        byte[] value1 = "v1".getBytes();
        byte[] value2 = "v2".getBytes();
        RemoteCache<Object, Object> remote = this.cacheFactory1.getHotRodCache();
        AssertJUnit.assertNull((Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"5", (Object)value1));
        MetadataValue versioned = this.cacheFactory1.getHotRodCache().getWithMetadata((Object)"5");
        AssertJUnit.assertTrue((boolean)this.cacheFactory1.getHotRodCache().replaceWithVersion((Object)"5", (Object)value2, versioned.getVersion()));
    }

    public void testHotRodRemove() {
        String key = "7";
        byte[] value = "v1".getBytes();
        RemoteCache<Object, Object> remote = this.cacheFactory1.getHotRodCache();
        AssertJUnit.assertNull((Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"7", (Object)value));
        MetadataValue versioned = this.cacheFactory1.getHotRodCache().getWithMetadata((Object)"7");
        AssertJUnit.assertTrue((boolean)this.cacheFactory1.getHotRodCache().removeWithVersion((Object)"7", versioned.getVersion()));
    }

    public void testEmbeddedPutHotRodGet() {
        String key = "8";
        byte[] value = "v1".getBytes();
        AssertJUnit.assertNull((Object)this.cacheFactory2.getEmbeddedCache().put((Object)"8", (Object)value));
        AssertJUnit.assertArrayEquals((byte[])value, (byte[])((byte[])this.cacheFactory1.getHotRodCache().get((Object)"8")));
    }

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory1 = new EndpointsCacheFactory.Builder().withCacheMode(CacheMode.REPL_SYNC).build();
        this.cacheFactory2 = new EndpointsCacheFactory.Builder().withCacheMode(CacheMode.REPL_SYNC).build();
    }

    @AfterClass
    protected void teardown() {
        EndpointsCacheFactory.killCacheFactories(this.cacheFactory1, this.cacheFactory2);
    }
}

