/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.marshall.IdentityMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.it.endpoints.CustomKey;
import org.infinispan.it.endpoints.EndpointITSCI;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.rest.RequestHeader;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.testng.internal.junit.ArrayAsserts;

@Test(groups={"functional", "smoke"}, testName="it.endpoints.EndpointInteroperabilityTest")
public class EndpointInteroperabilityTest
extends AbstractInfinispanTest {
    private static final String DEFAULT_CACHE_NAME = "defaultCache";
    private static final String MARSHALLED_CACHE_NAME = "marshalledCache";
    private static final String STRING_CACHE_NAME = "stringsCaches";
    private RestServer restServer;
    private HotRodServer hotRodServer;
    private RestClient restClient;
    private EmbeddedCacheManager cacheManager;
    private RemoteCache<byte[], byte[]> defaultRemoteCache;
    private RemoteCache<Object, Object> defaultMarshalledRemoteCache;
    private RemoteCache<String, String> stringRemoteCache;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createServerModeCacheManager();
        this.cacheManager.defineConfiguration(DEFAULT_CACHE_NAME, this.getDefaultCacheConfiguration().build());
        this.cacheManager.defineConfiguration(MARSHALLED_CACHE_NAME, this.getMarshalledCacheConfiguration().build());
        this.cacheManager.defineConfiguration(STRING_CACHE_NAME, this.getStringsCacheConfiguration().build());
        RestServerConfigurationBuilder builder = new RestServerConfigurationBuilder();
        builder.port(ServerTestingUtil.findFreePort());
        this.restServer = new RestServer();
        this.restServer.start((ProtocolServerConfiguration)builder.build(), this.cacheManager);
        RestClientConfigurationBuilder clientBuilder = new RestClientConfigurationBuilder();
        RestClientConfiguration configuration = clientBuilder.addServer().host(this.restServer.getHost()).port(this.restServer.getPort().intValue()).build();
        this.restClient = RestClient.forConfiguration((RestClientConfiguration)configuration);
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (HotRodServerConfigurationBuilder)serverBuilder);
        this.defaultRemoteCache = this.createRemoteCacheManager((Marshaller)IdentityMarshaller.INSTANCE).getCache(DEFAULT_CACHE_NAME);
        this.defaultMarshalledRemoteCache = this.createRemoteCacheManager(null).getCache(MARSHALLED_CACHE_NAME);
        this.stringRemoteCache = this.createRemoteCacheManager((Marshaller)new UTF8StringMarshaller()).getCache(STRING_CACHE_NAME);
    }

    private org.infinispan.configuration.cache.ConfigurationBuilder getDefaultCacheConfiguration() {
        return new org.infinispan.configuration.cache.ConfigurationBuilder();
    }

    private org.infinispan.configuration.cache.ConfigurationBuilder getMarshalledCacheConfiguration() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.encoding().key().mediaType("application/x-protostream");
        builder.encoding().value().mediaType("application/x-protostream");
        return builder;
    }

    private org.infinispan.configuration.cache.ConfigurationBuilder getStringsCacheConfiguration() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.encoding().key().mediaType("text/plain");
        builder.encoding().value().mediaType("text/plain");
        return builder;
    }

    private RemoteCacheManager createRemoteCacheManager(Marshaller marshaller) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("localhost").port(this.hotRodServer.getPort().intValue());
        if (marshaller != null) {
            builder.marshaller(marshaller);
        }
        return new RemoteCacheManager(builder.build());
    }

    @Test
    public void testStringKeysAndByteArrayValue() throws Exception {
        String key = "string-1";
        byte[] value = new byte[]{1, 2, 3};
        byte[] marshalledValue = new ProtoStreamMarshaller().objectToByteBuffer((Object)value);
        this.defaultMarshalledRemoteCache.put((Object)key, (Object)value);
        Assert.assertEquals((Object)this.defaultMarshalledRemoteCache.get((Object)key), (Object)value);
        Object rawFromRest = new RestRequest().cache(MARSHALLED_CACHE_NAME).key(key).accept(MediaType.APPLICATION_PROTOSTREAM).read();
        ArrayAsserts.assertArrayEquals((byte[])((byte[])rawFromRest), (byte[])marshalledValue);
        String otherKey = "string-2";
        byte[] otherValue = new byte[]{4, 5, 6};
        byte[] otherValueMarshalled = new ProtoStreamMarshaller().objectToByteBuffer((Object)otherValue);
        new RestRequest().cache(MARSHALLED_CACHE_NAME).key(otherKey).value((Object)otherValue, MediaType.APPLICATION_OCTET_STREAM).write();
        Assert.assertEquals((Object)this.defaultMarshalledRemoteCache.get((Object)otherKey), (Object)otherValue);
        DataFormat format = DataFormat.builder().keyType(MediaType.TEXT_PLAIN).valueType(MediaType.APPLICATION_PROTOSTREAM).valueMarshaller((Marshaller)IdentityMarshaller.INSTANCE).build();
        byte[] rawValue = (byte[])this.defaultMarshalledRemoteCache.withDataFormat(format).get((Object)otherKey);
        ArrayAsserts.assertArrayEquals((byte[])otherValueMarshalled, (byte[])rawValue);
        DataFormat.builder().keyType(MediaType.TEXT_PLAIN).build();
        byte[] result = (byte[])this.defaultMarshalledRemoteCache.withDataFormat(DataFormat.builder().keyType(MediaType.TEXT_PLAIN).build()).get((Object)otherKey);
        ArrayAsserts.assertArrayEquals((byte[])otherValue, (byte[])result);
    }

    @Test
    public void testIntegerKeysAndByteArrayValue() {
        String integerKeyType = "application/x-java-object; type=java.lang.Integer";
        byte[] value = new byte[]{12};
        byte[] otherValue = "random".getBytes(StandardCharsets.UTF_8);
        this.defaultMarshalledRemoteCache.put((Object)10, (Object)value);
        Assert.assertEquals((Object)this.defaultMarshalledRemoteCache.get((Object)10), (Object)value);
        Object bytesFromRest = new RestRequest().cache(MARSHALLED_CACHE_NAME).key("10", integerKeyType).accept(MediaType.APPLICATION_OCTET_STREAM).read();
        ArrayAsserts.assertArrayEquals((byte[])((byte[])bytesFromRest), (byte[])value);
        new RestRequest().cache(MARSHALLED_CACHE_NAME).key("20", integerKeyType).value(otherValue).write();
        Assert.assertEquals((Object)this.defaultMarshalledRemoteCache.get((Object)20), (Object)otherValue);
    }

    @Test
    public void testFloatKeysDoubleValues() throws Exception {
        String floatContentType = "application/x-java-object; type=java.lang.Float";
        String doubleContentType = "application/x-java-object; type=java.lang.Double";
        ProtoStreamMarshaller marshaller = new ProtoStreamMarshaller();
        Float key = Float.valueOf(1.1f);
        Double value = 32.4;
        byte[] valueMarshalled = marshaller.objectToByteBuffer((Object)value);
        this.defaultMarshalledRemoteCache.put((Object)key, (Object)value);
        Assert.assertEquals((Object)this.defaultMarshalledRemoteCache.get((Object)key), (Object)value);
        Object bytesFromRest = new RestRequest().cache(MARSHALLED_CACHE_NAME).key(((Object)key).toString(), floatContentType).accept(MediaType.APPLICATION_PROTOSTREAM).read();
        ArrayAsserts.assertArrayEquals((byte[])((byte[])bytesFromRest), (byte[])valueMarshalled);
        Object stringFromRest = new RestRequest().cache(MARSHALLED_CACHE_NAME).key(((Object)key).toString(), floatContentType).accept(MediaType.TEXT_PLAIN).read();
        ArrayAsserts.assertArrayEquals((byte[])"32.4".getBytes(), (byte[])((byte[])stringFromRest));
        Float otherKey = Float.valueOf(2.2f);
        Double otherValue = 123.0;
        new RestRequest().cache(MARSHALLED_CACHE_NAME).key(((Object)otherKey).toString(), floatContentType).value((Object)((Object)otherValue).toString(), doubleContentType).write();
        Assert.assertEquals((Object)this.defaultMarshalledRemoteCache.get((Object)otherKey), (Object)otherValue);
    }

    @Test
    public void testStringKeysAndStringValues() {
        this.stringRemoteCache.put((Object)"key", (Object)"Hello World");
        Assert.assertEquals((String)((String)this.stringRemoteCache.get((Object)"key")), (String)"Hello World");
        Object bytesFromRest = new RestRequest().cache(STRING_CACHE_NAME).key("key").accept(MediaType.TEXT_PLAIN).read();
        Assert.assertEquals((String)this.asString(bytesFromRest), (String)"Hello World");
        new RestRequest().cache(STRING_CACHE_NAME).key("key2").value("Testing").write();
        Assert.assertEquals((String)((String)this.stringRemoteCache.get((Object)"key2")), (String)"Testing");
        Object jsonString = this.stringRemoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new UTF8StringMarshaller()).build()).get((Object)"key");
        Assert.assertEquals((Object)"\"Hello World\"", (Object)jsonString);
    }

    @Test
    public void testByteArrayKeysAndValuesWithMarshaller() throws Exception {
        byte[] key = new byte[]{116, 24};
        byte[] value = new byte[]{16, 32};
        this.defaultMarshalledRemoteCache.put((Object)key, (Object)value);
        ArrayAsserts.assertArrayEquals((byte[])((byte[])this.defaultMarshalledRemoteCache.get((Object)key)), (byte[])value);
        Object bytesFromRest = new RestRequest().cache(MARSHALLED_CACHE_NAME).key("0x7418", "application/octet-stream").accept(MediaType.APPLICATION_OCTET_STREAM).read();
        Assert.assertEquals((Object)bytesFromRest, (Object)value);
        Object marshalledContent = new RestRequest().cache(MARSHALLED_CACHE_NAME).key("0x7418", "application/octet-stream").accept(MediaType.APPLICATION_PROTOSTREAM).read();
        ArrayAsserts.assertArrayEquals((byte[])((byte[])marshalledContent), (byte[])new ProtoStreamMarshaller().objectToByteBuffer((Object)value));
        byte[] newKey = new byte[]{35};
        new RestRequest().cache(MARSHALLED_CACHE_NAME).key("0x23", "application/octet-stream").value(value).write();
        Assert.assertEquals((Object)this.defaultMarshalledRemoteCache.get((Object)newKey), (Object)value);
    }

    @Test
    public void testByteArrayKeysAndByteArrayValues() {
        byte[] key = new byte[]{19, 38};
        byte[] value = new byte[]{10, 20};
        this.defaultRemoteCache.put((Object)key, (Object)value);
        ArrayAsserts.assertArrayEquals((byte[])((byte[])this.defaultRemoteCache.get((Object)key)), (byte[])value);
        Object bytesFromRest = new RestRequest().cache(DEFAULT_CACHE_NAME).key("0x1326", MediaType.APPLICATION_OCTET_STREAM.withParameter("encoding", "hex").toString()).accept(MediaType.APPLICATION_OCTET_STREAM).read();
        Assert.assertEquals((Object)bytesFromRest, (Object)value);
        byte[] newKey = new byte[]{0, 0, 0, 1};
        new RestRequest().cache(DEFAULT_CACHE_NAME).key("0x00000001", MediaType.APPLICATION_OCTET_STREAM.withParameter("encoding", "hex").toString()).value(value).write();
        Assert.assertEquals((byte[])((byte[])this.defaultRemoteCache.get((Object)newKey)), (byte[])value);
    }

    @Test
    public void testCustomKeysAndByteValues() throws Exception {
        CustomKey objectKey = new CustomKey("a", 1.0, Float.valueOf(1.0f), true);
        ProtoStreamMarshaller marshaller = new ProtoStreamMarshaller();
        marshaller.register((SerializationContextInitializer)EndpointITSCI.INSTANCE);
        byte[] key = marshaller.objectToByteBuffer((Object)objectKey);
        byte[] value = new byte[]{12};
        this.defaultRemoteCache.put((Object)key, (Object)value);
        Assert.assertEquals((byte[])value, (byte[])((byte[])this.defaultRemoteCache.get((Object)key)));
        String restKey = StandardConversions.bytesToHex((byte[])key);
        Object bytesFromRest = new RestRequest().cache(DEFAULT_CACHE_NAME).key(restKey, "application/octet-stream").accept(MediaType.APPLICATION_OCTET_STREAM).read();
        ArrayAsserts.assertArrayEquals((byte[])((byte[])bytesFromRest), (byte[])value);
    }

    @Test
    public void testCacheLifecycle() {
        this.stringRemoteCache.put((Object)"key", (Object)"Hello World");
        Assert.assertEquals((String)((String)this.stringRemoteCache.get((Object)"key")), (String)"Hello World");
        RestRequest restRequest = new RestRequest().cache(STRING_CACHE_NAME).key("key").accept(MediaType.TEXT_PLAIN);
        Assert.assertEquals((String)restRequest.executeGet().getBody(), (String)"Hello World");
        RemoteCacheManagerAdmin admin = (RemoteCacheManagerAdmin)this.stringRemoteCache.getRemoteCacheManager().administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE});
        admin.removeCache(this.stringRemoteCache.getName());
        this.assertClientError(() -> this.stringRemoteCache.get((Object)"key"), "CacheNotFoundException");
        Assert.assertEquals((int)restRequest.executeGet().getStatus(), (int)404);
        RemoteCache recreated = admin.getOrCreateCache(this.stringRemoteCache.getName(), (BasicConfiguration)new org.infinispan.configuration.cache.ConfigurationBuilder().encoding().key().mediaType("text/plain").encoding().value().mediaType("text/plain").build());
        recreated.put((Object)"key", (Object)"Hello World");
        Assert.assertEquals((String)((String)recreated.get((Object)"key")), (String)"Hello World");
        Assert.assertEquals((String)restRequest.executeGet().getBody(), (String)"Hello World");
    }

    private void assertClientError(Runnable runnable, String messagePart) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            String message = t.getMessage();
            AssertJUnit.assertTrue((message != null && message.contains(messagePart) ? 1 : 0) != 0);
        }
    }

    private String asString(Object content) {
        if (content instanceof byte[]) {
            return new String((byte[])content, StandardCharsets.UTF_8);
        }
        return content.toString();
    }

    @AfterClass
    protected void teardown() {
        this.defaultRemoteCache.getRemoteCacheManager().stop();
        this.defaultMarshalledRemoteCache.getRemoteCacheManager().stop();
        this.stringRemoteCache.getRemoteCacheManager().stop();
        if (this.restServer != null) {
            try {
                this.restClient.close();
                this.restServer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
        this.cacheManager = null;
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotRodServer});
        this.hotRodServer = null;
    }

    private class RestRequest {
        private String cacheName;
        private Object key;
        private Object value;
        private String keyContentType;
        private MediaType accept;
        private String contentType;
        private RestCacheClient restCacheClient;

        private RestRequest() {
        }

        public RestRequest cache(String cacheName) {
            this.cacheName = cacheName;
            this.restCacheClient = EndpointInteroperabilityTest.this.restClient.cache(cacheName);
            return this;
        }

        public RestRequest key(Object key) {
            this.key = key;
            return this;
        }

        public RestRequest key(Object key, String keyContentType) {
            this.key = key;
            this.keyContentType = keyContentType;
            return this;
        }

        public RestRequest value(Object value, String contentType) {
            this.value = value;
            this.contentType = contentType;
            return this;
        }

        public RestRequest value(Object value, MediaType contentType) {
            this.value = value;
            this.contentType = contentType.toString();
            return this;
        }

        public RestRequest value(Object value) {
            this.value = value;
            return this;
        }

        RestRequest accept(MediaType valueContentType) {
            this.accept = valueContentType;
            return this;
        }

        void write() {
            RestEntity restEntity;
            if (this.value instanceof byte[]) {
                MediaType contentType = this.contentType == null ? MediaType.APPLICATION_OCTET_STREAM : MediaType.fromString((String)this.contentType);
                restEntity = RestEntity.create((MediaType)contentType, (byte[])((byte[])this.value));
            } else {
                String payload = this.value.toString();
                MediaType contentType = this.contentType == null ? MediaType.TEXT_PLAIN : MediaType.fromString((String)this.contentType);
                restEntity = RestEntity.create((MediaType)contentType, (String)payload);
            }
            RestResponse response = this.keyContentType != null ? (RestResponse)CompletionStages.join((CompletionStage)this.restCacheClient.put(this.key.toString(), this.keyContentType, restEntity)) : (RestResponse)CompletionStages.join((CompletionStage)this.restCacheClient.put(this.key.toString(), restEntity));
            Assert.assertEquals((int)204, (int)response.getStatus());
        }

        RestResponse executeGet() {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (this.accept != null) {
                headers.put(RequestHeader.ACCEPT_HEADER.getValue(), this.accept.toString());
            }
            if (this.keyContentType != null) {
                headers.put(RequestHeader.KEY_CONTENT_TYPE_HEADER.getValue(), this.keyContentType);
            }
            return (RestResponse)CompletionStages.join((CompletionStage)this.restCacheClient.get(this.key.toString(), headers));
        }

        Object read() {
            RestResponse response = this.executeGet();
            Assert.assertEquals((int)response.getStatus(), (int)200);
            return response.getBodyAsByteArray();
        }
    }
}

