/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener
public class TestCacheListener {
    private static final Log log = LogFactory.getLog(TestCacheListener.class);
    Map<Object, Object> created = new HashMap<Object, Object>();
    Map<Object, Object> removed = new HashMap<Object, Object>();
    Map<Object, Object> modified = new HashMap<Object, Object>();
    Map<Object, Object> visited = new HashMap<Object, Object>();
    int createdCounter = 0;
    int removedCounter = 0;
    int modifiedCounter = 0;
    int visitedCounter = 0;

    @CacheEntryCreated
    public void handleCreated(CacheEntryCreatedEvent e) {
        if (!e.isPre()) {
            log.tracef("Created %s", e.getKey());
            this.created.put(e.getKey(), e.getValue());
            ++this.createdCounter;
        }
    }

    @CacheEntryRemoved
    public void handleRemoved(CacheEntryRemovedEvent e) {
        if (!e.isPre()) {
            log.tracef("Removed %s", e.getKey());
            this.removed.put(e.getKey(), e.getOldValue());
            ++this.removedCounter;
        }
    }

    @CacheEntryModified
    public void handleModified(CacheEntryModifiedEvent e) {
        if (!e.isPre()) {
            log.tracef("Modified %s", e.getKey());
            this.modified.put(e.getKey(), e.getValue());
            ++this.modifiedCounter;
        }
    }

    @CacheEntryVisited
    public void handleVisited(CacheEntryVisitedEvent e) {
        if (!e.isPre()) {
            log.tracef("Visited %s", e.getKey());
            this.visited.put(e.getKey(), e.getValue());
            ++this.visitedCounter;
        }
    }

    void reset() {
        this.created.clear();
        this.removed.clear();
        this.modified.clear();
        this.visited.clear();
        this.createdCounter = 0;
        this.removedCounter = 0;
        this.modifiedCounter = 0;
        this.visitedCounter = 0;
    }
}

