/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import java.util.Arrays;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.endpoints.EndpointsCacheFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.endpoints.DistL1EmbeddedHotRodTest")
public class DistL1EmbeddedHotRodTest
extends AbstractInfinispanTest {
    private static final int NUM_OWNERS = 1;
    private EndpointsCacheFactory<Integer, String> cacheFactory1;
    private EndpointsCacheFactory<Integer, String> cacheFactory2;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory1 = new EndpointsCacheFactory.Builder().withCacheMode(CacheMode.DIST_SYNC).withNumOwners(1).withL1(true).build();
        this.cacheFactory2 = new EndpointsCacheFactory.Builder().withCacheMode(CacheMode.DIST_SYNC).withNumOwners(1).withL1(true).build();
        List<Cache> caches = Arrays.asList(this.cacheFactory1.getEmbeddedCache(), this.cacheFactory2.getEmbeddedCache());
        TestingUtil.blockUntilViewsReceived((int)30000, caches);
        TestingUtil.waitForNoRebalance(caches);
        AssertJUnit.assertTrue((boolean)this.cacheFactory1.getHotRodCache().isEmpty());
        AssertJUnit.assertTrue((boolean)this.cacheFactory2.getHotRodCache().isEmpty());
    }

    @AfterClass
    protected void teardown() {
        EndpointsCacheFactory.killCacheFactories(this.cacheFactory1, this.cacheFactory2);
    }

    public void testEmbeddedPutHotRodGetFromL1() {
        Cache<Integer, String> embedded1 = this.cacheFactory1.getEmbeddedCache();
        Cache<Integer, String> embedded2 = this.cacheFactory2.getEmbeddedCache();
        Integer key = HotRodClientTestingUtil.getSplitIntKeyForServer((HotRodServer)this.cacheFactory1.getHotrodServer(), (HotRodServer)this.cacheFactory2.getHotrodServer(), null);
        embedded1.put((Object)key, (Object)"uno");
        AssertJUnit.assertEquals((String)"uno", (String)((String)this.cacheFactory1.getHotRodCache().get((Object)key)));
        AssertJUnit.assertEquals((String)"uno", (String)((String)this.cacheFactory1.getHotRodCache().get((Object)key)));
    }
}

