/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.it.endpoints.CryptoCurrency;
import org.infinispan.it.endpoints.EndpointITSCI;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.DummyServerManagement;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseJsonTest
extends AbstractInfinispanTest {
    RestServer restServer;
    RestClient restClient;
    private EmbeddedCacheManager cacheManager;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<String, CryptoCurrency> remoteCache;
    private static final String CACHE_NAME = "indexed";
    HotRodServer hotRodServer;
    private RestCacheClient restCacheClient;

    abstract ConfigurationBuilder getIndexCacheConfiguration();

    abstract RemoteCacheManager createRemoteCacheManager() throws Exception;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createServerModeCacheManager((SerializationContextInitializer)EndpointITSCI.INSTANCE, (ConfigurationBuilder)new ConfigurationBuilder());
        this.cacheManager.getClassWhiteList().addRegexps(new String[]{".*"});
        this.cacheManager.defineConfiguration(CACHE_NAME, this.getIndexCacheConfiguration().build());
        RestServerConfigurationBuilder builder = new RestServerConfigurationBuilder();
        int restPort = ServerTestingUtil.findFreePort();
        builder.port(restPort);
        this.restServer = new RestServer();
        this.restServer.setServerManagement((ServerManagement)new DummyServerManagement(), true);
        this.restServer.start((ProtocolServerConfiguration)builder.build(), this.cacheManager);
        this.restClient = RestClient.forConfiguration((RestClientConfiguration)new RestClientConfigurationBuilder().addServer().host(this.restServer.getHost()).port(this.restServer.getPort().intValue()).build());
        this.restCacheClient = this.restClient.cache(CACHE_NAME);
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager);
        this.remoteCacheManager = this.createRemoteCacheManager();
        this.remoteCache = this.remoteCacheManager.getCache(CACHE_NAME);
    }

    protected String getEntityName() {
        return EndpointITSCI.getFQN(CryptoCurrency.class);
    }

    protected String getJsonType() {
        return this.getEntityName();
    }

    private void writeCurrencyViaJson(String key, String description, int rank) {
        Json currency = Json.object();
        currency.set("_type", (Object)this.getJsonType());
        currency.set("description", (Object)description);
        currency.set("rank", (Object)rank);
        RestEntity value = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)currency.toString());
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.restCacheClient.put(key, value));
        Assert.assertEquals((int)response.getStatus(), (int)204);
    }

    private CryptoCurrency readCurrencyViaJson(String key) {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.restCacheClient.get(key, "application/json"));
        String json = response.getBody();
        Json jsonNode = Json.read((String)json);
        Json description = jsonNode.at("description");
        Json rank = jsonNode.at("rank");
        return new CryptoCurrency(description.asString(), rank.asInteger());
    }

    @Test
    public void testRestOnly() {
        this.writeCurrencyViaJson("DASH", "Dash", 7);
        this.writeCurrencyViaJson("IOTA", "Iota", 8);
        this.writeCurrencyViaJson("XMR", "Monero", 9);
        CryptoCurrency xmr = this.readCurrencyViaJson("XMR");
        Assert.assertEquals((Object)xmr.getRank(), (Object)9);
        Assert.assertEquals((String)xmr.getDescription(), (String)"Monero");
    }

    @Test
    public void testHotRodInteroperability() {
        this.remoteCache.clear();
        this.remoteCache.put((Object)"BTC", (Object)new CryptoCurrency("Bitcoin", 1));
        this.remoteCache.put((Object)"ETH", (Object)new CryptoCurrency("Ethereum", 2));
        this.remoteCache.put((Object)"XRP", (Object)new CryptoCurrency("Ripple", 3));
        this.remoteCache.put((Object)"CAT", (Object)new CryptoCurrency("Catcoin", 618));
        Assert.assertEquals((String)((CryptoCurrency)this.remoteCache.get((Object)"CAT")).getDescription(), (String)"Catcoin");
        Assert.assertEquals((int)this.remoteCache.size(), (int)4);
        Query query = Search.getQueryFactory(this.remoteCache).create("FROM " + this.getEntityName() + " c where c.rank < 10");
        List highRankCoins = query.execute().list();
        Assert.assertEquals((int)highRankCoins.size(), (int)3);
        CryptoCurrency btc = this.readCurrencyViaJson("BTC");
        Assert.assertEquals((String)btc.getDescription(), (String)"Bitcoin");
        Assert.assertEquals((Object)btc.getRank(), (Object)1);
        this.writeCurrencyViaJson("LTC", "Litecoin", 4);
        query = Search.getQueryFactory(this.remoteCache).create("FROM " + this.getEntityName() + " c  where c.description = 'Litecoin'");
        CryptoCurrency litecoin = (CryptoCurrency)query.execute().list().iterator().next();
        Assert.assertEquals((String)litecoin.getDescription(), (String)"Litecoin");
        Assert.assertEquals((Object)litecoin.getRank(), (Object)4);
        Object jsonResult = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_JSON).build()).get((Object)"LTC");
        Json jsonNode = Json.read((String)new String((byte[])jsonResult, StandardCharsets.UTF_8));
        Assert.assertEquals((String)jsonNode.at("description").asString(), (String)"Litecoin");
    }

    @AfterClass
    protected void teardown() {
        Util.close((AutoCloseable)this.restClient);
        this.remoteCacheManager.stop();
        if (this.restServer != null) {
            try {
                this.restServer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
        this.cacheManager = null;
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotRodServer});
        this.hotRodServer = null;
    }
}

