/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.stats.CacheStatisticCollector;
import org.infinispan.stats.ExtendedStatisticNotFoundException;
import org.infinispan.stats.LocalTransactionStatistics;
import org.infinispan.stats.RemoteTransactionStatistics;
import org.infinispan.stats.TransactionStatistics;
import org.infinispan.stats.container.ExtendedStatistic;
import org.infinispan.stats.logging.Log;
import org.infinispan.stats.percentiles.PercentileStatistic;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.LogFactory;

public final class CacheStatisticManager {
    private static final Log log = (Log)LogFactory.getLog(CacheStatisticManager.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ConcurrentMap<GlobalTransaction, RemoteTransactionStatistics> remoteTransactionStatistics = CollectionFactory.makeConcurrentMap();
    private final ConcurrentMap<GlobalTransaction, LocalTransactionStatistics> localTransactionStatistics = CollectionFactory.makeConcurrentMap();
    private final CacheStatisticCollector cacheStatisticCollector;
    private final boolean isOptimisticLocking;
    private final TimeService timeService;

    public CacheStatisticManager(Configuration configuration, TimeService timeService) {
        this.timeService = timeService;
        this.isOptimisticLocking = configuration.transaction().lockingMode() == LockingMode.OPTIMISTIC;
        this.cacheStatisticCollector = new CacheStatisticCollector(timeService);
    }

    public final void add(ExtendedStatistic stat, double value, GlobalTransaction globalTransaction, boolean local) {
        TransactionStatistics txs = this.getTransactionStatistic(globalTransaction, local);
        if (txs == null) {
            if (log.isDebugEnabled()) {
                log.debugf("Trying to add %s to %s but no transaction exist. Add to Cache Statistic", value, (Object)stat);
            }
            if (local) {
                this.cacheStatisticCollector.addLocalValue(stat, value);
            } else {
                this.cacheStatisticCollector.addRemoteValue(stat, value);
            }
            return;
        }
        txs.addValue(stat, value);
    }

    public final void increment(ExtendedStatistic stat, GlobalTransaction globalTransaction, boolean local) {
        TransactionStatistics txs = this.getTransactionStatistic(globalTransaction, local);
        if (txs == null) {
            if (log.isDebugEnabled()) {
                log.debugf("Trying to increment %s but no transaction exist. Add to Cache Statistic", (Object)stat);
            }
            if (local) {
                this.cacheStatisticCollector.addLocalValue(stat, 1.0);
            } else {
                this.cacheStatisticCollector.addRemoteValue(stat, 1.0);
            }
            return;
        }
        txs.addValue(stat, 1.0);
    }

    public final void onPrepareCommand(GlobalTransaction globalTransaction, boolean local) {
        TransactionStatistics txs = this.getTransactionStatistic(globalTransaction, local);
        if (txs == null) {
            log.prepareOnUnexistingTransaction(globalTransaction == null ? "null" : globalTransaction.globalId());
            log.error("Trying to invoke onPrepareCommand() but no transaction is associated");
            return;
        }
        txs.onPrepareCommand();
    }

    public final void setTransactionOutcome(boolean commit, GlobalTransaction globalTransaction, boolean local) {
        TransactionStatistics txs = this.getTransactionStatistic(globalTransaction, local);
        if (txs == null) {
            log.outcomeOnUnexistingTransaction(globalTransaction == null ? "null" : globalTransaction.globalId(), commit ? "COMMIT" : "ROLLBACK");
            return;
        }
        txs.setOutcome(commit);
    }

    public final double getAttribute(ExtendedStatistic stat) throws ExtendedStatisticNotFoundException {
        return this.cacheStatisticCollector.getAttribute(stat);
    }

    public final double getPercentile(PercentileStatistic stat, int percentile) throws IllegalArgumentException {
        return this.cacheStatisticCollector.getPercentile(stat, percentile);
    }

    public final void markAsWriteTransaction(GlobalTransaction globalTransaction, boolean local) {
        TransactionStatistics txs = this.getTransactionStatistic(globalTransaction, local);
        if (txs == null) {
            log.markUnexistingTransactionAsWriteTransaction(globalTransaction == null ? "null" : globalTransaction.globalId());
            return;
        }
        txs.markAsUpdateTransaction();
    }

    public final void beginTransaction(GlobalTransaction globalTransaction, boolean local) {
        if (local) {
            TransactionStatistics lts = this.createTransactionStatisticIfAbsent(globalTransaction, true);
            if (trace) {
                log.tracef("Local transaction statistic is already initialized: %s", lts);
            }
        } else {
            TransactionStatistics rts = this.createTransactionStatisticIfAbsent(globalTransaction, false);
            if (trace) {
                log.tracef("Using the remote transaction statistic %s for transaction %s", rts, globalTransaction);
            }
        }
    }

    public final void terminateTransaction(GlobalTransaction globalTransaction, boolean local, boolean remote) {
        TransactionStatistics txs = null;
        if (local) {
            txs = this.removeTransactionStatistic(globalTransaction, true);
        }
        if (txs != null) {
            txs.terminateTransaction();
            this.cacheStatisticCollector.merge(txs);
            txs = null;
        }
        if (remote) {
            txs = this.removeTransactionStatistic(globalTransaction, false);
        }
        if (txs != null) {
            txs.terminateTransaction();
            this.cacheStatisticCollector.merge(txs);
        }
    }

    public final void reset() {
        this.cacheStatisticCollector.reset();
    }

    public final boolean hasPendingTransactions() {
        log.debugf("Checking for pending transactions. local=%s, remote=%s", this.localTransactionStatistics.keySet(), this.remoteTransactionStatistics.keySet());
        return !this.localTransactionStatistics.isEmpty() || !this.remoteTransactionStatistics.isEmpty();
    }

    public final String dumpCacheStatistics() {
        StringBuilder builder = new StringBuilder();
        this.cacheStatisticCollector.dumpTo(builder);
        return builder.toString();
    }

    public final void dumpCacheStatisticsTo(PrintStream stream) {
        this.cacheStatisticCollector.dumpTo(new PrintWriter(stream));
    }

    private TransactionStatistics getTransactionStatistic(GlobalTransaction globalTransaction, boolean local) {
        if (globalTransaction != null) {
            return local ? (TransactionStatistics)this.localTransactionStatistics.get(globalTransaction) : (TransactionStatistics)this.remoteTransactionStatistics.get(globalTransaction);
        }
        return null;
    }

    private TransactionStatistics removeTransactionStatistic(GlobalTransaction globalTransaction, boolean local) {
        if (globalTransaction != null) {
            if (trace) {
                log.tracef("Removing %s statistic for %s", local ? "local" : "remote", globalTransaction.globalId());
            }
            return local ? (TransactionStatistics)this.localTransactionStatistics.remove(globalTransaction) : (TransactionStatistics)this.remoteTransactionStatistics.remove(globalTransaction);
        }
        return null;
    }

    private TransactionStatistics createTransactionStatisticIfAbsent(GlobalTransaction globalTransaction, boolean local) {
        RemoteTransactionStatistics rts;
        TransactionStatistics existing;
        TransactionStatistics ts;
        if (globalTransaction == null) {
            throw new NullPointerException("Global Transaction cannot be null");
        }
        TransactionStatistics transactionStatistics = ts = local ? (TransactionStatistics)this.localTransactionStatistics.get(globalTransaction) : (TransactionStatistics)this.remoteTransactionStatistics.get(globalTransaction);
        if (ts != null) {
            return ts;
        }
        if (local) {
            LocalTransactionStatistics lts;
            TransactionStatistics existing2;
            if (trace) {
                log.tracef("Creating local statistic for %s", globalTransaction.globalId());
            }
            return (existing2 = (TransactionStatistics)this.localTransactionStatistics.putIfAbsent(globalTransaction, lts = new LocalTransactionStatistics(this.isOptimisticLocking, this.timeService))) == null ? lts : existing2;
        }
        if (trace) {
            log.tracef("Creating remote statistic for %s", globalTransaction.globalId());
        }
        return (existing = (TransactionStatistics)this.remoteTransactionStatistics.putIfAbsent(globalTransaction, rts = new RemoteTransactionStatistics(this.timeService))) == null ? rts : existing;
    }
}

