package org.infinispan.stats.wrappers;

import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Generated;

import org.infinispan.factories.impl.ComponentAccessor;
import org.infinispan.factories.components.JmxAttributeMetadata;
import org.infinispan.factories.components.JmxOperationMetadata;
import org.infinispan.factories.components.JmxOperationParameter;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.impl.WireContext;
import org.infinispan.manager.ModuleRepository;

@Generated(value = "org.infinispan.component.processor.Generator", date = "2019-07-12T17:22:14.357529Z")
public class ExtendedStatisticsPackageImpl {
   public static void registerMetadata(ModuleRepository.Builder builder) {
//start org.infinispan.stats.wrappers.ExtendedStatisticInterceptor
      builder.registerComponentAccessor("org.infinispan.stats.wrappers.ExtendedStatisticInterceptor",
         Collections.emptyList(),
         new ComponentAccessor<ExtendedStatisticInterceptor>("org.infinispan.stats.wrappers.ExtendedStatisticInterceptor",
            1, false, "org.infinispan.interceptors.BaseCustomAsyncInterceptor",
            Arrays.asList("org.infinispan.factories.impl.BasicComponentRegistry", "org.infinispan.commons.time.TimeService", "org.infinispan.transaction.impl.TransactionTable", "org.infinispan.distribution.DistributionManager")) {
         protected void wire(ExtendedStatisticInterceptor instance, WireContext context, boolean start) {
            instance.componentRegistry = context.get("org.infinispan.factories.impl.BasicComponentRegistry", org.infinispan.factories.impl.BasicComponentRegistry.class, start);
            instance.timeService = context.get("org.infinispan.commons.time.TimeService", org.infinispan.commons.time.TimeService.class, start);
            instance.transactionTable = context.get("org.infinispan.transaction.impl.TransactionTable", org.infinispan.transaction.impl.TransactionTable.class, start);
            instance.distributionManager = context.get("org.infinispan.distribution.DistributionManager", org.infinispan.distribution.DistributionManager.class, start);
         }

      });

      builder.registerMBeanMetadata("org.infinispan.stats.wrappers.ExtendedStatisticInterceptor",
         MBeanMetadata.of("ExtendedStatistics", "Component that manages and exposes extended statistics relevant to transactions.", null,
            new JmxAttributeMetadata("avgPrepareRtt", "Average Prepare Round-Trip Time duration (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgCommitRtt", "Average Commit Round-Trip Time duration (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgRemoteGetRtt", "Average Remote Get Round-Trip Time duration (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgRollbackRtt", "Average Rollback Round-Trip Time duration (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgCompleteNotificationAsync", "Average asynchronous Complete Notification duration (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgNumNodesCommit", "Average number of nodes in Commit destination set", false, true, "double", false),
            new JmxAttributeMetadata("avgNumNodesCompleteNotification", "Average number of nodes in Complete Notification destination set", false, true, "double", false),
            new JmxAttributeMetadata("avgNumNodesRemoteGet", "Average number of nodes in Remote Get destination set", false, true, "double", false),
            new JmxAttributeMetadata("avgNumNodesPrepare", "Average number of nodes in Prepare destination set", false, true, "double", false),
            new JmxAttributeMetadata("avgNumNodesRollback", "Average number of nodes in Rollback destination set", false, true, "double", false),
            new JmxAttributeMetadata("localExecutionTimeWithoutLock", "Local execution time of a transaction without the time waiting for lock acquisition", false, true, "double", false),
            new JmxAttributeMetadata("avgLockHoldTime", "Average lock holding time (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgLocalLockHoldTime", "Average lock local holding time (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgRemoteLockHoldTime", "Average lock remote holding time (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgCommitTime", "Average local commit duration time (2nd phase only) (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgRollbackTime", "Average local rollback duration time (2nd phase only) (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgPrepareCommandSize", "Average prepare command size (in bytes)", false, true, "double", false),
            new JmxAttributeMetadata("avgCommitCommandSize", "Average commit command size (in bytes)", false, true, "double", false),
            new JmxAttributeMetadata("avgClusteredGetCommandSize", "Average clustered get command size (in bytes)", false, true, "double", false),
            new JmxAttributeMetadata("avgLockWaitingTime", "Average time waiting for the lock acquisition (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgTxArrivalRate", "Average transaction arrival rate, originated locally and remotely (in transaction per second)", false, true, "double", false),
            new JmxAttributeMetadata("percentageWriteTransactions", "Percentage of Write transaction executed locally (committed and aborted)", false, true, "double", false),
            new JmxAttributeMetadata("percentageSuccessWriteTransactions", "Percentage of Write transaction executed in all successfully executed transactions (local transaction only)", false, true, "double", false),
            new JmxAttributeMetadata("numAbortedTxDueTimeout", "The number of aborted transactions due to timeout in lock acquisition", false, true, "double", false),
            new JmxAttributeMetadata("numAbortedTxDueDeadlock", "The number of aborted transactions due to deadlock", false, true, "double", false),
            new JmxAttributeMetadata("avgReadOnlyTxDuration", "Average successful read-only transaction duration (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgWriteTxDuration", "Average successful write transaction duration (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgAbortedWriteTxDuration", "Average aborted write transaction duration (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgNumOfLockLocalTx", "Average number of locks per write local transaction", false, true, "double", false),
            new JmxAttributeMetadata("avgNumOfLockRemoteTx", "Average number of locks per write remote transaction", false, true, "double", false),
            new JmxAttributeMetadata("avgNumOfLockSuccessLocalTx", "Average number of locks per successfully write local transaction", false, true, "double", false),
            new JmxAttributeMetadata("avgLocalPrepareTime", "Average time it takes to execute the prepare command locally (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgRemotePrepareTime", "Average time it takes to execute the prepare command remotely (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgLocalCommitTime", "Average time it takes to execute the commit command locally (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgRemoteCommitTime", "Average time it takes to execute the commit command remotely (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgLocalRollbackTime", "Average time it takes to execute the rollback command locally (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("avgRemoteRollbackTime", "Average time it takes to execute the rollback command remotely (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("abortRate", "Abort Rate", false, true, "double", false),
            new JmxAttributeMetadata("throughput", "Throughput (in transactions per second)", false, true, "double", false),
            new JmxAttributeMetadata("avgGetsPerROTransaction", "Average number of get operations per (local) read-only transaction", false, true, "double", false),
            new JmxAttributeMetadata("avgGetsPerWrTransaction", "Average number of get operations per (local) read-write transaction", false, true, "double", false),
            new JmxAttributeMetadata("avgRemoteGetsPerWrTransaction", "Average number of remote get operations per (local) read-write transaction", false, true, "double", false),
            new JmxAttributeMetadata("avgRemoteGetsPerROTransaction", "Average number of remote get operations per (local) read-only transaction", false, true, "double", false),
            new JmxAttributeMetadata("remoteGetExecutionTime", "Average cost of a remote get", false, true, "double", false),
            new JmxAttributeMetadata("avgPutsPerWrTransaction", "Average number of put operations per (local) read-write transaction", false, true, "double", false),
            new JmxAttributeMetadata("avgRemotePutsPerWrTransaction", "Average number of remote put operations per (local) read-write transaction", false, true, "double", false),
            new JmxAttributeMetadata("remotePutExecutionTime", "Average cost of a remote put", false, true, "double", false),
            new JmxAttributeMetadata("numberOfGets", "Number of gets performed since last reset", false, true, "double", false),
            new JmxAttributeMetadata("numberOfRemoteGets", "Number of remote gets performed since last reset", false, true, "double", false),
            new JmxAttributeMetadata("numberOfPuts", "Number of puts performed since last reset", false, true, "double", false),
            new JmxAttributeMetadata("numberOfRemotePuts", "Number of remote puts performed since last reset", false, true, "double", false),
            new JmxAttributeMetadata("numberOfCommits", "Number of committed transactions since last reset", false, true, "double", false),
            new JmxAttributeMetadata("numberOfLocalCommits", "Number of local committed transactions since last reset", false, true, "double", false),
            new JmxAttributeMetadata("writeSkewProbability", "Write skew probability", false, true, "double", false),
            new JmxAttributeMetadata("avgLocalGetTime", "Average Local processing Get time (in microseconds)", false, true, "double", false),
            new JmxAttributeMetadata("numNodes", "Number of nodes in the cluster", false, true, "double", false),
            new JmxAttributeMetadata("replicationDegree", "Number of replicas for each key", false, true, "double", false),
            new JmxAttributeMetadata("localActiveTransactions", "Number of concurrent transactions executing on the current node", false, true, "double", false),
            new JmxAttributeMetadata("avgResponseTime", "Average Response Time", false, true, "double", false),
            new JmxAttributeMetadata("availableExtendedStatistics", "Returns all the available statistics", false, true, "java.lang.String", false),
            new JmxOperationMetadata("getPercentileLocalReadOnlyTransaction", "", "K-th percentile of local read-only transactions execution time", "double",
               new JmxOperationParameter("percentile", "", "int")
            ),
            new JmxOperationMetadata("getPercentileRemoteReadOnlyTransaction", "", "K-th percentile of remote read-only transactions execution time", "double",
               new JmxOperationParameter("percentile", "", "int")
            ),
            new JmxOperationMetadata("getPercentileLocalRWriteTransaction", "", "K-th percentile of local write transactions execution time", "double",
               new JmxOperationParameter("percentile", "", "int")
            ),
            new JmxOperationMetadata("getPercentileRemoteWriteTransaction", "", "K-th percentile of remote write transactions execution time", "double",
               new JmxOperationParameter("percentile", "", "int")
            ),
            new JmxOperationMetadata("resetStatistics", "", "Reset all the statistics collected", "void"
            ),
            new JmxOperationMetadata("getStatisticValue", "", "Returns the raw value for the statistic", "double",
               new JmxOperationParameter("statName", "Statistic name", "java.lang.String")
            ),
            new JmxOperationMetadata("dumpStatistics", "", "Dumps the current cache statistic values", "java.lang.String"
            ),
            new JmxOperationMetadata("dumpStatisticsToSystemOut", "", "Dumps the current cache statistic values to System.out", "void"
            ),
            new JmxOperationMetadata("dumpStatisticToFile", "", "Dumps the current cache statistic values to a file", "void",
               new JmxOperationParameter("filePath", "The file path", "java.lang.String")
            )
      ));

//end
   }
}
