package org.infinispan.extendedstats.topK;

import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Generated;

import org.infinispan.factories.impl.ComponentAccessor;
import org.infinispan.factories.components.JmxAttributeMetadata;
import org.infinispan.factories.components.JmxOperationMetadata;
import org.infinispan.factories.components.JmxOperationParameter;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.impl.WireContext;
import org.infinispan.manager.ModuleRepository;

@Generated(value = "org.infinispan.component.processor.Generator", date = "2019-09-15T07:38:19.231295Z")
public class ExtendedStatisticsPackageImpl {
   public static void registerMetadata(ModuleRepository.Builder builder) {
//start org.infinispan.extendedstats.topK.CacheUsageInterceptor
      builder.registerComponentAccessor("org.infinispan.extendedstats.topK.CacheUsageInterceptor",
         Collections.emptyList(),
         new ComponentAccessor<CacheUsageInterceptor>("org.infinispan.extendedstats.topK.CacheUsageInterceptor",
            1, false, "org.infinispan.interceptors.BaseCustomAsyncInterceptor",
            Arrays.asList("org.infinispan.factories.impl.BasicComponentRegistry", "org.infinispan.distribution.DistributionManager")) {
         protected void wire(CacheUsageInterceptor instance, WireContext context, boolean start) {
            instance.componentRegistry = context.get("org.infinispan.factories.impl.BasicComponentRegistry", org.infinispan.factories.impl.BasicComponentRegistry.class, start);
            instance.distributionManager = context.get("org.infinispan.distribution.DistributionManager", org.infinispan.distribution.DistributionManager.class, start);
         }

      });

      builder.registerMBeanMetadata("org.infinispan.extendedstats.topK.CacheUsageInterceptor",
         MBeanMetadata.of("CacheUsageStatistics", "Keeps tracks of the accessed keys", null,
            new JmxAttributeMetadata("capacity", "Shows the current capacity for top-K values", false, true, "int", false),
            new JmxAttributeMetadata("remoteTopGets", "Show the top 10 keys most read remotely by this instance", false, true, "java.util.Map<java.lang.String,java.lang.Long>", false),
            new JmxAttributeMetadata("localTopGets", "Show the top 10 keys most read locally by this instance", false, true, "java.util.Map<java.lang.String,java.lang.Long>", false),
            new JmxAttributeMetadata("remoteTopPuts", "Show the top 10 keys most write remotely by this instance", false, true, "java.util.Map<java.lang.String,java.lang.Long>", false),
            new JmxAttributeMetadata("localTopPuts", "Show the top 10 keys most write locally by this instance", false, true, "java.util.Map<java.lang.String,java.lang.Long>", false),
            new JmxAttributeMetadata("topLockedKeys", "Show the top 10 keys most locked", false, true, "java.util.Map<java.lang.String,java.lang.Long>", false),
            new JmxAttributeMetadata("topContendedKeys", "Show the top 10 keys most contended", false, true, "java.util.Map<java.lang.String,java.lang.Long>", false),
            new JmxAttributeMetadata("topLockFailedKeys", "Show the top 10 keys whose lock acquisition failed by timeout", false, true, "java.util.Map<java.lang.String,java.lang.Long>", false),
            new JmxAttributeMetadata("topWriteSkewFailedKeys", "Show the top 10 keys whose write skew check was failed", false, true, "java.util.Map<java.lang.String,java.lang.Long>", false),
            new JmxOperationMetadata("resetStatistics", "", "Resets statistics gathered by this component", "void"
            ),
            new JmxOperationMetadata("setTopKValue", "", "Set K for the top-K values", "void",
               new JmxOperationParameter("n", "the n-th top key to collect", "int")
            ),
            new JmxOperationMetadata("getNRemoteTopGets", "", "Show the top n keys most read remotely by this instance", "java.util.Map<java.lang.String,java.lang.Long>",
               new JmxOperationParameter("n", "the n-th top key to return", "int")
            ),
            new JmxOperationMetadata("getNLocalTopGets", "", "Show the top n keys most read locally by this instance", "java.util.Map<java.lang.String,java.lang.Long>",
               new JmxOperationParameter("n", "the n-th top key to return", "int")
            ),
            new JmxOperationMetadata("getNRemoteTopPuts", "", "Show the top n keys most write remotely by this instance", "java.util.Map<java.lang.String,java.lang.Long>",
               new JmxOperationParameter("n", "the n-th top key to return", "int")
            ),
            new JmxOperationMetadata("getNLocalTopPuts", "", "Show the top n keys most write locally by this instance", "java.util.Map<java.lang.String,java.lang.Long>",
               new JmxOperationParameter("n", "the n-th top key to return", "int")
            ),
            new JmxOperationMetadata("getNTopLockedKeys", "", "Show the top n keys most locked", "java.util.Map<java.lang.String,java.lang.Long>",
               new JmxOperationParameter("n", "the n-th top key to return", "int")
            ),
            new JmxOperationMetadata("getNTopContendedKeys", "", "Show the top n keys most contended", "java.util.Map<java.lang.String,java.lang.Long>",
               new JmxOperationParameter("n", "the n-th top key to return", "int")
            ),
            new JmxOperationMetadata("getNTopLockFailedKeys", "", "Show the top n keys whose lock acquisition failed ", "java.util.Map<java.lang.String,java.lang.Long>",
               new JmxOperationParameter("n", "the n-th top key to return", "int")
            ),
            new JmxOperationMetadata("getNTopWriteSkewFailedKeys", "", "Show the top n keys whose write skew check was failed", "java.util.Map<java.lang.String,java.lang.Long>",
               new JmxOperationParameter("n", "the n-th top key to return", "int")
            ),
            new JmxOperationMetadata("setStatisticsEnabled", "", "Show the top n keys whose write skew check was failed", "void",
               new JmxOperationParameter("enabled", "true to enable the top-k collection", "boolean")
            )
      ));

//end
   }
}
