/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.extendedstats;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.MagicKey;
import org.infinispan.extendedstats.CacheStatisticCollector;
import org.infinispan.extendedstats.CacheStatisticManager;
import org.infinispan.extendedstats.container.ConcurrentGlobalContainer;
import org.infinispan.extendedstats.container.ExtendedStatistic;
import org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor;
import org.infinispan.extendedstats.wrappers.ExtendedStatisticLockManager;
import org.infinispan.extendedstats.wrappers.ExtendedStatisticRpcManager;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.impl.TxInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.TransactionProtocol;
import org.infinispan.util.EmbeddedTimeService;
import org.infinispan.util.TransactionTrackInterceptor;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseTxClusterExtendedStatisticLogicTest
extends MultipleCacheManagersTest {
    private static final int NUM_NODES = 2;
    private static final int TX_TIMEOUT = 60;
    private static final TimeService TEST_TIME_SERVICE = new EmbeddedTimeService(){

        public long time() {
            return 0L;
        }

        public long timeDuration(long startTimeNanos, TimeUnit outputTimeUnit) {
            Assert.assertEquals((long)startTimeNanos, (long)0L, (String)"Start timestamp must be zero!");
            Assert.assertEquals((Object)((Object)outputTimeUnit), (Object)((Object)TimeUnit.NANOSECONDS), (String)"TimeUnit is different from expected");
            return 1L;
        }

        public long timeDuration(long startTimeNanos, long endTimeNanos, TimeUnit outputTimeUnit) {
            Assert.assertEquals((long)startTimeNanos, (long)0L, (String)"Start timestamp must be zero!");
            Assert.assertEquals((long)endTimeNanos, (long)0L, (String)"End timestamp must be zero!");
            Assert.assertEquals((Object)((Object)outputTimeUnit), (Object)((Object)TimeUnit.NANOSECONDS), (String)"TimeUnit is different from expected");
            return 1L;
        }
    };
    private static final double MICROSECONDS = CacheStatisticCollector.convertNanosToMicro((double)TEST_TIME_SERVICE.timeDuration(0L, TimeUnit.NANOSECONDS));
    private static final double SECONDS = CacheStatisticCollector.convertNanosToSeconds((double)TEST_TIME_SERVICE.timeDuration(0L, TimeUnit.NANOSECONDS));
    private final TransactionTrackInterceptor[] transactionTrackInterceptors = new TransactionTrackInterceptor[2];
    private final ExtendedStatisticInterceptor[] extendedStatisticInterceptors = new ExtendedStatisticInterceptor[2];
    private final LockManager[] lockManagers = new LockManager[2];
    private final boolean replicated;
    private final boolean totalOrder;
    private final CacheMode cacheMode;
    private final List<Object> keys = new ArrayList<Object>(128);

    protected BaseTxClusterExtendedStatisticLogicTest(CacheMode cacheMode, boolean totalOrder) {
        this.replicated = cacheMode.isReplicated();
        this.cacheMode = cacheMode;
        this.totalOrder = totalOrder;
    }

    public final void testPutTxAndReadOnlyTx() throws Exception {
        this.testStats(WriteOperation.PUT, 2, 7, 3, 4, 5, false, true);
    }

    public final void testPutTxAndReadOnlyTxRollback() throws Exception {
        this.testStats(WriteOperation.PUT, 3, 6, 2, 5, 4, true, true);
    }

    public final void testPutTxAndReadOnlyTxNonCoordinator() throws Exception {
        this.testStats(WriteOperation.PUT, 4, 5, 4, 6, 3, false, false);
    }

    public final void testPutTxAndReadOnlyTxRollbackNonCoordinator() throws Exception {
        this.testStats(WriteOperation.PUT, 5, 4, 5, 7, 2, true, false);
    }

    public final void testConditionalPutTxAndReadOnlyTx() throws Exception {
        this.testStats(WriteOperation.PUT_IF, 2, 7, 3, 4, 5, false, true);
    }

    public final void testConditionalPutTxAndReadOnlyTxRollback() throws Exception {
        this.testStats(WriteOperation.PUT_IF, 3, 6, 2, 5, 4, true, true);
    }

    public final void testConditionalPutTxAndReadOnlyTxNonCoordinator() throws Exception {
        this.testStats(WriteOperation.PUT_IF, 4, 5, 4, 6, 3, false, false);
    }

    public final void testConditionalPutTxAndReadOnlyTxRollbackNonCoordinator() throws Exception {
        this.testStats(WriteOperation.PUT_IF, 5, 4, 5, 7, 2, true, false);
    }

    public final void testReplaceTxAndReadOnlyTx() throws Exception {
        this.testStats(WriteOperation.REPLACE, 2, 7, 3, 4, 5, false, true);
    }

    public final void testReplaceTxAndReadOnlyTxRollback() throws Exception {
        this.testStats(WriteOperation.REPLACE, 3, 6, 2, 5, 4, true, true);
    }

    public final void testReplaceTxAndReadOnlyTxNonCoordinator() throws Exception {
        this.testStats(WriteOperation.REPLACE, 4, 5, 4, 6, 3, false, false);
    }

    public final void testReplaceTxAndReadOnlyTxRollbackNonCoordinator() throws Exception {
        this.testStats(WriteOperation.REPLACE, 5, 4, 5, 7, 2, true, false);
    }

    public final void testConditionalReplaceTxAndReadOnlyTx() throws Exception {
        this.testStats(WriteOperation.REPLACE_IF, 2, 7, 3, 4, 5, false, true);
    }

    public final void testConditionalReplaceTxAndReadOnlyTxRollback() throws Exception {
        this.testStats(WriteOperation.REPLACE_IF, 3, 6, 2, 5, 4, true, true);
    }

    public final void testConditionalReplaceTxAndReadOnlyTxNonCoordinator() throws Exception {
        this.testStats(WriteOperation.REPLACE_IF, 4, 5, 4, 6, 3, false, false);
    }

    public final void testConditionalReplaceTxAndReadOnlyTxRollbackNonCoordinator() throws Exception {
        this.testStats(WriteOperation.REPLACE_IF, 5, 4, 5, 7, 2, true, false);
    }

    public final void testRemoveTxAndReadOnlyTx() throws Exception {
        this.testStats(WriteOperation.REMOVE, 2, 7, 3, 4, 5, false, true);
    }

    public final void testRemoveTxAndReadOnlyTxRollback() throws Exception {
        this.testStats(WriteOperation.REMOVE, 3, 6, 2, 5, 4, true, true);
    }

    public final void testRemoveTxAndReadOnlyTxNonCoordinator() throws Exception {
        this.testStats(WriteOperation.REMOVE, 4, 5, 4, 6, 3, false, false);
    }

    public final void testRemoveTxAndReadOnlyTxRollbackNonCoordinator() throws Exception {
        this.testStats(WriteOperation.REMOVE, 5, 4, 5, 7, 2, true, false);
    }

    public final void testConditionalRemoveTxAndReadOnlyTx() throws Exception {
        this.testStats(WriteOperation.REMOVE_IF, 2, 7, 3, 4, 5, false, true);
    }

    public final void testConditionalRemoveTxAndReadOnlyTxRollback() throws Exception {
        this.testStats(WriteOperation.REMOVE_IF, 3, 6, 2, 5, 4, true, true);
    }

    public final void testConditionalRemoveTxAndReadOnlyTxNonCoordinator() throws Exception {
        this.testStats(WriteOperation.REMOVE_IF, 4, 5, 4, 6, 3, false, false);
    }

    public final void testConditionalRemoveTxAndReadOnlyTxRollbackNonCoordinator() throws Exception {
        this.testStats(WriteOperation.REMOVE_IF, 5, 4, 5, 7, 2, true, false);
    }

    protected void createCacheManagers() throws Throwable {
        int i;
        for (i = 0; i < 2; ++i) {
            ConfigurationBuilder builder = BaseTxClusterExtendedStatisticLogicTest.getDefaultClusteredCacheConfig((CacheMode)this.cacheMode, (boolean)true);
            if (this.totalOrder) {
                builder.transaction().transactionProtocol(TransactionProtocol.TOTAL_ORDER);
            }
            builder.locking().isolationLevel(IsolationLevel.READ_COMMITTED).lockAcquisitionTimeout(0L);
            builder.clustering().hash().numOwners(1);
            builder.transaction().recovery().disable();
            this.extendedStatisticInterceptors[i] = new ExtendedStatisticInterceptor();
            builder.customInterceptors().addInterceptor().interceptor((AsyncInterceptor)this.extendedStatisticInterceptors[i]).after(TxInterceptor.class);
            this.addClusterEnabledCacheManager((SerializationContextInitializer)TestDataSCI.INSTANCE, builder);
        }
        this.waitForClusterToForm();
        for (i = 0; i < 2; ++i) {
            TestingUtil.replaceComponent((CacheContainer)((CacheContainer)this.cacheManagers.get(i)), TimeService.class, (Object)TEST_TIME_SERVICE, (boolean)true);
            this.lockManagers[i] = TestingUtil.extractLockManager((Cache)this.cache(i));
            ExtendedStatisticInterceptor interceptor = this.extendedStatisticInterceptors[i];
            CacheStatisticManager manager = (CacheStatisticManager)TestingUtil.extractField((Object)interceptor, (String)"cacheStatisticManager");
            CacheStatisticCollector collector = (CacheStatisticCollector)TestingUtil.extractField((Object)manager, (String)"cacheStatisticCollector");
            ConcurrentGlobalContainer globalContainer = (ConcurrentGlobalContainer)TestingUtil.extractField((Object)collector, (String)"globalContainer");
            TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)manager, CacheStatisticManager.class);
            TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)collector, CacheStatisticCollector.class);
            TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)globalContainer, ConcurrentGlobalContainer.class);
            TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)interceptor, ExtendedStatisticInterceptor.class);
            TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)this.lockManagers[i], ExtendedStatisticLockManager.class);
            TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)TestingUtil.extractComponent((Cache)this.cache(i), RpcManager.class), ExtendedStatisticRpcManager.class);
            this.transactionTrackInterceptors[i] = TransactionTrackInterceptor.injectInCache((Cache)this.cache(i));
        }
    }

    private void testStats(WriteOperation operation, int numOfWriteTx, int numOfWrites, int numOfReadsPerWriteTx, int numOfReadOnlyTx, int numOfReadPerReadTx, boolean abort, boolean executeOnCoordinator) throws Exception {
        int tx;
        int txExecutor = executeOnCoordinator ? 0 : 1;
        int localGetsReadTx = 0;
        int localGetsWriteTx = 0;
        int localPuts = 0;
        int remoteGetsReadTx = 0;
        int remoteGetsWriteTx = 0;
        int remotePuts = 0;
        int localLocks = 0;
        int remoteLocks = 0;
        int numOfLocalWriteTx = 0;
        int numOfRemoteWriteTx = 0;
        this.resetTxCounters();
        boolean remote = false;
        this.tm(txExecutor).begin();
        for (int i = 1; i <= (numOfReadsPerWriteTx + numOfWrites) * numOfWriteTx + numOfReadPerReadTx * numOfReadOnlyTx; ++i) {
            this.cache(txExecutor).put(this.getKey(i), this.getInitValue(i));
            if (!this.isRemote(this.getKey(i), this.cache(txExecutor))) continue;
            remote = true;
        }
        this.tm(txExecutor).commit();
        this.assertTxSeen(txExecutor, 1, this.replicated || remote ? 1 : 0, 0, false);
        this.resetStats();
        this.resetTxCounters();
        int keyIndex = 0;
        for (tx = 1; tx <= numOfWriteTx; ++tx) {
            Object key;
            int i;
            boolean involvesRemoteNode = this.cacheMode.isReplicated();
            this.tm(txExecutor).begin();
            for (i = 1; i <= numOfReadsPerWriteTx; ++i) {
                if (this.isRemote(key = this.getKey(++keyIndex), this.cache(txExecutor))) {
                    ++remoteGetsWriteTx;
                } else {
                    ++localGetsWriteTx;
                }
                Assert.assertEquals((Object)this.cache(txExecutor).get(key), (Object)this.getInitValue(keyIndex));
            }
            for (i = 1; i <= numOfWrites; ++i) {
                key = operation == WriteOperation.PUT_IF ? this.getKey(-keyIndex) : this.getKey(++keyIndex);
                switch (operation) {
                    case PUT: {
                        this.cache(txExecutor).put(key, this.getValue(keyIndex));
                        break;
                    }
                    case PUT_IF: {
                        this.cache(txExecutor).putIfAbsent(key, this.getValue(keyIndex));
                        break;
                    }
                    case REPLACE: {
                        this.cache(txExecutor).replace(key, this.getValue(keyIndex));
                        break;
                    }
                    case REPLACE_IF: {
                        this.cache(txExecutor).replace(key, this.getInitValue(keyIndex), this.getValue(keyIndex));
                        break;
                    }
                    case REMOVE: {
                        this.cache(txExecutor).remove(key);
                        break;
                    }
                    case REMOVE_IF: {
                        this.cache(txExecutor).remove(key, this.getInitValue(keyIndex));
                        break;
                    }
                }
                if (this.isRemote(key, this.cache(txExecutor))) {
                    ++remotePuts;
                    involvesRemoteNode = true;
                } else {
                    ++localPuts;
                }
                if (this.isLockOwner(key, this.cache(txExecutor))) {
                    if (abort) continue;
                    ++localLocks;
                    continue;
                }
                if (abort) continue;
                ++remoteLocks;
            }
            if (involvesRemoteNode) {
                ++numOfRemoteWriteTx;
            }
            ++numOfLocalWriteTx;
            if (abort) {
                this.tm(txExecutor).rollback();
                continue;
            }
            this.tm(txExecutor).commit();
        }
        for (tx = 1; tx <= numOfReadOnlyTx; ++tx) {
            this.tm(txExecutor).begin();
            for (int i = 1; i <= numOfReadPerReadTx; ++i) {
                Object key;
                if (this.isRemote(key = this.getKey(++keyIndex), this.cache(txExecutor))) {
                    ++remoteGetsReadTx;
                } else {
                    ++localGetsReadTx;
                }
                Assert.assertEquals((Object)this.cache(txExecutor).get(key), (Object)this.getInitValue(keyIndex));
            }
            if (abort) {
                this.tm(txExecutor).rollback();
                continue;
            }
            this.tm(txExecutor).commit();
        }
        this.assertTxSeen(txExecutor, numOfLocalWriteTx, numOfRemoteWriteTx, numOfReadOnlyTx, abort);
        EnumSet<ExtendedStatistic> statsToValidate = this.getStatsToValidate();
        this.assertTxValues(statsToValidate, numOfLocalWriteTx, numOfRemoteWriteTx, numOfReadOnlyTx, txExecutor, abort);
        this.assertLockingValues(statsToValidate, localLocks, remoteLocks, numOfLocalWriteTx, numOfRemoteWriteTx, txExecutor, abort);
        this.assertAccessesValues(statsToValidate, localGetsReadTx, remoteGetsReadTx, localGetsWriteTx, remoteGetsWriteTx, localPuts, remotePuts, numOfWriteTx, numOfReadOnlyTx, txExecutor, abort);
        this.assertAttributeValue(ExtendedStatistic.NUM_WRITE_SKEW, statsToValidate, 0.0, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.WRITE_SKEW_PROBABILITY, statsToValidate, 0.0, 0.0, txExecutor);
        this.assertAllStatsValidated(statsToValidate);
        this.resetStats();
    }

    private void assertTxSeen(int txExecutor, int localTx, int remoteTx, int readOnlyTx, boolean abort) throws InterruptedException {
        for (int i = 0; i < 2; ++i) {
            if (i == txExecutor) {
                Assert.assertTrue((boolean)this.transactionTrackInterceptors[i].awaitForLocalCompletion(localTx + readOnlyTx, 60L, TimeUnit.SECONDS));
                if (!this.totalOrder || abort) continue;
                Assert.assertTrue((boolean)this.transactionTrackInterceptors[i].awaitForRemoteCompletion(localTx, 60L, TimeUnit.SECONDS));
                continue;
            }
            if (abort) continue;
            Assert.assertTrue((boolean)this.transactionTrackInterceptors[i].awaitForRemoteCompletion(remoteTx, 60L, TimeUnit.SECONDS));
        }
        for (LockManager lockManager : this.lockManagers) {
            this.eventuallyEquals(0, () -> ((LockManager)lockManager).getNumberOfLocksHeld());
        }
    }

    private void resetTxCounters() {
        for (TransactionTrackInterceptor interceptor : this.transactionTrackInterceptors) {
            interceptor.reset();
        }
    }

    private boolean isRemote(Object key, Cache cache) {
        return !DistributionTestHelper.isOwner((Cache)cache, (Object)key);
    }

    private boolean isLockOwner(Object key, Cache cache) {
        return DistributionTestHelper.isFirstOwner((Cache)cache, (Object)key);
    }

    private Object getKey(int i) {
        if (i < 0) {
            return new MagicKey("KEY_" + i, this.cache(0));
        }
        for (int j = this.keys.size(); j < i; ++j) {
            this.keys.add(new MagicKey("KEY_" + (j + 1), this.cache(0)));
        }
        return this.keys.get(i - 1);
    }

    private Object getInitValue(int i) {
        return "INIT_" + i;
    }

    private Object getValue(int i) {
        return "VALUE_" + i;
    }

    private void assertTxValues(EnumSet<ExtendedStatistic> statsToValidate, int numOfLocalWriteTx, int numOfRemoteWriteTx, int numOfReadTx, int txExecutor, boolean abort) {
        this.log.infof("Check Tx value: localWriteTx=%s, remoteWriteTx=%s, readTx=%s, txExecutor=%s, abort?=%s", new Object[]{numOfLocalWriteTx, numOfRemoteWriteTx, numOfReadTx, txExecutor, abort});
        if (abort) {
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMITTED_RO_TX, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMITTED_WR_TX, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_ABORTED_WR_TX, statsToValidate, numOfLocalWriteTx, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_ABORTED_RO_TX, statsToValidate, numOfReadTx, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMITTED_TX, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_LOCAL_COMMITTED_TX, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_EXEC_NO_CONT, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.WRITE_TX_PERCENTAGE, statsToValidate, (double)numOfLocalWriteTx * 1.0 / (double)(numOfLocalWriteTx + numOfReadTx), 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.SUCCESSFUL_WRITE_TX_PERCENTAGE, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.WR_TX_ABORTED_EXECUTION_TIME, statsToValidate, numOfLocalWriteTx != 0 ? MICROSECONDS : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.RO_TX_ABORTED_EXECUTION_TIME, statsToValidate, numOfReadTx, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.WR_TX_SUCCESSFUL_EXECUTION_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.RO_TX_SUCCESSFUL_EXECUTION_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.ABORT_RATE, statsToValidate, 1.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.ARRIVAL_RATE, statsToValidate, (double)(numOfLocalWriteTx + numOfReadTx) / SECONDS, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.THROUGHPUT, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.ROLLBACK_EXECUTION_TIME, statsToValidate, numOfReadTx != 0 || numOfLocalWriteTx != 0 ? MICROSECONDS : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_ROLLBACK_COMMAND, statsToValidate, numOfReadTx + numOfLocalWriteTx, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_ROLLBACK_EXECUTION_TIME, statsToValidate, numOfReadTx != 0 || numOfLocalWriteTx != 0 ? MICROSECONDS : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.REMOTE_ROLLBACK_EXECUTION_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.COMMIT_EXECUTION_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMIT_COMMAND, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_COMMIT_EXECUTION_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.REMOTE_COMMIT_EXECUTION_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.PREPARE_EXECUTION_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_PREPARE_COMMAND, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_PREPARE_EXECUTION_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.REMOTE_PREPARE_EXECUTION_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_SYNC_PREPARE, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.SYNC_PREPARE_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_SYNC_COMMIT, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.SYNC_COMMIT_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_SYNC_ROLLBACK, statsToValidate, !this.totalOrder ? (double)numOfLocalWriteTx : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.SYNC_ROLLBACK_TIME, statsToValidate, numOfLocalWriteTx != 0 && !this.totalOrder ? MICROSECONDS : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.ASYNC_COMPLETE_NOTIFY_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_ASYNC_COMPLETE_NOTIFY, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_PREPARE, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_COMMIT, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_ROLLBACK, statsToValidate, !this.totalOrder && numOfLocalWriteTx != 0 && this.replicated ? 2.0 : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_COMPLETE_NOTIFY, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.RESPONSE_TIME, statsToValidate, 0.0, 0.0, txExecutor);
        } else {
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMITTED_RO_TX, statsToValidate, numOfReadTx, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMITTED_WR_TX, statsToValidate, this.totalOrder ? 2 * numOfLocalWriteTx : numOfLocalWriteTx, numOfRemoteWriteTx, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_ABORTED_WR_TX, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_ABORTED_RO_TX, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMITTED_TX, statsToValidate, (this.totalOrder ? 2 * numOfLocalWriteTx : numOfLocalWriteTx) + numOfReadTx, numOfRemoteWriteTx, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_LOCAL_COMMITTED_TX, statsToValidate, numOfReadTx + numOfLocalWriteTx, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_EXEC_NO_CONT, statsToValidate, numOfLocalWriteTx != 0 ? MICROSECONDS : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.WRITE_TX_PERCENTAGE, statsToValidate, (double)numOfLocalWriteTx * 1.0 / (double)(numOfReadTx + numOfLocalWriteTx), 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.SUCCESSFUL_WRITE_TX_PERCENTAGE, statsToValidate, numOfReadTx + numOfLocalWriteTx > 0 ? (double)numOfLocalWriteTx * 1.0 / (double)(numOfReadTx + numOfLocalWriteTx) : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.WR_TX_ABORTED_EXECUTION_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.RO_TX_ABORTED_EXECUTION_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.WR_TX_SUCCESSFUL_EXECUTION_TIME, statsToValidate, numOfLocalWriteTx != 0 ? MICROSECONDS : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.RO_TX_SUCCESSFUL_EXECUTION_TIME, statsToValidate, numOfReadTx != 0 ? MICROSECONDS : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.ABORT_RATE, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.ARRIVAL_RATE, statsToValidate, (double)((this.totalOrder ? 2 * numOfLocalWriteTx : numOfLocalWriteTx) + numOfReadTx) / SECONDS, (double)numOfRemoteWriteTx / SECONDS, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.THROUGHPUT, statsToValidate, (double)(numOfLocalWriteTx + numOfReadTx) / SECONDS, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.ROLLBACK_EXECUTION_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_ROLLBACK_COMMAND, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_ROLLBACK_EXECUTION_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.REMOTE_ROLLBACK_EXECUTION_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.COMMIT_EXECUTION_TIME, statsToValidate, (numOfReadTx != 0 || numOfLocalWriteTx != 0) && !this.totalOrder ? MICROSECONDS : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMIT_COMMAND, statsToValidate, !this.totalOrder ? (double)(numOfReadTx + numOfLocalWriteTx) : 0.0, !this.totalOrder ? (double)numOfRemoteWriteTx : 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_COMMIT_EXECUTION_TIME, statsToValidate, (numOfReadTx != 0 || numOfLocalWriteTx != 0) && !this.totalOrder ? MICROSECONDS : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.REMOTE_COMMIT_EXECUTION_TIME, statsToValidate, 0.0, numOfRemoteWriteTx != 0 && !this.totalOrder ? MICROSECONDS : 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.PREPARE_EXECUTION_TIME, statsToValidate, numOfReadTx + (this.totalOrder ? 2 * numOfLocalWriteTx : numOfLocalWriteTx), numOfRemoteWriteTx, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_PREPARE_COMMAND, statsToValidate, numOfReadTx + (this.totalOrder ? 2 * numOfLocalWriteTx : numOfLocalWriteTx), numOfRemoteWriteTx, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_PREPARE_EXECUTION_TIME, statsToValidate, numOfReadTx != 0 || numOfLocalWriteTx != 0 ? MICROSECONDS : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.REMOTE_PREPARE_EXECUTION_TIME, statsToValidate, this.totalOrder && numOfLocalWriteTx != 0 ? MICROSECONDS : 0.0, numOfRemoteWriteTx != 0 ? MICROSECONDS : 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_SYNC_PREPARE, statsToValidate, numOfLocalWriteTx, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.SYNC_PREPARE_TIME, statsToValidate, numOfLocalWriteTx != 0 ? MICROSECONDS : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_SYNC_COMMIT, statsToValidate, !this.totalOrder ? (double)numOfLocalWriteTx : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.SYNC_COMMIT_TIME, statsToValidate, numOfLocalWriteTx != 0 && !this.totalOrder ? MICROSECONDS : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_SYNC_ROLLBACK, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.SYNC_ROLLBACK_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.ASYNC_COMPLETE_NOTIFY_TIME, statsToValidate, numOfLocalWriteTx != 0 && !this.totalOrder ? MICROSECONDS : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_ASYNC_COMPLETE_NOTIFY, statsToValidate, !this.totalOrder ? (double)numOfLocalWriteTx : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_PREPARE, statsToValidate, this.replicated ? 2.0 : (this.totalOrder && txExecutor == 1 ? 2.0 : 1.0), 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_COMMIT, statsToValidate, !this.totalOrder ? (this.replicated ? 2.0 : 1.0) : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_ROLLBACK, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_COMPLETE_NOTIFY, statsToValidate, !this.totalOrder ? (double)(this.replicated ? 2 : 1) : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.RESPONSE_TIME, statsToValidate, numOfReadTx != 0 || numOfLocalWriteTx != 0 ? MICROSECONDS : 0.0, 0.0, txExecutor);
        }
    }

    private void assertLockingValues(EnumSet<ExtendedStatistic> statsToValidate, int numOfLocalLocks, int numOfRemoteLocks, int numOfLocalWriteTx, int numOfRemoteWriteTx, int txExecutor, boolean abort) {
        this.log.infof("Check Locking value. localLocks=%s, remoteLocks=%s, localWriteTx=%s, remoteWriteTx=%s, txExecutor=%s, abort?=%s", new Object[]{numOfLocalLocks, numOfRemoteLocks, numOfLocalWriteTx, numOfRemoteWriteTx, txExecutor, abort});
        if (this.totalOrder) {
            this.assertAttributeValue(ExtendedStatistic.LOCK_HOLD_TIME_LOCAL, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.LOCK_HOLD_TIME_REMOTE, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_LOCK_PER_LOCAL_TX, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_LOCK_PER_REMOTE_TX, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_HELD_LOCKS_SUCCESS_LOCAL_TX, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.LOCK_HOLD_TIME_SUCCESS_LOCAL_TX, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.LOCK_HOLD_TIME, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_HELD_LOCKS, statsToValidate, 0.0, 0.0, txExecutor);
        } else {
            this.assertAttributeValue(ExtendedStatistic.LOCK_HOLD_TIME_LOCAL, statsToValidate, numOfLocalLocks != 0 ? MICROSECONDS : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.LOCK_HOLD_TIME_REMOTE, statsToValidate, 0.0, numOfRemoteLocks != 0 ? MICROSECONDS : 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_LOCK_PER_LOCAL_TX, statsToValidate, numOfLocalWriteTx != 0 ? (double)numOfLocalLocks * 1.0 / (double)numOfLocalWriteTx : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_LOCK_PER_REMOTE_TX, statsToValidate, 0.0, numOfRemoteWriteTx != 0 ? (double)numOfRemoteLocks * 1.0 / (double)numOfRemoteWriteTx : 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_HELD_LOCKS_SUCCESS_LOCAL_TX, statsToValidate, !abort && numOfLocalWriteTx != 0 ? (double)numOfLocalLocks * 1.0 / (double)numOfLocalWriteTx : 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.LOCK_HOLD_TIME_SUCCESS_LOCAL_TX, statsToValidate, 0.0, 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.LOCK_HOLD_TIME, statsToValidate, numOfLocalLocks != 0 ? MICROSECONDS : 0.0, numOfRemoteLocks != 0 ? MICROSECONDS : 0.0, txExecutor);
            this.assertAttributeValue(ExtendedStatistic.NUM_HELD_LOCKS, statsToValidate, numOfLocalLocks, numOfRemoteLocks, txExecutor);
        }
        this.assertAttributeValue(ExtendedStatistic.NUM_WAITED_FOR_LOCKS, statsToValidate, 0.0, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.LOCK_WAITING_TIME, statsToValidate, 0.0, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.NUM_LOCK_FAILED_TIMEOUT, statsToValidate, 0.0, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.NUM_LOCK_FAILED_DEADLOCK, statsToValidate, 0.0, 0.0, txExecutor);
    }

    private void assertAccessesValues(EnumSet<ExtendedStatistic> statsToValidate, int localGetsReadTx, int remoteGetsReadTx, int localGetsWriteTx, int remoteGetsWriteTx, int localPuts, int remotePuts, int numOfWriteTx, int numOfReadTx, int txExecutor, boolean abort) {
        this.log.infof("Check accesses values. localGetsReadTx=%s, remoteGetsReadTx=%s, localGetsWriteTx=%s, remoteGetsWriteTx=%s, localPuts=%s, remotePuts=%s, writeTx=%s, readTx=%s, txExecutor=%s, abort?=%s", new Object[]{localGetsReadTx, remoteGetsReadTx, localGetsWriteTx, remoteGetsWriteTx, localPuts, remotePuts, numOfWriteTx, numOfReadTx, txExecutor, abort});
        this.assertAttributeValue(ExtendedStatistic.NUM_REMOTE_PUT, statsToValidate, remotePuts, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.LOCAL_PUT_EXECUTION, statsToValidate, 0.0, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.REMOTE_PUT_EXECUTION, statsToValidate, remotePuts != 0 ? MICROSECONDS : 0.0, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.NUM_PUT, statsToValidate, remotePuts + localPuts, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.NUM_PUTS_WR_TX, statsToValidate, !abort && numOfWriteTx != 0 ? ((double)localPuts + (double)remotePuts * 1.0) / (double)numOfWriteTx : 0.0, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.NUM_REMOTE_PUTS_WR_TX, statsToValidate, !abort && numOfWriteTx != 0 ? (double)remotePuts * 1.0 / (double)numOfWriteTx : 0.0, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.NUM_REMOTE_GET, statsToValidate, remoteGetsReadTx + remoteGetsWriteTx, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.NUM_GET, statsToValidate, localGetsReadTx + localGetsWriteTx + remoteGetsReadTx + remoteGetsWriteTx, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.NUM_GETS_RO_TX, statsToValidate, !abort && numOfReadTx != 0 ? ((double)localGetsReadTx + (double)remoteGetsReadTx * 1.0) / (double)numOfReadTx : 0.0, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.NUM_GETS_WR_TX, statsToValidate, !abort && numOfWriteTx != 0 ? ((double)localGetsWriteTx + (double)remoteGetsWriteTx * 1.0) / (double)numOfWriteTx : 0.0, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.NUM_REMOTE_GETS_WR_TX, statsToValidate, !abort && numOfWriteTx != 0 ? (double)remoteGetsWriteTx * 1.0 / (double)numOfWriteTx : 0.0, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.NUM_REMOTE_GETS_RO_TX, statsToValidate, !abort && numOfReadTx != 0 ? (double)remoteGetsReadTx * 1.0 / (double)numOfReadTx : 0.0, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.ALL_GET_EXECUTION, statsToValidate, remoteGetsReadTx + localGetsReadTx + localGetsWriteTx + remoteGetsWriteTx, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.LOCAL_GET_EXECUTION, statsToValidate, remoteGetsReadTx + remoteGetsWriteTx < localGetsReadTx + localGetsWriteTx ? MICROSECONDS : 0.0, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.REMOTE_GET_EXECUTION, statsToValidate, remoteGetsReadTx != 0 || remoteGetsWriteTx != 0 ? MICROSECONDS : 0.0, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.NUM_SYNC_GET, statsToValidate, remoteGetsReadTx + remoteGetsWriteTx, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.SYNC_GET_TIME, statsToValidate, remoteGetsReadTx != 0 || remoteGetsWriteTx != 0 ? MICROSECONDS : 0.0, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.NUM_NODES_GET, statsToValidate, remoteGetsReadTx != 0 || remoteGetsWriteTx != 0 ? 1.0 : 0.0, 0.0, txExecutor);
    }

    private void resetStats() {
        for (ExtendedStatisticInterceptor interceptor : this.extendedStatisticInterceptors) {
            interceptor.resetStatistics();
            for (ExtendedStatistic extendedStatistic : ExtendedStatistic.values()) {
                Assert.assertEquals((Object)interceptor.getAttribute(extendedStatistic), (Object)0.0, (String)("Attribute " + extendedStatistic + " is not zero after reset"));
            }
        }
    }

    private void assertAttributeValue(ExtendedStatistic attr, EnumSet<ExtendedStatistic> statsToValidate, double txExecutorValue, double nonTxExecutorValue, int txExecutorIndex) {
        Assert.assertTrue((boolean)statsToValidate.contains(attr), (String)("Attribute " + attr + " already validated"));
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((Object)this.extendedStatisticInterceptors[i].getAttribute(attr), (Object)(i == txExecutorIndex ? txExecutorValue : nonTxExecutorValue), (String)("Attribute " + attr + " has wrong value for cache " + i + "."));
        }
        statsToValidate.remove(attr);
    }

    private EnumSet<ExtendedStatistic> getStatsToValidate() {
        EnumSet<ExtendedStatistic> statsToValidate = EnumSet.allOf(ExtendedStatistic.class);
        statsToValidate.removeAll(EnumSet.of(ExtendedStatistic.PREPARE_COMMAND_SIZE, ExtendedStatistic.COMMIT_COMMAND_SIZE, ExtendedStatistic.CLUSTERED_GET_COMMAND_SIZE));
        return statsToValidate;
    }

    private void assertAllStatsValidated(EnumSet<ExtendedStatistic> statsToValidate) {
        Assert.assertTrue((boolean)statsToValidate.isEmpty(), (String)("Stats not validated: " + statsToValidate + "."));
    }

    private static enum WriteOperation {
        PUT,
        PUT_IF,
        REPLACE,
        REPLACE_IF,
        REMOVE,
        REMOVE_IF;

    }
}

