/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.extendedstats.wrappers;

import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.time.TimeService;
import org.infinispan.context.InvocationContext;
import org.infinispan.extendedstats.CacheStatisticManager;
import org.infinispan.extendedstats.container.ExtendedStatistic;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.locks.KeyAwareLockPromise;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.LockState;
import org.infinispan.util.concurrent.locks.impl.InfinispanLock;

public class ExtendedStatisticLockManager
implements LockManager {
    private final LockManager actual;
    private final CacheStatisticManager cacheStatisticManager;
    private final ConcurrentMap<Object, LockInfo> lockInfoMap = new ConcurrentHashMap<Object, LockInfo>();
    private final TimeService timeService;

    public ExtendedStatisticLockManager(LockManager actual, CacheStatisticManager cacheStatisticManager, TimeService timeService) {
        this.cacheStatisticManager = cacheStatisticManager;
        this.actual = actual;
        this.timeService = timeService;
    }

    public final LockManager getActual() {
        return this.actual;
    }

    public KeyAwareLockPromise lock(Object key, Object lockOwner, long time, TimeUnit unit) {
        if (this.lockOwnerAlreadyExists(key, lockOwner)) {
            return this.actual.lock(key, lockOwner, time, unit);
        }
        LockInfo lockInfo = new LockInfo(lockOwner instanceof GlobalTransaction ? (GlobalTransaction)lockOwner : null);
        this.updateContentionStats(key, lockInfo);
        long start = this.timeService.time();
        KeyAwareLockPromise lockPromise = this.actual.lock(key, lockOwner, time, unit);
        lockPromise.addListener((lockedKey, state) -> {
            long end = this.timeService.time();
            lockInfo.lockTimeStamp = end;
            if (lockInfo.contention) {
                lockInfo.lockWaiting = this.timeService.timeDuration(start, end, TimeUnit.NANOSECONDS);
            }
            if (state == LockState.ACQUIRED) {
                this.lockInfoMap.putIfAbsent(lockedKey, lockInfo);
            } else {
                lockInfo.updateStats(null);
            }
        });
        return lockPromise;
    }

    public KeyAwareLockPromise lockAll(Collection<?> keys, Object lockOwner, long time, TimeUnit unit) {
        if (keys.size() == 1) {
            return this.lock(keys.iterator().next(), lockOwner, time, unit);
        }
        HashMap tmpMap = new HashMap();
        for (Object key : keys) {
            if (this.lockOwnerAlreadyExists(key, lockOwner)) continue;
            LockInfo lockInfo = new LockInfo(lockOwner instanceof GlobalTransaction ? (GlobalTransaction)lockOwner : null);
            this.updateContentionStats(key, lockInfo);
            tmpMap.put(key, lockInfo);
        }
        long start = this.timeService.time();
        KeyAwareLockPromise lockPromise = this.actual.lockAll(keys, lockOwner, time, unit);
        lockPromise.addListener((lockedKey, state) -> {
            long end = this.timeService.time();
            LockInfo lockInfo = (LockInfo)tmpMap.get(lockedKey);
            if (lockInfo == null) {
                return;
            }
            lockInfo.lockTimeStamp = end;
            if (lockInfo.contention) {
                lockInfo.lockWaiting = this.timeService.timeDuration(start, end, TimeUnit.NANOSECONDS);
            }
            if (state == LockState.ACQUIRED) {
                this.lockInfoMap.putIfAbsent(lockedKey, lockInfo);
            } else {
                lockInfo.updateStats(null);
            }
        });
        return lockPromise;
    }

    public void unlock(Object key, Object lockOwner) {
        long timestamp = this.timeService.time();
        this.onUnlock(key, lockOwner, timestamp);
        this.actual.unlock(key, lockOwner);
    }

    public void unlockAll(Collection<?> keys, Object lockOwner) {
        long timestamp = this.timeService.time();
        for (Object key : keys) {
            this.onUnlock(key, lockOwner, timestamp);
        }
        this.actual.unlockAll(keys, lockOwner);
    }

    public void unlockAll(InvocationContext ctx) {
        long timestamp = this.timeService.time();
        Object lockOwner = ctx.getLockOwner();
        for (Object key : ctx.getLockedKeys()) {
            this.onUnlock(key, lockOwner, timestamp);
        }
        this.actual.unlockAll(ctx);
    }

    public boolean ownsLock(Object key, Object owner) {
        return this.actual.ownsLock(key, owner);
    }

    public boolean isLocked(Object key) {
        return this.actual.isLocked(key);
    }

    public Object getOwner(Object key) {
        return this.actual.getOwner(key);
    }

    public String printLockInfo() {
        return this.actual.printLockInfo();
    }

    public int getNumberOfLocksHeld() {
        return this.actual.getNumberOfLocksHeld();
    }

    public InfinispanLock getLock(Object key) {
        return this.actual.getLock(key);
    }

    private boolean lockOwnerAlreadyExists(Object key, Object lockOwner) {
        InfinispanLock lock = this.actual.getLock(key);
        return lock != null && lock.containsLockOwner(lockOwner);
    }

    private void updateContentionStats(Object key, LockInfo lockInfo) {
        Object holder = this.getOwner(key);
        if (holder != null) {
            lockInfo.contention = !holder.equals(lockInfo.owner);
        }
    }

    private void onUnlock(Object key, Object lockOwner, long timestamp) {
        LockInfo lockInfo = (LockInfo)this.lockInfoMap.get(key);
        if (lockInfo != null && lockInfo.owner.equals(lockOwner)) {
            lockInfo.updateStats(timestamp);
            this.lockInfoMap.remove(key);
        }
    }

    private class LockInfo {
        private final GlobalTransaction owner;
        private final boolean local;
        private long lockTimeStamp = -1L;
        private boolean contention = false;
        private long lockWaiting = -1L;

        public LockInfo(GlobalTransaction owner) {
            this.owner = owner;
            this.local = owner != null && !owner.isRemote();
        }

        public final void updateStats(Long releaseTimeStamp) {
            boolean locked = releaseTimeStamp != null;
            long holdTime = !locked ? 0L : ExtendedStatisticLockManager.this.timeService.timeDuration(this.lockTimeStamp, releaseTimeStamp.longValue(), TimeUnit.NANOSECONDS);
            ExtendedStatisticLockManager.this.cacheStatisticManager.add(ExtendedStatistic.LOCK_HOLD_TIME, holdTime, this.owner, this.local);
            if (this.lockWaiting != -1L) {
                ExtendedStatisticLockManager.this.cacheStatisticManager.add(ExtendedStatistic.LOCK_WAITING_TIME, this.lockWaiting, this.owner, this.local);
                ExtendedStatisticLockManager.this.cacheStatisticManager.increment(ExtendedStatistic.NUM_WAITED_FOR_LOCKS, this.owner, this.local);
            }
            if (locked) {
                ExtendedStatisticLockManager.this.cacheStatisticManager.increment(ExtendedStatistic.NUM_HELD_LOCKS, this.owner, this.local);
            }
        }
    }
}

