/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.extendedstats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.infinispan.commons.time.TimeService;
import org.infinispan.extendedstats.LocalTransactionStatistics;
import org.infinispan.extendedstats.RemoteTransactionStatistics;
import org.infinispan.extendedstats.container.ConcurrentGlobalContainer;
import org.infinispan.extendedstats.container.ExtendedStatistic;
import org.infinispan.extendedstats.container.StatisticsSnapshot;
import org.infinispan.util.EmbeddedTimeService;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="extendedstats.ConcurrentContainerTest")
public class ConcurrentContainerTest {
    private static final TimeService TIME_SERVICE = new EmbeddedTimeService();

    public void testIsolationWithTransactionMerge() {
        ConcurrentGlobalContainer globalContainer = new ConcurrentGlobalContainer(TIME_SERVICE);
        ArrayList<StatisticsSnapshot> snapshots = new ArrayList<StatisticsSnapshot>(4);
        snapshots.add(globalContainer.getSnapshot());
        LocalTransactionStatistics localTransactionStatistics = new LocalTransactionStatistics(false, TIME_SERVICE);
        int localIndex = 0;
        for (ExtendedStatistic stats : ExtendedStatistic.values()) {
            if (!stats.isLocal()) continue;
            localTransactionStatistics.addValue(stats, (double)localIndex++);
        }
        localTransactionStatistics.flushTo(globalContainer);
        snapshots.add(globalContainer.getSnapshot());
        localIndex = 0;
        for (ExtendedStatistic stats : ExtendedStatistic.values()) {
            if (stats.isLocal()) {
                this.assertSnapshotValues(snapshots, Arrays.asList(0.0, localIndex), stats, true);
                ++localIndex;
            }
            if (!stats.isRemote()) continue;
            this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0), stats, false);
        }
        RemoteTransactionStatistics remoteTransactionStatistics = new RemoteTransactionStatistics(TIME_SERVICE);
        int remoteIndex = 0;
        for (ExtendedStatistic stats : ExtendedStatistic.values()) {
            if (!stats.isRemote()) continue;
            remoteTransactionStatistics.addValue(stats, (double)remoteIndex++);
        }
        remoteTransactionStatistics.flushTo(globalContainer);
        snapshots.add(globalContainer.getSnapshot());
        localIndex = 0;
        remoteIndex = 0;
        for (ExtendedStatistic stats : ExtendedStatistic.values()) {
            if (stats.isLocal()) {
                this.assertSnapshotValues(snapshots, Arrays.asList(0.0, localIndex, localIndex), stats, true);
                ++localIndex;
            }
            if (!stats.isRemote()) continue;
            this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0, remoteIndex), stats, false);
            ++remoteIndex;
        }
        this.assertFinalState(globalContainer);
    }

    public void testIsolationWithSingleActionMerge() {
        ConcurrentGlobalContainer globalContainer = new ConcurrentGlobalContainer(TIME_SERVICE);
        ArrayList<StatisticsSnapshot> snapshots = new ArrayList<StatisticsSnapshot>(4);
        snapshots.add(globalContainer.getSnapshot());
        ExtendedStatistic localStat = ExtendedStatistic.PREPARE_COMMAND_SIZE;
        ExtendedStatistic remoteStat = ExtendedStatistic.NUM_COMMITTED_WR_TX;
        Assert.assertTrue((boolean)localStat.isLocal());
        Assert.assertTrue((boolean)remoteStat.isRemote());
        globalContainer.add(localStat, 10.0, true);
        snapshots.add(globalContainer.getSnapshot());
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 10.0), localStat, true);
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0), remoteStat, false);
        globalContainer.add(remoteStat, 20.0, false);
        snapshots.add(globalContainer.getSnapshot());
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 10.0, 10.0), localStat, true);
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0, 20.0), remoteStat, false);
        try {
            globalContainer.add(localStat, 30.0, false);
            Assert.fail((String)"Expected exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 10.0, 10.0), localStat, true);
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0, 20.0), remoteStat, false);
        this.assertFinalState(globalContainer);
    }

    public void testIsolationWithReset() {
        ConcurrentGlobalContainer globalContainer = new ConcurrentGlobalContainer(TIME_SERVICE);
        ArrayList<StatisticsSnapshot> snapshots = new ArrayList<StatisticsSnapshot>(4);
        snapshots.add(globalContainer.getSnapshot());
        LocalTransactionStatistics localTransactionStatistics = new LocalTransactionStatistics(false, TIME_SERVICE);
        RemoteTransactionStatistics remoteTransactionStatistics = new RemoteTransactionStatistics(TIME_SERVICE);
        int localIndex = 0;
        int remoteIndex = 0;
        for (ExtendedStatistic stats : ExtendedStatistic.values()) {
            if (stats.isLocal()) {
                localTransactionStatistics.addValue(stats, (double)localIndex++);
            }
            if (!stats.isRemote()) continue;
            remoteTransactionStatistics.addValue(stats, (double)remoteIndex++);
        }
        localTransactionStatistics.flushTo(globalContainer);
        remoteTransactionStatistics.flushTo(globalContainer);
        snapshots.add(globalContainer.getSnapshot());
        localIndex = 0;
        remoteIndex = 0;
        for (ExtendedStatistic stats : ExtendedStatistic.values()) {
            if (stats.isLocal()) {
                this.assertSnapshotValues(snapshots, Arrays.asList(0.0, localIndex), stats, true);
                ++localIndex;
            }
            if (!stats.isRemote()) continue;
            this.assertSnapshotValues(snapshots, Arrays.asList(0.0, remoteIndex), stats, false);
            ++remoteIndex;
        }
        globalContainer.reset();
        snapshots.add(globalContainer.getSnapshot());
        localIndex = 0;
        remoteIndex = 0;
        for (ExtendedStatistic stats : ExtendedStatistic.values()) {
            if (stats.isLocal()) {
                this.assertSnapshotValues(snapshots, Arrays.asList(0.0, localIndex, 0.0), stats, true);
                ++localIndex;
            }
            if (!stats.isRemote()) continue;
            this.assertSnapshotValues(snapshots, Arrays.asList(0.0, remoteIndex, 0.0), stats, false);
            ++remoteIndex;
        }
        localTransactionStatistics.flushTo(globalContainer);
        remoteTransactionStatistics.flushTo(globalContainer);
        snapshots.add(globalContainer.getSnapshot());
        localIndex = 0;
        remoteIndex = 0;
        for (ExtendedStatistic stats : ExtendedStatistic.values()) {
            if (stats.isLocal()) {
                this.assertSnapshotValues(snapshots, Arrays.asList(0.0, localIndex, 0.0, localIndex), stats, true);
                ++localIndex;
            }
            if (!stats.isRemote()) continue;
            this.assertSnapshotValues(snapshots, Arrays.asList(0.0, remoteIndex, 0.0, remoteIndex), stats, false);
            ++remoteIndex;
        }
        this.assertFinalState(globalContainer);
    }

    public void testIsolationWithResetMerge() {
        ConcurrentGlobalContainer globalContainer = new ConcurrentGlobalContainer(TIME_SERVICE);
        ArrayList<StatisticsSnapshot> snapshots = new ArrayList<StatisticsSnapshot>(4);
        snapshots.add(globalContainer.getSnapshot());
        ExtendedStatistic localStat = ExtendedStatistic.PREPARE_COMMAND_SIZE;
        ExtendedStatistic remoteStat = ExtendedStatistic.NUM_COMMITTED_WR_TX;
        Assert.assertTrue((boolean)localStat.isLocal());
        Assert.assertTrue((boolean)remoteStat.isRemote());
        globalContainer.add(localStat, 10.0, true);
        globalContainer.add(remoteStat, 20.0, false);
        snapshots.add(globalContainer.getSnapshot());
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 10.0), localStat, true);
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 20.0), remoteStat, false);
        globalContainer.reset();
        snapshots.add(globalContainer.getSnapshot());
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 10.0, 0.0), localStat, true);
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 20.0, 0.0), remoteStat, false);
        globalContainer.add(localStat, 10.0, true);
        globalContainer.add(remoteStat, 20.0, false);
        snapshots.add(globalContainer.getSnapshot());
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 10.0, 0.0, 10.0), localStat, true);
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 20.0, 0.0, 20.0), remoteStat, false);
        this.assertFinalState(globalContainer);
    }

    public void testIsolationWithEnqueueAndResetTransaction() {
        ConcurrentGlobalContainer globalContainer = new ConcurrentGlobalContainer(TIME_SERVICE);
        ArrayList<StatisticsSnapshot> snapshots = new ArrayList<StatisticsSnapshot>(4);
        snapshots.add(globalContainer.getSnapshot());
        LocalTransactionStatistics localTransactionStatistics = new LocalTransactionStatistics(false, TIME_SERVICE);
        RemoteTransactionStatistics remoteTransactionStatistics = new RemoteTransactionStatistics(TIME_SERVICE);
        int localIndex = 0;
        int remoteIndex = 0;
        for (ExtendedStatistic stats : ExtendedStatistic.values()) {
            if (stats.isLocal()) {
                localTransactionStatistics.addValue(stats, (double)localIndex++);
            }
            if (!stats.isRemote()) continue;
            remoteTransactionStatistics.addValue(stats, (double)remoteIndex++);
        }
        globalContainer.flushing().set(true);
        localTransactionStatistics.flushTo(globalContainer);
        remoteTransactionStatistics.flushTo(globalContainer);
        localTransactionStatistics.flushTo(globalContainer);
        remoteTransactionStatistics.flushTo(globalContainer);
        localTransactionStatistics.flushTo(globalContainer);
        remoteTransactionStatistics.flushTo(globalContainer);
        Assert.assertEquals((int)globalContainer.queue().size(), (int)6);
        snapshots.add(globalContainer.getSnapshot());
        localIndex = 0;
        remoteIndex = 0;
        for (ExtendedStatistic stats : ExtendedStatistic.values()) {
            if (stats.isLocal()) {
                this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0), stats, true);
                ++localIndex;
            }
            if (!stats.isRemote()) continue;
            this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0), stats, false);
            ++remoteIndex;
        }
        globalContainer.flushing().set(false);
        snapshots.add(globalContainer.getSnapshot());
        localIndex = 0;
        remoteIndex = 0;
        for (ExtendedStatistic stats : ExtendedStatistic.values()) {
            if (stats.isLocal()) {
                this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0, 3.0 * (double)localIndex), stats, true);
                ++localIndex;
            }
            if (!stats.isRemote()) continue;
            this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0, 3.0 * (double)remoteIndex), stats, false);
            ++remoteIndex;
        }
        globalContainer.reset();
        snapshots.clear();
        snapshots.add(globalContainer.getSnapshot());
        localIndex = 0;
        remoteIndex = 0;
        for (ExtendedStatistic stats : ExtendedStatistic.values()) {
            if (stats.isLocal()) {
                this.assertSnapshotValues(snapshots, Collections.singletonList(0.0), stats, true);
                ++localIndex;
            }
            if (!stats.isRemote()) continue;
            this.assertSnapshotValues(snapshots, Collections.singletonList(0.0), stats, false);
            ++remoteIndex;
        }
        globalContainer.flushing().set(true);
        localTransactionStatistics.flushTo(globalContainer);
        remoteTransactionStatistics.flushTo(globalContainer);
        localTransactionStatistics.flushTo(globalContainer);
        remoteTransactionStatistics.flushTo(globalContainer);
        localTransactionStatistics.flushTo(globalContainer);
        globalContainer.reset();
        remoteTransactionStatistics.flushTo(globalContainer);
        snapshots.add(globalContainer.getSnapshot());
        Assert.assertTrue((boolean)globalContainer.isReset());
        Assert.assertEquals((int)globalContainer.queue().size(), (int)6);
        localIndex = 0;
        remoteIndex = 0;
        for (ExtendedStatistic stats : ExtendedStatistic.values()) {
            if (stats.isLocal()) {
                this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0), stats, true);
                ++localIndex;
            }
            if (!stats.isRemote()) continue;
            this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0), stats, false);
            ++remoteIndex;
        }
        globalContainer.flushing().set(false);
        snapshots.add(globalContainer.getSnapshot());
        Assert.assertFalse((boolean)globalContainer.isReset());
        localIndex = 0;
        remoteIndex = 0;
        for (ExtendedStatistic stats : ExtendedStatistic.values()) {
            if (stats.isLocal()) {
                this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0, 0.0), stats, true);
                ++localIndex;
            }
            if (!stats.isRemote()) continue;
            this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0, 0.0), stats, false);
            ++remoteIndex;
        }
        this.assertFinalState(globalContainer);
    }

    public void testIsolationWithEnqueueAndResetSingleAction() {
        ConcurrentGlobalContainer globalContainer = new ConcurrentGlobalContainer(TIME_SERVICE);
        ArrayList<StatisticsSnapshot> snapshots = new ArrayList<StatisticsSnapshot>(4);
        snapshots.add(globalContainer.getSnapshot());
        ExtendedStatistic localStat = ExtendedStatistic.PREPARE_COMMAND_SIZE;
        ExtendedStatistic remoteStat = ExtendedStatistic.NUM_COMMITTED_WR_TX;
        Assert.assertTrue((boolean)localStat.isLocal());
        Assert.assertTrue((boolean)remoteStat.isRemote());
        globalContainer.flushing().set(true);
        globalContainer.add(localStat, 10.0, true);
        globalContainer.add(remoteStat, 20.0, false);
        snapshots.add(globalContainer.getSnapshot());
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0), localStat, true);
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0), remoteStat, false);
        Assert.assertEquals((int)globalContainer.queue().size(), (int)2);
        globalContainer.flushing().set(false);
        snapshots.add(globalContainer.getSnapshot());
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0, 10.0), localStat, true);
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0, 20.0), remoteStat, false);
        globalContainer.reset();
        snapshots.clear();
        snapshots.add(globalContainer.getSnapshot());
        this.assertSnapshotValues(snapshots, Collections.singletonList(0.0), localStat, true);
        this.assertSnapshotValues(snapshots, Collections.singletonList(0.0), remoteStat, false);
        globalContainer.flushing().set(true);
        globalContainer.add(localStat, 10.0, true);
        globalContainer.add(remoteStat, 20.0, false);
        globalContainer.reset();
        snapshots.add(globalContainer.getSnapshot());
        Assert.assertTrue((boolean)globalContainer.isReset());
        Assert.assertEquals((int)globalContainer.queue().size(), (int)2);
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0), localStat, true);
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0), remoteStat, false);
        globalContainer.flushing().set(false);
        snapshots.add(globalContainer.getSnapshot());
        Assert.assertFalse((boolean)globalContainer.isReset());
        Assert.assertTrue((boolean)globalContainer.queue().isEmpty());
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0, 0.0), localStat, true);
        this.assertSnapshotValues(snapshots, Arrays.asList(0.0, 0.0, 0.0), remoteStat, false);
        this.assertFinalState(globalContainer);
    }

    private void assertSnapshotValues(List<StatisticsSnapshot> snapshots, List<Double> expected, ExtendedStatistic stat, boolean local) {
        Assert.assertEquals((int)snapshots.size(), (int)expected.size());
        for (int i = 0; i < snapshots.size(); ++i) {
            if (local) {
                Assert.assertEquals((Object)expected.get(i), (Object)snapshots.get(i).getLocal(stat));
                continue;
            }
            Assert.assertEquals((Object)expected.get(i), (Object)snapshots.get(i).getRemote(stat));
        }
    }

    private void assertFinalState(ConcurrentGlobalContainer globalContainer) {
        Assert.assertTrue((boolean)globalContainer.queue().isEmpty());
        Assert.assertFalse((boolean)globalContainer.isReset());
        Assert.assertFalse((boolean)globalContainer.flushing().get());
    }
}

