/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.extendedstats;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumMap;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.time.TimeService;
import org.infinispan.extendedstats.ExtendedStatisticNotFoundException;
import org.infinispan.extendedstats.TransactionStatistics;
import org.infinispan.extendedstats.container.ConcurrentGlobalContainer;
import org.infinispan.extendedstats.container.ExtendedStatistic;
import org.infinispan.extendedstats.container.StatisticsSnapshot;
import org.infinispan.extendedstats.logging.Log;
import org.infinispan.extendedstats.percentiles.PercentileStatistic;
import org.infinispan.extendedstats.percentiles.ReservoirSampler;
import org.infinispan.util.logging.LogFactory;

public class CacheStatisticCollector {
    private static final Log log = (Log)LogFactory.getLog(CacheStatisticCollector.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final TimeService timeService;
    private final ConcurrentGlobalContainer globalContainer;
    private volatile EnumMap<PercentileStatistic, ReservoirSampler> percentiles;

    public CacheStatisticCollector(TimeService timeService) {
        this.timeService = timeService;
        this.globalContainer = new ConcurrentGlobalContainer(timeService);
        this.reset();
    }

    public final void reset() {
        if (trace) {
            log.tracef("Resetting Node Scope Statistics", new Object[0]);
        }
        this.globalContainer.reset();
        this.percentiles = new EnumMap(PercentileStatistic.class);
        for (PercentileStatistic percentileStatistic : PercentileStatistic.values()) {
            this.percentiles.put(percentileStatistic, new ReservoirSampler());
        }
    }

    public final void merge(TransactionStatistics transactionStatistics) {
        ExtendedStatistic percentileSample;
        ReservoirSampler reservoirSampler;
        if (trace) {
            log.tracef("Merge transaction statistics %s to the node statistics", transactionStatistics);
        }
        if (transactionStatistics.isLocalTransaction()) {
            if (transactionStatistics.isReadOnly()) {
                reservoirSampler = this.percentiles.get((Object)PercentileStatistic.RO_LOCAL_EXECUTION);
                percentileSample = transactionStatistics.isCommitted() ? ExtendedStatistic.RO_TX_SUCCESSFUL_EXECUTION_TIME : ExtendedStatistic.RO_TX_ABORTED_EXECUTION_TIME;
            } else {
                reservoirSampler = this.percentiles.get((Object)PercentileStatistic.WR_LOCAL_EXECUTION);
                percentileSample = transactionStatistics.isCommitted() ? ExtendedStatistic.WR_TX_SUCCESSFUL_EXECUTION_TIME : ExtendedStatistic.WR_TX_ABORTED_EXECUTION_TIME;
            }
        } else if (transactionStatistics.isReadOnly()) {
            reservoirSampler = this.percentiles.get((Object)PercentileStatistic.RO_REMOTE_EXECUTION);
            percentileSample = transactionStatistics.isCommitted() ? ExtendedStatistic.RO_TX_SUCCESSFUL_EXECUTION_TIME : ExtendedStatistic.RO_TX_ABORTED_EXECUTION_TIME;
        } else {
            reservoirSampler = this.percentiles.get((Object)PercentileStatistic.WR_REMOTE_EXECUTION);
            percentileSample = transactionStatistics.isCommitted() ? ExtendedStatistic.WR_TX_SUCCESSFUL_EXECUTION_TIME : ExtendedStatistic.WR_TX_ABORTED_EXECUTION_TIME;
        }
        this.doMerge(transactionStatistics, reservoirSampler, percentileSample);
    }

    public final void addLocalValue(ExtendedStatistic stat, double value) {
        this.globalContainer.add(stat, value, true);
    }

    public final void addRemoteValue(ExtendedStatistic stat, double value) {
        this.globalContainer.add(stat, value, false);
    }

    public final double getPercentile(PercentileStatistic stat, int percentile) throws IllegalArgumentException {
        if (trace) {
            log.tracef("Get percentile %s from %s", percentile, (Object)stat);
        }
        return this.percentiles.get((Object)stat).getKPercentile(percentile);
    }

    public final double getAttribute(ExtendedStatistic stat) throws ExtendedStatisticNotFoundException {
        StatisticsSnapshot snapshot = this.globalContainer.getSnapshot();
        double value = 0.0;
        switch (stat) {
            case LOCAL_EXEC_NO_CONT: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.LOCAL_EXEC_NO_CONT, ExtendedStatistic.NUM_COMMITTED_WR_TX);
                break;
            }
            case LOCK_HOLD_TIME: {
                value = this.microAverageLocalAndRemote(snapshot, ExtendedStatistic.LOCK_HOLD_TIME, ExtendedStatistic.NUM_HELD_LOCKS);
                break;
            }
            case SYNC_PREPARE_TIME: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.SYNC_PREPARE_TIME, ExtendedStatistic.NUM_SYNC_PREPARE);
                break;
            }
            case SYNC_COMMIT_TIME: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.SYNC_COMMIT_TIME, ExtendedStatistic.NUM_SYNC_COMMIT);
                break;
            }
            case SYNC_ROLLBACK_TIME: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.SYNC_ROLLBACK_TIME, ExtendedStatistic.NUM_SYNC_ROLLBACK);
                break;
            }
            case SYNC_GET_TIME: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.SYNC_GET_TIME, ExtendedStatistic.NUM_SYNC_GET);
                break;
            }
            case ASYNC_COMPLETE_NOTIFY_TIME: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.ASYNC_COMPLETE_NOTIFY_TIME, ExtendedStatistic.NUM_ASYNC_COMPLETE_NOTIFY);
                break;
            }
            case NUM_NODES_COMMIT: {
                value = this.averageLocal(snapshot, ExtendedStatistic.NUM_NODES_COMMIT, ExtendedStatistic.NUM_SYNC_COMMIT);
                break;
            }
            case NUM_NODES_GET: {
                value = this.averageLocal(snapshot, ExtendedStatistic.NUM_NODES_GET, ExtendedStatistic.NUM_SYNC_GET);
                break;
            }
            case NUM_NODES_PREPARE: {
                value = this.averageLocal(snapshot, ExtendedStatistic.NUM_NODES_PREPARE, ExtendedStatistic.NUM_SYNC_PREPARE);
                break;
            }
            case NUM_NODES_ROLLBACK: {
                value = this.averageLocal(snapshot, ExtendedStatistic.NUM_NODES_ROLLBACK, ExtendedStatistic.NUM_SYNC_ROLLBACK);
                break;
            }
            case NUM_NODES_COMPLETE_NOTIFY: {
                value = this.averageLocal(snapshot, ExtendedStatistic.NUM_NODES_COMPLETE_NOTIFY, ExtendedStatistic.NUM_ASYNC_COMPLETE_NOTIFY);
                break;
            }
            case COMMIT_EXECUTION_TIME: {
                value = CacheStatisticCollector.convertNanosToMicro(this.averageLocal(snapshot, ExtendedStatistic.COMMIT_EXECUTION_TIME, ExtendedStatistic.NUM_COMMITTED_WR_TX, ExtendedStatistic.NUM_COMMITTED_RO_TX));
                break;
            }
            case ROLLBACK_EXECUTION_TIME: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.ROLLBACK_EXECUTION_TIME, ExtendedStatistic.NUM_ROLLBACK_COMMAND);
                break;
            }
            case LOCK_WAITING_TIME: {
                value = this.microAverageLocalAndRemote(snapshot, ExtendedStatistic.LOCK_WAITING_TIME, ExtendedStatistic.NUM_WAITED_FOR_LOCKS);
                break;
            }
            case WRITE_TX_PERCENTAGE: {
                double readTx = snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_RO_TX) + snapshot.getLocal(ExtendedStatistic.NUM_ABORTED_RO_TX);
                double writeTx = snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_WR_TX) + snapshot.getLocal(ExtendedStatistic.NUM_ABORTED_WR_TX);
                double total = readTx + writeTx;
                if (total == 0.0) break;
                value = writeTx / total;
                break;
            }
            case SUCCESSFUL_WRITE_TX_PERCENTAGE: {
                double readSuxTx = snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_RO_TX);
                double writeSuxTx = snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_WR_TX);
                double total = readSuxTx + writeSuxTx;
                if (total == 0.0) break;
                value = writeSuxTx / total;
                break;
            }
            case NUM_GETS_RO_TX: {
                value = this.averageLocal(snapshot, ExtendedStatistic.NUM_GETS_RO_TX, ExtendedStatistic.NUM_COMMITTED_RO_TX);
                break;
            }
            case NUM_GETS_WR_TX: {
                value = this.averageLocal(snapshot, ExtendedStatistic.NUM_GETS_WR_TX, ExtendedStatistic.NUM_COMMITTED_WR_TX);
                break;
            }
            case NUM_REMOTE_GETS_RO_TX: {
                value = this.averageLocal(snapshot, ExtendedStatistic.NUM_REMOTE_GETS_RO_TX, ExtendedStatistic.NUM_COMMITTED_RO_TX);
                break;
            }
            case NUM_REMOTE_GETS_WR_TX: {
                value = this.averageLocal(snapshot, ExtendedStatistic.NUM_REMOTE_GETS_WR_TX, ExtendedStatistic.NUM_COMMITTED_WR_TX);
                break;
            }
            case REMOTE_GET_EXECUTION: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.NUM_REMOTE_GET, ExtendedStatistic.REMOTE_GET_EXECUTION);
                break;
            }
            case NUM_PUTS_WR_TX: {
                value = this.averageLocal(snapshot, ExtendedStatistic.NUM_PUTS_WR_TX, ExtendedStatistic.NUM_COMMITTED_WR_TX);
                break;
            }
            case NUM_REMOTE_PUTS_WR_TX: {
                value = this.averageLocal(snapshot, ExtendedStatistic.NUM_REMOTE_PUTS_WR_TX, ExtendedStatistic.NUM_COMMITTED_WR_TX);
                break;
            }
            case REMOTE_PUT_EXECUTION: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.NUM_REMOTE_PUT, ExtendedStatistic.REMOTE_PUT_EXECUTION);
                break;
            }
            case NUM_LOCK_FAILED_DEADLOCK: 
            case NUM_LOCK_FAILED_TIMEOUT: {
                value = snapshot.getLocal(stat);
                break;
            }
            case WR_TX_SUCCESSFUL_EXECUTION_TIME: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.WR_TX_SUCCESSFUL_EXECUTION_TIME, ExtendedStatistic.NUM_COMMITTED_WR_TX);
                break;
            }
            case WR_TX_ABORTED_EXECUTION_TIME: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.WR_TX_ABORTED_EXECUTION_TIME, ExtendedStatistic.NUM_ABORTED_WR_TX);
                break;
            }
            case RO_TX_SUCCESSFUL_EXECUTION_TIME: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.RO_TX_SUCCESSFUL_EXECUTION_TIME, ExtendedStatistic.NUM_COMMITTED_RO_TX);
                break;
            }
            case PREPARE_COMMAND_SIZE: {
                value = this.averageLocal(snapshot, ExtendedStatistic.PREPARE_COMMAND_SIZE, ExtendedStatistic.NUM_SYNC_PREPARE);
                break;
            }
            case COMMIT_COMMAND_SIZE: {
                value = this.averageLocal(snapshot, ExtendedStatistic.COMMIT_COMMAND_SIZE, ExtendedStatistic.NUM_SYNC_COMMIT);
                break;
            }
            case CLUSTERED_GET_COMMAND_SIZE: {
                value = this.averageLocal(snapshot, ExtendedStatistic.NUM_SYNC_GET, ExtendedStatistic.CLUSTERED_GET_COMMAND_SIZE);
                break;
            }
            case NUM_LOCK_PER_LOCAL_TX: {
                value = this.averageLocal(snapshot, ExtendedStatistic.NUM_HELD_LOCKS, ExtendedStatistic.NUM_COMMITTED_WR_TX, ExtendedStatistic.NUM_ABORTED_WR_TX);
                break;
            }
            case NUM_LOCK_PER_REMOTE_TX: {
                value = this.averageRemote(snapshot, ExtendedStatistic.NUM_HELD_LOCKS, ExtendedStatistic.NUM_COMMITTED_WR_TX, ExtendedStatistic.NUM_ABORTED_WR_TX);
                break;
            }
            case NUM_HELD_LOCKS_SUCCESS_LOCAL_TX: {
                value = this.averageLocal(snapshot, ExtendedStatistic.NUM_HELD_LOCKS_SUCCESS_LOCAL_TX, ExtendedStatistic.NUM_COMMITTED_WR_TX);
                break;
            }
            case LOCAL_ROLLBACK_EXECUTION_TIME: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.ROLLBACK_EXECUTION_TIME, ExtendedStatistic.NUM_ROLLBACK_COMMAND);
                break;
            }
            case REMOTE_ROLLBACK_EXECUTION_TIME: {
                value = this.microAverageRemote(snapshot, ExtendedStatistic.ROLLBACK_EXECUTION_TIME, ExtendedStatistic.NUM_ROLLBACK_COMMAND);
                break;
            }
            case LOCAL_COMMIT_EXECUTION_TIME: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.COMMIT_EXECUTION_TIME, ExtendedStatistic.NUM_COMMIT_COMMAND);
                break;
            }
            case REMOTE_COMMIT_EXECUTION_TIME: {
                value = this.microAverageRemote(snapshot, ExtendedStatistic.COMMIT_EXECUTION_TIME, ExtendedStatistic.NUM_COMMIT_COMMAND);
                break;
            }
            case LOCAL_PREPARE_EXECUTION_TIME: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.PREPARE_EXECUTION_TIME, ExtendedStatistic.NUM_PREPARE_COMMAND);
                break;
            }
            case REMOTE_PREPARE_EXECUTION_TIME: {
                value = this.microAverageRemote(snapshot, ExtendedStatistic.PREPARE_EXECUTION_TIME, ExtendedStatistic.NUM_PREPARE_COMMAND);
                break;
            }
            case ABORT_RATE: {
                double totalAbort = snapshot.getLocal(ExtendedStatistic.NUM_ABORTED_RO_TX) + snapshot.getLocal(ExtendedStatistic.NUM_ABORTED_WR_TX);
                double totalCommitAndAbort = snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_RO_TX) + snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_WR_TX) + totalAbort;
                if (totalCommitAndAbort == 0.0) break;
                value = totalAbort / totalCommitAndAbort;
                break;
            }
            case ARRIVAL_RATE: {
                double localCommittedTx = snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_RO_TX) + snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_WR_TX);
                double localAbortedTx = snapshot.getLocal(ExtendedStatistic.NUM_ABORTED_RO_TX) + snapshot.getLocal(ExtendedStatistic.NUM_ABORTED_WR_TX);
                double remoteCommittedTx = snapshot.getRemote(ExtendedStatistic.NUM_COMMITTED_RO_TX) + snapshot.getRemote(ExtendedStatistic.NUM_COMMITTED_WR_TX);
                double remoteAbortedTx = snapshot.getRemote(ExtendedStatistic.NUM_ABORTED_RO_TX) + snapshot.getRemote(ExtendedStatistic.NUM_ABORTED_WR_TX);
                double totalBornTx = localAbortedTx + localCommittedTx + remoteAbortedTx + remoteCommittedTx;
                value = totalBornTx / CacheStatisticCollector.convertNanosToSeconds(this.timeService.timeDuration(snapshot.getLastResetTime(), TimeUnit.NANOSECONDS));
                break;
            }
            case THROUGHPUT: {
                double totalLocalBornTx = snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_RO_TX) + snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_WR_TX);
                value = totalLocalBornTx / CacheStatisticCollector.convertNanosToSeconds(this.timeService.timeDuration(snapshot.getLastResetTime(), TimeUnit.NANOSECONDS));
                break;
            }
            case LOCK_HOLD_TIME_LOCAL: {
                value = this.microAverageLocal(snapshot, ExtendedStatistic.LOCK_HOLD_TIME, ExtendedStatistic.NUM_HELD_LOCKS);
                break;
            }
            case LOCK_HOLD_TIME_REMOTE: {
                value = this.microAverageRemote(snapshot, ExtendedStatistic.LOCK_HOLD_TIME, ExtendedStatistic.NUM_HELD_LOCKS);
                break;
            }
            case NUM_COMMITTED_TX: {
                value = snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_RO_TX) + snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_WR_TX) + snapshot.getRemote(ExtendedStatistic.NUM_COMMITTED_RO_TX) + snapshot.getRemote(ExtendedStatistic.NUM_COMMITTED_WR_TX);
                break;
            }
            case NUM_LOCAL_COMMITTED_TX: {
                value = snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_RO_TX) + snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_WR_TX);
                break;
            }
            case WRITE_SKEW_PROBABILITY: {
                double totalTxs = snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_RO_TX) + snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_WR_TX) + snapshot.getLocal(ExtendedStatistic.NUM_ABORTED_RO_TX) + snapshot.getLocal(ExtendedStatistic.NUM_ABORTED_WR_TX);
                if (totalTxs == 0.0) break;
                double writeSkew = snapshot.getLocal(ExtendedStatistic.NUM_WRITE_SKEW);
                value = writeSkew / totalTxs;
                break;
            }
            case NUM_GET: {
                value = snapshot.getLocal(ExtendedStatistic.NUM_GETS_WR_TX) + snapshot.getLocal(ExtendedStatistic.NUM_GETS_RO_TX);
                break;
            }
            case NUM_REMOTE_GET: {
                value = snapshot.getLocal(ExtendedStatistic.NUM_REMOTE_GETS_WR_TX) + snapshot.getLocal(ExtendedStatistic.NUM_REMOTE_GETS_RO_TX);
                break;
            }
            case NUM_PUT: {
                value = snapshot.getLocal(ExtendedStatistic.NUM_PUTS_WR_TX);
                break;
            }
            case NUM_REMOTE_PUT: {
                value = snapshot.getLocal(ExtendedStatistic.NUM_REMOTE_PUTS_WR_TX);
                break;
            }
            case LOCAL_GET_EXECUTION: {
                double num = snapshot.getLocal(ExtendedStatistic.NUM_GET);
                if (num == 0.0) break;
                double local_get_time = snapshot.getLocal(ExtendedStatistic.ALL_GET_EXECUTION) - snapshot.getLocal(ExtendedStatistic.SYNC_GET_TIME);
                value = CacheStatisticCollector.convertNanosToMicro(local_get_time) / num;
                break;
            }
            case RESPONSE_TIME: {
                double succWrTot = CacheStatisticCollector.convertNanosToMicro(snapshot.getLocal(ExtendedStatistic.WR_TX_SUCCESSFUL_EXECUTION_TIME));
                double abortWrTot = CacheStatisticCollector.convertNanosToMicro(snapshot.getLocal(ExtendedStatistic.WR_TX_ABORTED_EXECUTION_TIME));
                double succRdTot = CacheStatisticCollector.convertNanosToMicro(snapshot.getLocal(ExtendedStatistic.RO_TX_SUCCESSFUL_EXECUTION_TIME));
                double numWr = snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_WR_TX);
                double numRd = snapshot.getLocal(ExtendedStatistic.NUM_COMMITTED_RO_TX);
                if (!(numWr + numRd > 0.0)) break;
                value = (succRdTot + succWrTot + abortWrTot) / (numWr + numRd);
                break;
            }
            default: {
                if (trace) {
                    log.tracef("Attribute %s is not exposed via JMX. Calculating raw value", (Object)stat);
                }
                if (stat.isLocal()) {
                    value += snapshot.getLocal(stat);
                }
                if (!stat.isRemote()) break;
                value += snapshot.getRemote(stat);
            }
        }
        if (trace) {
            log.tracef("Get attribute %s = %s", (Object)stat, value);
        }
        return value;
    }

    public final void dumpTo(StringBuilder builder) {
        StringWriter stringWriter = new StringWriter();
        this.globalContainer.dumpTo(new PrintWriter(stringWriter));
        builder.append(stringWriter.getBuffer());
    }

    public final void dumpTo(PrintWriter writer) {
        writer.println("Global Statistics:");
        this.globalContainer.dumpTo(writer);
    }

    public static double convertNanosToMicro(double nanos) {
        return nanos / 1000.0;
    }

    public static double convertNanosToSeconds(double nanos) {
        return nanos / 1.0E9;
    }

    private void doMerge(TransactionStatistics transactionStatistics, ReservoirSampler reservoirSampler, ExtendedStatistic percentileSample) {
        transactionStatistics.flushTo(this.globalContainer);
        try {
            reservoirSampler.insertSample(transactionStatistics.getValue(percentileSample));
        }
        catch (ExtendedStatisticNotFoundException e) {
            log.extendedStatisticNotFoundForPercentile(percentileSample, e);
        }
    }

    private double averageLocal(StatisticsSnapshot snapshot, ExtendedStatistic numeratorStat, ExtendedStatistic ... denominatorStats) throws ExtendedStatisticNotFoundException {
        double denominator = 0.0;
        for (ExtendedStatistic denominatorStat : denominatorStats) {
            denominator += snapshot.getLocal(denominatorStat);
        }
        if (denominator != 0.0) {
            double numerator = snapshot.getLocal(numeratorStat);
            return numerator / denominator;
        }
        return 0.0;
    }

    private double averageRemote(StatisticsSnapshot snapshot, ExtendedStatistic numeratorStat, ExtendedStatistic ... denominatorStats) throws ExtendedStatisticNotFoundException {
        double denominator = 0.0;
        for (ExtendedStatistic denominatorStat : denominatorStats) {
            denominator += snapshot.getRemote(denominatorStat);
        }
        if (denominator != 0.0) {
            double numerator = snapshot.getRemote(numeratorStat);
            return numerator / denominator;
        }
        return 0.0;
    }

    private double averageLocalAndRemote(StatisticsSnapshot snapshot, ExtendedStatistic numeratorStat, ExtendedStatistic ... denominatorStats) throws ExtendedStatisticNotFoundException {
        double denominator = 0.0;
        for (ExtendedStatistic denominatorStat : denominatorStats) {
            denominator += snapshot.getRemote(denominatorStat);
            denominator += snapshot.getLocal(denominatorStat);
        }
        if (denominator != 0.0) {
            double numerator = snapshot.getRemote(numeratorStat);
            return (numerator += snapshot.getLocal(numeratorStat)) / denominator;
        }
        return 0.0;
    }

    private double microAverageLocal(StatisticsSnapshot snapshot, ExtendedStatistic numerator, ExtendedStatistic denominator) throws ExtendedStatisticNotFoundException {
        return CacheStatisticCollector.convertNanosToMicro(this.averageLocal(snapshot, numerator, denominator));
    }

    private double microAverageRemote(StatisticsSnapshot snapshot, ExtendedStatistic numerator, ExtendedStatistic denominator) throws ExtendedStatisticNotFoundException {
        return CacheStatisticCollector.convertNanosToMicro(this.averageRemote(snapshot, numerator, denominator));
    }

    private double microAverageLocalAndRemote(StatisticsSnapshot snapshot, ExtendedStatistic numerator, ExtendedStatistic denominator) throws ExtendedStatisticNotFoundException {
        return CacheStatisticCollector.convertNanosToMicro(this.averageLocalAndRemote(snapshot, numerator, denominator));
    }
}

