/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.extendedstats.container;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.commons.time.TimeService;
import org.infinispan.extendedstats.container.ExtendedStatistic;
import org.infinispan.extendedstats.container.StatisticsSnapshot;

public final class ConcurrentGlobalContainer {
    private static final int LOCAL_STATS_OFFSET = 1;
    private static final int REMOTE_STATS_OFFSET = 1 + ExtendedStatistic.getLocalStatsSize();
    private static final int LOCAL_SIZE = ExtendedStatistic.getLocalStatsSize();
    private static final int REMOTE_SIZE = ExtendedStatistic.getRemoteStatsSize();
    private static final int TOTAL_SIZE = 1 + LOCAL_SIZE + REMOTE_SIZE;
    private final AtomicBoolean flushing;
    private final BlockingQueue<Mergeable> queue;
    private final TimeService timeService;
    private volatile double[] values;
    private volatile boolean reset;

    public ConcurrentGlobalContainer(TimeService timeService) {
        this.timeService = timeService;
        this.flushing = new AtomicBoolean(false);
        this.queue = new LinkedBlockingQueue<Mergeable>();
        this.values = this.create();
        this.values[0] = timeService.time();
    }

    public final void add(ExtendedStatistic stat, double value, boolean local) {
        this.queue.add(new SingleOperation(local ? ConcurrentGlobalContainer.getLocalIndex(stat) : ConcurrentGlobalContainer.getRemoteIndex(stat), value));
        this.tryFlush();
    }

    public final void merge(double[] toMerge, boolean local) {
        int offset;
        int expectedSize = local ? LOCAL_SIZE : REMOTE_SIZE;
        int n = offset = local ? 1 : REMOTE_STATS_OFFSET;
        if (toMerge.length != expectedSize) {
            throw new IllegalArgumentException("Size mismatch to merge transaction statistic");
        }
        this.queue.add(new Transaction(toMerge, offset));
        this.tryFlush();
    }

    public final StatisticsSnapshot getSnapshot() {
        this.tryFlush();
        return new StatisticsSnapshot(this.values);
    }

    public final void reset() {
        this.reset = true;
        this.tryFlush();
    }

    public static int getLocalIndex(ExtendedStatistic stat) {
        int index = stat.getLocalIndex();
        if (index == -1) {
            throw new IllegalArgumentException("This should never happen. Statistic " + (Object)((Object)stat) + " is not local");
        }
        return 1 + index;
    }

    public static int getRemoteIndex(ExtendedStatistic stat) {
        int index = stat.getRemoteIndex();
        if (index == -1) {
            throw new IllegalArgumentException("This should never happen. Statistic " + (Object)((Object)stat) + " is not remote");
        }
        return REMOTE_STATS_OFFSET + index;
    }

    public final BlockingQueue<?> queue() {
        return this.queue;
    }

    public final AtomicBoolean flushing() {
        return this.flushing;
    }

    public final boolean isReset() {
        return this.reset;
    }

    public final void dumpTo(PrintWriter writer) {
        double[] snapshot = this.values;
        writer.println("Global Statistics:");
        for (ExtendedStatistic statistic : ExtendedStatistic.values()) {
            if (statistic.isLocal()) {
                writer.print(statistic.name());
                writer.print(" [local]=");
                writer.println(snapshot[ConcurrentGlobalContainer.getLocalIndex(statistic)]);
            }
            if (!statistic.isRemote()) continue;
            writer.print(statistic.name());
            writer.print(" [remote]=");
            writer.println(snapshot[ConcurrentGlobalContainer.getLocalIndex(statistic)]);
        }
        writer.print("LAST_RESET=");
        writer.println(snapshot[0]);
        writer.flush();
    }

    private void tryFlush() {
        if (this.flushing.compareAndSet(false, true)) {
            this.flush();
        }
    }

    private void flush() {
        if (this.reset) {
            this.values = this.create();
            this.queue.clear();
            this.reset = false;
            this.values[0] = this.timeService.time();
            this.flushing.set(false);
            return;
        }
        double[] copy = this.create();
        System.arraycopy(this.values, 0, copy, 0, copy.length);
        ArrayList drain = new ArrayList();
        this.queue.drainTo(drain);
        for (Mergeable mergeable : drain) {
            try {
                mergeable.mergeTo(copy);
            }
            catch (Throwable throwable) {}
        }
        this.values = copy;
        this.flushing.set(false);
    }

    private double[] create() {
        return new double[TOTAL_SIZE];
    }

    private static class SingleOperation
    implements Mergeable {
        private final int index;
        private final double value;

        private SingleOperation(int index, double value) {
            this.value = value;
            this.index = index;
        }

        @Override
        public void mergeTo(double[] values) {
            int n = this.index;
            values[n] = values[n] + this.value;
        }
    }

    private static class Transaction
    implements Mergeable {
        private final double[] toMerge;
        private final int offset;

        private Transaction(double[] toMerge, int offset) {
            this.toMerge = toMerge;
            this.offset = offset;
        }

        @Override
        public void mergeTo(double[] values) {
            for (int i = 0; i < values.length; ++i) {
                int n = this.offset + i;
                values[n] = values[n] + this.toMerge[i];
            }
        }
    }

    private static interface Mergeable {
        public void mergeTo(double[] var1);
    }
}

