package org.infinispan.extendedstats.logging;

import java.util.Locale;
import org.infinispan.extendedstats.container.ExtendedStatistic;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.String;
import org.jboss.logging.Logger;
import org.infinispan.extendedstats.percentiles.PercentileStatistic;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-05-04T12:36:53-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void extendedStatisticNotFoundForPercentile(final ExtendedStatistic statistic, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, extendedStatisticNotFoundForPercentile$str(), statistic);
    }
    private static final String extendedStatisticNotFoundForPercentile = "ISPN025001: Extended Statistic [%s] not found while tried to add a percentile sample.";
    protected String extendedStatisticNotFoundForPercentile$str() {
        return extendedStatisticNotFoundForPercentile;
    }
    @Override
    public final void markUnexistingTransactionAsWriteTransaction(final String transaction) {
        super.log.logf(FQCN, WARN, null, markUnexistingTransactionAsWriteTransaction$str(), transaction);
    }
    private static final String markUnexistingTransactionAsWriteTransaction = "ISPN025002: Trying to mark the transaction [%s] as write transaction but no transaction is associated.";
    protected String markUnexistingTransactionAsWriteTransaction$str() {
        return markUnexistingTransactionAsWriteTransaction;
    }
    @Override
    public final void prepareOnUnexistingTransaction(final String transaction) {
        super.log.logf(FQCN, WARN, null, prepareOnUnexistingTransaction$str(), transaction);
    }
    private static final String prepareOnUnexistingTransaction = "ISPN025003: Trying to prepare transaction [%s] but no transaction is associated.";
    protected String prepareOnUnexistingTransaction$str() {
        return prepareOnUnexistingTransaction;
    }
    @Override
    public final void outcomeOnUnexistingTransaction(final String transaction, final String outcome) {
        super.log.logf(FQCN, WARN, null, outcomeOnUnexistingTransaction$str(), transaction, outcome);
    }
    private static final String outcomeOnUnexistingTransaction = "ISPN025004: Trying to set the transaction [%s] outcome to %s but no transaction is associated.";
    protected String outcomeOnUnexistingTransaction$str() {
        return outcomeOnUnexistingTransaction;
    }
    @Override
    public final void unableToCalculateLocalExecutionTimeWithoutContention(final Throwable throwable) {
        super.log.logf(FQCN, WARN, throwable, unableToCalculateLocalExecutionTimeWithoutContention$str());
    }
    private static final String unableToCalculateLocalExecutionTimeWithoutContention = "ISPN025005: Unable calculate local execution time without contention.";
    protected String unableToCalculateLocalExecutionTimeWithoutContention$str() {
        return unableToCalculateLocalExecutionTimeWithoutContention;
    }
    @Override
    public final void unableToCopyValue(final ExtendedStatistic from, final ExtendedStatistic to, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, unableToCopyValue$str(), from, to);
    }
    private static final String unableToCopyValue = "ISPN025006: Unable to copy value from %s to %s.";
    protected String unableToCopyValue$str() {
        return unableToCopyValue;
    }
    @Override
    public final void unableToGetStatistic(final ExtendedStatistic statistic, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, unableToGetStatistic$str(), statistic);
    }
    private static final String unableToGetStatistic = "ISPN025007: Unable to get extended statistic %s.";
    protected String unableToGetStatistic$str() {
        return unableToGetStatistic;
    }
    @Override
    public final void unableToGetPercentile(final int percentile, final PercentileStatistic statistic, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, unableToGetPercentile$str(), percentile, statistic);
    }
    private static final String unableToGetPercentile = "ISPN025008: Unable to get %s-th percentile for %s.";
    protected String unableToGetPercentile$str() {
        return unableToGetPercentile;
    }
    @Override
    public final void replaceComponents() {
        super.log.logf(FQCN, INFO, null, replaceComponents$str());
    }
    private static final String replaceComponents = "ISPN025009: Replacing original components.";
    protected String replaceComponents$str() {
        return replaceComponents;
    }
    @Override
    public final void replaceComponent(final String componentName, final Object oldComponent, final Object newComponent) {
        super.log.logf(FQCN, INFO, null, replaceComponent$str(), componentName, oldComponent, newComponent);
    }
    private static final String replaceComponent = "ISPN025010: Replacing %s. old=[%s] new=[%s].";
    protected String replaceComponent$str() {
        return replaceComponent;
    }
    @Override
    public final void startExtendedStatisticInterceptor() {
        super.log.logf(FQCN, INFO, null, startExtendedStatisticInterceptor$str());
    }
    private static final String startExtendedStatisticInterceptor = "ISPN025011: Starting ExtendedStatisticInterceptor.";
    protected String startExtendedStatisticInterceptor$str() {
        return startExtendedStatisticInterceptor;
    }
    @Override
    public final void startStreamSummaryInterceptor() {
        super.log.logf(FQCN, INFO, null, startStreamSummaryInterceptor$str());
    }
    private static final String startStreamSummaryInterceptor = "ISPN025012: Starting CacheUsageInterceptor.";
    protected String startStreamSummaryInterceptor$str() {
        return startStreamSummaryInterceptor;
    }
    @Override
    public final void stopStreamSummaryInterceptor() {
        super.log.logf(FQCN, INFO, null, stopStreamSummaryInterceptor$str());
    }
    private static final String stopStreamSummaryInterceptor = "ISPN025013: Stopping CacheUsageInterceptor.";
    protected String stopStreamSummaryInterceptor$str() {
        return stopStreamSummaryInterceptor;
    }
}
