/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.extendedstats.topK;

import jakarta.transaction.RollbackException;
import jakarta.transaction.Transaction;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.extendedstats.AbstractTopKeyTest;
import org.infinispan.extendedstats.topK.CacheUsageInterceptor;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.impl.TxInterceptor;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="extendedstats.topK.LocalTopKeyTest")
@CleanupAfterTest
public class LocalTopKeyTest
extends AbstractTopKeyTest {
    @BeforeMethod(alwaysRun=true)
    public void resetBeforeTest() {
        this.getTopKey(this.cache(0)).resetStatistics();
    }

    public void testPut(Method method) {
        String key1 = TestingUtil.k((Method)method, (int)1);
        String key2 = TestingUtil.k((Method)method, (int)2);
        this.cache(0).put((Object)key1, (Object)"value1");
        this.cache(0).put((Object)key2, (Object)"value2");
        this.assertTopKeyAccesses(this.cache(0), key1, 1L, false);
        this.assertTopKeyAccesses(this.cache(0), key2, 1L, false);
        this.assertTopKeyAccesses(this.cache(0), key1, 0L, true);
        this.assertTopKeyAccesses(this.cache(0), key2, 0L, true);
        this.assertLockInformation(this.cache(0), key1, 1L, 0L, 0L);
        this.assertLockInformation(this.cache(0), key2, 1L, 0L, 0L);
        this.assertWriteSkew(this.cache(0), key1, 0L);
        this.assertWriteSkew(this.cache(0), key2, 0L);
    }

    public void testGet(Method method) {
        String key1 = TestingUtil.k((Method)method, (int)1);
        String key2 = TestingUtil.k((Method)method, (int)2);
        this.cache(0).get((Object)key1);
        this.cache(0).get((Object)key2);
        this.assertTopKeyAccesses(this.cache(0), key1, 0L, false);
        this.assertTopKeyAccesses(this.cache(0), key2, 0L, false);
        this.assertTopKeyAccesses(this.cache(0), key1, 1L, true);
        this.assertTopKeyAccesses(this.cache(0), key2, 1L, true);
        this.assertLockInformation(this.cache(0), key1, 0L, 0L, 0L);
        this.assertLockInformation(this.cache(0), key2, 0L, 0L, 0L);
        this.assertWriteSkew(this.cache(0), key1, 0L);
        this.assertWriteSkew(this.cache(0), key2, 0L);
    }

    public void testLockFailed(Method method) throws InterruptedException, TimeoutException, ExecutionException {
        String key = TestingUtil.k((Method)method, (int)0);
        AbstractTopKeyTest.PrepareCommandBlocker blocker = this.addPrepareBlockerIfAbsent(this.cache(0));
        blocker.reset();
        Future f = this.fork(() -> {
            this.cache(0).put((Object)key, (Object)"value");
            return null;
        });
        blocker.awaitUntilPrepareBlocked();
        try {
            this.cache(0).put((Object)key, (Object)"value");
            Assert.fail((String)"The key should be locked!");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        blocker.unblock();
        f.get(30L, TimeUnit.SECONDS);
        this.assertTopKeyAccesses(this.cache(0), key, 2L, false);
        this.assertTopKeyAccesses(this.cache(0), key, 0L, true);
        this.assertLockInformation(this.cache(0), key, 2L, 1L, 1L);
        this.assertWriteSkew(this.cache(0), key, 0L);
    }

    public void testWriteSkew(Method method) throws Exception {
        String key = TestingUtil.k((Method)method, (int)0);
        this.cache(0).put((Object)key, (Object)"init");
        this.tm(0).begin();
        this.cache(0).get((Object)key);
        Transaction transaction = this.tm(0).suspend();
        this.cache(0).put((Object)key, (Object)"value");
        try {
            this.tm(0).resume(transaction);
            this.cache(0).put((Object)key, (Object)"value1");
            this.tm(0).commit();
            AssertJUnit.fail((String)"The write skew should be detected");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        this.assertTopKeyAccesses(this.cache(0), key, 3L, false);
        this.assertTopKeyAccesses(this.cache(0), key, 1L, true);
        this.assertLockInformation(this.cache(0), key, 3L, 0L, 0L);
        this.assertWriteSkew(this.cache(0), key, 1L);
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = LocalTopKeyTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.LOCAL, (boolean)true);
        builder.customInterceptors().addInterceptor().before(TxInterceptor.class).interceptor((AsyncInterceptor)new CacheUsageInterceptor());
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ).lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        this.addClusterEnabledCacheManager(builder);
    }
}

