/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.extendedstats;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.remoting.inboundhandler.AbstractDelegatingHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializableFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseClusteredExtendedStatisticTest
extends MultipleCacheManagersTest {
    private static final int NUM_NODES = 2;
    private static final String VALUE_1 = "value_1";
    private static final String VALUE_2 = "value_2";
    private static final String VALUE_3 = "value_3";
    private static final String VALUE_4 = "value_4";
    private final List<ControlledPerCacheInboundInvocationHandler> inboundHandlerList = new ArrayList<ControlledPerCacheInboundInvocationHandler>(2);
    private final CacheMode mode;

    protected BaseClusteredExtendedStatisticTest(CacheMode mode) {
        this.mode = mode;
    }

    protected static Collection<Address> getOwners(Cache<?, ?> cache, Object key) {
        return new ArrayList<Address>(cache.getAdvancedCache().getDistributionManager().getCacheTopology().getWriteOwners(key));
    }

    protected static Collection<Address> getOwners(Cache<?, ?> cache, Collection<Object> keys) {
        return new ArrayList<Address>(cache.getAdvancedCache().getDistributionManager().getCacheTopology().getWriteOwners(keys));
    }

    public void testPut(Method method) throws InterruptedException {
        String key1 = TestingUtil.k((Method)method, (int)1);
        String key2 = TestingUtil.k((Method)method, (int)2);
        String key3 = TestingUtil.k((Method)method, (int)3);
        this.assertEmpty(key1, key2, key3);
        this.put(0, key1, VALUE_1);
        this.assertCacheValue(key1, VALUE_1);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key2, VALUE_2);
        map.put(key3, VALUE_3);
        this.cache(0).putAll(map);
        this.awaitPutMap(0, map.keySet());
        this.assertCacheValue(key1, VALUE_1);
        this.assertCacheValue(key2, VALUE_2);
        this.assertCacheValue(key3, VALUE_3);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testRemove(Method method) throws InterruptedException {
        String key1 = TestingUtil.k((Method)method, (int)1);
        this.assertEmpty(key1);
        this.put(1, key1, VALUE_1);
        this.assertCacheValue(key1, VALUE_1);
        this.remove(0, key1);
        this.assertCacheValue(key1, null);
        this.put(0, key1, VALUE_1);
        this.assertCacheValue(key1, VALUE_1);
        this.remove(0, key1);
        this.assertCacheValue(key1, null);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testPutIfAbsent(Method method) throws InterruptedException {
        String key1 = TestingUtil.k((Method)method, (int)1);
        String key2 = TestingUtil.k((Method)method, (int)2);
        this.assertEmpty(key1, key2);
        this.put(1, key1, VALUE_1);
        this.assertCacheValue(key1, VALUE_1);
        this.cache(0).putIfAbsent((Object)key1, (Object)VALUE_2);
        this.assertCacheValue(key1, VALUE_1);
        this.put(1, key1, VALUE_3);
        this.assertCacheValue(key1, VALUE_3);
        this.cache(0).putIfAbsent((Object)key1, (Object)VALUE_4);
        this.assertCacheValue(key1, VALUE_3);
        this.putIfAbsent(0, key2, VALUE_1);
        this.assertCacheValue(key2, VALUE_1);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testRemoveIfPresent(Method method) throws InterruptedException {
        String key1 = TestingUtil.k((Method)method, (int)1);
        this.assertEmpty(key1);
        this.put(0, key1, VALUE_1);
        this.assertCacheValue(key1, VALUE_1);
        this.put(1, key1, VALUE_2);
        this.assertCacheValue(key1, VALUE_2);
        this.cache(0).remove((Object)key1, (Object)VALUE_1);
        this.assertCacheValue(key1, VALUE_2);
        this.remove(0, key1, VALUE_2);
        this.assertCacheValue(key1, null);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testClear(Method method) throws InterruptedException {
        String key1 = TestingUtil.k((Method)method, (int)1);
        this.assertEmpty(key1);
        this.put(0, key1, VALUE_1);
        this.assertCacheValue(key1, VALUE_1);
        this.cache(0).clear();
        this.awaitClear(0);
        this.assertCacheValue(key1, null);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testReplace(Method method) throws InterruptedException {
        String key1 = TestingUtil.k((Method)method, (int)1);
        this.assertEmpty(key1);
        this.put(1, key1, VALUE_1);
        this.assertCacheValue(key1, VALUE_1);
        AssertJUnit.assertEquals((Object)this.replace(0, key1, VALUE_2), (Object)VALUE_1);
        this.assertCacheValue(key1, VALUE_2);
        this.put(0, key1, VALUE_3);
        this.assertCacheValue(key1, VALUE_3);
        this.replace(0, key1, VALUE_3);
        this.assertCacheValue(key1, VALUE_3);
        this.put(0, key1, VALUE_4);
        this.assertCacheValue(key1, VALUE_4);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testReplaceWithOldVal(Method method) throws InterruptedException {
        String key1 = TestingUtil.k((Method)method, (int)1);
        this.assertEmpty(key1);
        this.put(1, key1, VALUE_1);
        this.assertCacheValue(key1, VALUE_1);
        this.put(0, key1, VALUE_2);
        this.assertCacheValue(key1, VALUE_2);
        this.cache(0).replace((Object)key1, (Object)VALUE_3, (Object)VALUE_4);
        this.assertCacheValue(key1, VALUE_2);
        this.replace(0, key1, VALUE_2, VALUE_4);
        this.assertCacheValue(key1, VALUE_4);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testRemoveUnexistingEntry(Method method) throws InterruptedException {
        String key1 = TestingUtil.k((Method)method, (int)1);
        this.assertEmpty(key1);
        this.remove(0, key1);
        this.assertCacheValue(key1, null);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testCompute(Method method) throws InterruptedException {
        String key1 = TestingUtil.k((Method)method, (int)1);
        String key2 = TestingUtil.k((Method)method, (int)2);
        this.assertEmpty(key1);
        this.put(1, key1, VALUE_1);
        this.assertCacheValue(key1, VALUE_1);
        SerializableBiFunction & Serializable computeFunction = (SerializableBiFunction & Serializable)(k, v) -> VALUE_2 + k + v;
        this.compute(0, key1, (BiFunction<? super Object, ? super Object, ?>)computeFunction);
        this.assertCacheValue(key1, VALUE_2 + key1 + VALUE_1);
        this.compute(1, key2, (BiFunction<? super Object, ? super Object, ?>)computeFunction);
        this.assertCacheValue(key2, VALUE_2 + key2 + "null");
        SerializableBiFunction & Serializable computeFunctionToNull = (SerializableBiFunction & Serializable)(k, v) -> null;
        this.compute(0, key1, (BiFunction<? super Object, ? super Object, ?>)computeFunctionToNull);
        this.assertEmpty(key1);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testComputeIfPresent(Method method) throws InterruptedException {
        String key1 = TestingUtil.k((Method)method, (int)1);
        String key2 = TestingUtil.k((Method)method, (int)2);
        this.assertEmpty(key1);
        this.assertEmpty(key2);
        this.put(1, key1, VALUE_1);
        this.assertCacheValue(key1, VALUE_1);
        SerializableBiFunction & Serializable computeFunction = (SerializableBiFunction & Serializable)(k, v) -> VALUE_2 + k + v;
        this.computeIfPresent(0, key1, (BiFunction<? super Object, ? super Object, ?>)computeFunction);
        this.assertCacheValue(key1, VALUE_2 + key1 + VALUE_1);
        this.cache(1).computeIfPresent((Object)key2, (SerializableBiFunction)computeFunction);
        this.assertEmpty(key2);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testComputeIfAbsent(Method method) throws InterruptedException {
        String key1 = TestingUtil.k((Method)method, (int)1);
        String key2 = TestingUtil.k((Method)method, (int)2);
        this.assertEmpty(key1);
        this.assertEmpty(key2);
        this.put(1, key1, VALUE_1);
        this.assertCacheValue(key1, VALUE_1);
        SerializableFunction & Serializable computeFunction = (SerializableFunction & Serializable)v -> VALUE_3 + v;
        this.cache(0).computeIfAbsent((Object)key1, (SerializableFunction)computeFunction);
        this.assertCacheValue(key1, VALUE_1);
        SerializableFunction & Serializable computeFunction2 = (SerializableFunction & Serializable)v -> VALUE_2;
        this.computeIfAbsent(1, key2, (Function<? super Object, ?>)computeFunction2);
        this.assertCacheValue(key2, VALUE_2);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    @BeforeMethod(alwaysRun=true)
    public void resetInboundHandler() {
        this.inboundHandlerList.forEach(rec$ -> ((ControlledPerCacheInboundInvocationHandler)((Object)((Object)rec$))).reset());
    }

    protected void createCacheManagers() throws Throwable {
        for (int i = 0; i < 2; ++i) {
            ConfigurationBuilder builder = BaseClusteredExtendedStatisticTest.getDefaultClusteredCacheConfig((CacheMode)this.mode, (boolean)true);
            builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
            builder.clustering().hash().numOwners(1);
            builder.transaction().recovery().disable();
            builder.customInterceptors().addInterceptor().interceptor((AsyncInterceptor)new ExtendedStatisticInterceptor()).position(InterceptorConfiguration.Position.FIRST);
            this.addClusterEnabledCacheManager(builder);
        }
        this.waitForClusterToForm();
        this.replaceAllPerCacheInboundInvocationHandler();
    }

    protected void assertEmpty(Object ... keys) {
        for (Cache cache : this.caches()) {
            for (Object key : keys) {
                AssertJUnit.assertNull((Object)cache.get(key));
            }
        }
    }

    protected void assertCacheValue(Object key, Object value) {
        for (int index = 0; index < this.caches().size(); ++index) {
            if (this.mode.isSynchronous()) {
                this.assertEquals(index, key, value);
                continue;
            }
            this.assertEventuallyEquals(index, key, value);
        }
    }

    private void awaitPut(int cacheIndex, Object key) throws InterruptedException {
        this.awaitSingleKeyOperation(Operation.PUT, cacheIndex, key);
    }

    private void awaitReplace(int cacheIndex, Object key) throws InterruptedException {
        this.awaitSingleKeyOperation(Operation.REPLACE, cacheIndex, key);
    }

    private void awaitRemove(int cacheIndex, Object key) throws InterruptedException {
        this.awaitSingleKeyOperation(Operation.REMOVE, cacheIndex, key);
    }

    private void awaitCompute(int cacheIndex, Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) throws InterruptedException {
        this.awaitSingleKeyOperation(Operation.COMPUTE, cacheIndex, key);
    }

    private void awaitComputeIfAbsent(int cacheIndex, Object key, Function<? super Object, ?> computeFunction) throws InterruptedException {
        this.awaitSingleKeyOperation(Operation.COMPUTE_IF_ABSENT, cacheIndex, key);
    }

    private void awaitComputeIfPresent(int cacheIndex, Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) throws InterruptedException {
        this.awaitSingleKeyOperation(Operation.COMPUTE, cacheIndex, key);
    }

    private void awaitPutMap(int cacheIndex, Collection<Object> keys) throws InterruptedException {
        Cache executedOn = this.cache(cacheIndex);
        Collection<Address> owners = BaseClusteredExtendedStatisticTest.getOwners(executedOn, keys);
        owners.remove(this.address(executedOn));
        this.awaitOperation(Operation.PUT_MAP, owners);
    }

    private void awaitSingleKeyOperation(Operation operation, int cacheIndex, Object key) throws InterruptedException {
        Cache executedOn = this.cache(cacheIndex);
        Collection<Address> owners = BaseClusteredExtendedStatisticTest.getOwners(executedOn, key);
        owners.remove(this.address(executedOn));
        this.awaitOperation(operation, owners);
    }

    private void awaitClear(int cacheIndex) throws InterruptedException {
        HashSet<Address> all = new HashSet<Address>(this.cache(cacheIndex).getAdvancedCache().getRpcManager().getMembers());
        all.remove(this.address(cacheIndex));
        this.awaitOperation(Operation.CLEAR, all);
    }

    protected final void awaitOperation(Operation operation, Collection<Address> owners) throws InterruptedException {
        for (int i = 0; i < 2; ++i) {
            if (!owners.contains(this.cache(i).getAdvancedCache().getRpcManager().getAddress())) continue;
            this.inboundHandlerList.get(i).await(operation, 30L, TimeUnit.SECONDS);
        }
    }

    private void put(int cacheIndex, Object key, Object value) throws InterruptedException {
        this.cache(cacheIndex).put(key, value);
        this.awaitPut(cacheIndex, key);
    }

    private void putIfAbsent(int cacheIndex, Object key, Object value) throws InterruptedException {
        this.cache(cacheIndex).putIfAbsent(key, value);
        this.awaitPut(cacheIndex, key);
    }

    private Object replace(int cacheIndex, Object key, Object value) throws InterruptedException {
        Object val = this.cache(cacheIndex).replace(key, value);
        this.awaitReplace(cacheIndex, key);
        return val;
    }

    private Object replace(int cacheIndex, Object key, Object oldValue, Object newValue) throws InterruptedException {
        Boolean val = this.cache(cacheIndex).replace(key, oldValue, newValue);
        this.awaitReplace(cacheIndex, key);
        return val;
    }

    private void remove(int cacheIndex, Object key) throws InterruptedException {
        this.cache(cacheIndex).remove(key);
        this.awaitRemove(cacheIndex, key);
    }

    private void remove(int cacheIndex, Object key, Object oldValue) throws InterruptedException {
        this.cache(cacheIndex).remove(key, oldValue);
        this.awaitRemove(cacheIndex, key);
    }

    private void compute(int cacheIndex, Object key, BiFunction<? super Object, ? super Object, ?> computeFunction) throws InterruptedException {
        this.cache(cacheIndex).compute(key, computeFunction);
        this.awaitCompute(cacheIndex, key, computeFunction);
    }

    private void computeIfPresent(int cacheIndex, Object key, BiFunction<? super Object, ? super Object, ?> computeFunction) throws InterruptedException {
        this.cache(cacheIndex).computeIfPresent(key, computeFunction);
        this.awaitComputeIfPresent(cacheIndex, key, computeFunction);
    }

    private void computeIfAbsent(int cacheIndex, Object key, Function<? super Object, ?> computeFunction) throws InterruptedException {
        this.cache(cacheIndex).computeIfAbsent(key, computeFunction);
        this.awaitComputeIfAbsent(cacheIndex, key, computeFunction);
    }

    private void assertNoTxStats() {
        ExtendedStatisticInterceptor[] statisticInterceptors = new ExtendedStatisticInterceptor[this.caches().size()];
        for (int i = 0; i < this.caches().size(); ++i) {
            statisticInterceptors[i] = this.getExtendedStatistic(this.cache(i));
        }
        BaseClusteredExtendedStatisticTest.eventually(() -> {
            for (ExtendedStatisticInterceptor interceptor : statisticInterceptors) {
                if (!interceptor.getCacheStatisticManager().hasPendingTransactions()) continue;
                return false;
            }
            return true;
        });
    }

    private void assertEquals(int index, Object key, Object value) {
        AssertJUnit.assertEquals((Object)this.cache(index).get(key), (Object)value);
    }

    private ExtendedStatisticInterceptor getExtendedStatistic(Cache<?, ?> cache) {
        AsyncInterceptorChain interceptorChain = cache.getAdvancedCache().getAsyncInterceptorChain();
        ExtendedStatisticInterceptor extendedStatisticInterceptor = (ExtendedStatisticInterceptor)interceptorChain.findInterceptorExtending(ExtendedStatisticInterceptor.class);
        if (extendedStatisticInterceptor != null) {
            extendedStatisticInterceptor.resetStatistics();
        }
        return extendedStatisticInterceptor;
    }

    private void replaceAllPerCacheInboundInvocationHandler() {
        for (Cache cache : this.caches()) {
            this.inboundHandlerList.add((ControlledPerCacheInboundInvocationHandler)TestingUtil.wrapInboundInvocationHandler((Cache)cache, x$0 -> new ControlledPerCacheInboundInvocationHandler((PerCacheInboundInvocationHandler)x$0)));
        }
    }

    private static class ControlledPerCacheInboundInvocationHandler
    extends AbstractDelegatingHandler {
        private final Queue<Operation> operationQueue = new LinkedList<Operation>();

        private ControlledPerCacheInboundInvocationHandler(PerCacheInboundInvocationHandler delegate) {
            super(delegate);
        }

        public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
            this.checkCommand((ReplicableCommand)command);
            this.delegate.handle(command, reply, order);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            Queue<Operation> queue = this.operationQueue;
            synchronized (queue) {
                this.operationQueue.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void await(Operation operation, long timeout, TimeUnit timeUnit) throws InterruptedException {
            long timeoutNanos = System.nanoTime() + timeUnit.toNanos(timeout);
            Queue<Operation> queue = this.operationQueue;
            synchronized (queue) {
                while (this.operationQueue.peek() != operation && System.nanoTime() - timeoutNanos < 0L) {
                    this.operationQueue.wait(timeUnit.toMillis(timeout));
                }
                AssertJUnit.assertEquals((Object)((Object)operation), (Object)((Object)this.operationQueue.poll()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkCommand(ReplicableCommand cacheRpcCommand) {
            Queue<Operation> queue = this.operationQueue;
            synchronized (queue) {
                switch (cacheRpcCommand.getCommandId()) {
                    case 8: {
                        this.operationQueue.add(Operation.PUT);
                        break;
                    }
                    case 11: {
                        this.operationQueue.add(Operation.REPLACE);
                        break;
                    }
                    case 68: {
                        this.operationQueue.add(Operation.COMPUTE);
                        break;
                    }
                    case 69: {
                        this.operationQueue.add(Operation.COMPUTE_IF_ABSENT);
                        break;
                    }
                    case 10: {
                        this.operationQueue.add(Operation.REMOVE);
                        break;
                    }
                    case 5: {
                        this.operationQueue.add(Operation.CLEAR);
                        break;
                    }
                    case 9: {
                        this.operationQueue.add(Operation.PUT_MAP);
                        break;
                    }
                    case 12: 
                    case 26: {
                        for (WriteCommand command : ((PrepareCommand)cacheRpcCommand).getModifications()) {
                            this.checkCommand((ReplicableCommand)command);
                        }
                        break;
                    }
                    case 1: {
                        this.checkCommand(((SingleRpcCommand)cacheRpcCommand).getCommand());
                    }
                }
                this.operationQueue.notifyAll();
            }
        }
    }

    protected static enum Operation {
        PUT,
        REMOVE,
        REPLACE,
        CLEAR,
        PUT_MAP,
        COMPUTE,
        COMPUTE_IF_ABSENT;

    }
}

