/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats;

import java.util.HashMap;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.stats.wrappers.ExtendedStatisticInterceptor;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.TransactionProtocol;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stats.BaseClusteredExtendedStatisticTest")
public abstract class BaseClusteredExtendedStatisticTest
extends MultipleCacheManagersTest {
    private static final String KEY_1 = "key_1";
    private static final String KEY_2 = "key_2";
    private static final String KEY_3 = "key_3";
    private static final String VALUE_1 = "value_1";
    private static final String VALUE_2 = "value_2";
    private static final String VALUE_3 = "value_3";
    private static final String VALUE_4 = "value_4";
    private final CacheMode mode;
    private final boolean sync2ndPhase;
    private final boolean writeSkew;
    private final boolean totalOrder;

    protected BaseClusteredExtendedStatisticTest(CacheMode mode, boolean sync2ndPhase, boolean writeSkew, boolean totalOrder) {
        this.mode = mode;
        this.sync2ndPhase = sync2ndPhase;
        this.writeSkew = writeSkew;
        this.totalOrder = totalOrder;
    }

    public void testPut() {
        this.assertEmpty(KEY_1, KEY_2, KEY_3);
        this.cache(0).put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY_2, VALUE_2);
        map.put(KEY_3, VALUE_3);
        this.cache(0).putAll(map);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.assertCacheValue(KEY_2, VALUE_2);
        this.assertCacheValue(KEY_3, VALUE_3);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void removeTest() {
        this.assertEmpty(KEY_1);
        this.cache(1).put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache(0).remove((Object)KEY_1);
        this.assertCacheValue(KEY_1, null);
        this.cache(0).put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache(0).remove((Object)KEY_1);
        this.assertCacheValue(KEY_1, null);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testPutIfAbsent() {
        this.assertEmpty(KEY_1, KEY_2);
        this.cache(1).put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache(0).putIfAbsent((Object)KEY_1, (Object)VALUE_2);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache(1).put((Object)KEY_1, (Object)VALUE_3);
        this.assertCacheValue(KEY_1, VALUE_3);
        this.cache(0).putIfAbsent((Object)KEY_1, (Object)VALUE_4);
        this.assertCacheValue(KEY_1, VALUE_3);
        this.cache(0).putIfAbsent((Object)KEY_2, (Object)VALUE_1);
        this.assertCacheValue(KEY_2, VALUE_1);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testRemoveIfPresent() {
        this.assertEmpty(KEY_1);
        this.cache(0).put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache(1).put((Object)KEY_1, (Object)VALUE_2);
        this.assertCacheValue(KEY_1, VALUE_2);
        this.cache(0).remove((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_2);
        this.cache(0).remove((Object)KEY_1, (Object)VALUE_2);
        this.assertCacheValue(KEY_1, null);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testClear() {
        this.assertEmpty(KEY_1);
        this.cache(0).put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache(0).clear();
        this.assertCacheValue(KEY_1, null);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    @Test(groups={"unstable"}, description="https://issues.jboss.org/browse/ISPN-3353")
    public void testReplace() {
        this.assertEmpty(KEY_1);
        this.cache(1).put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        Assert.assertEquals((Object)this.cache(0).replace((Object)KEY_1, (Object)VALUE_2), (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_2);
        this.cache(0).put((Object)KEY_1, (Object)VALUE_3);
        this.assertCacheValue(KEY_1, VALUE_3);
        this.cache(0).replace((Object)KEY_1, (Object)VALUE_3);
        this.assertCacheValue(KEY_1, VALUE_3);
        this.cache(0).put((Object)KEY_1, (Object)VALUE_4);
        this.assertCacheValue(KEY_1, VALUE_4);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testReplaceWithOldVal() {
        this.assertEmpty(KEY_1);
        this.cache(1).put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache(0).put((Object)KEY_1, (Object)VALUE_2);
        this.assertCacheValue(KEY_1, VALUE_2);
        this.cache(0).replace((Object)KEY_1, (Object)VALUE_3, (Object)VALUE_4);
        this.assertCacheValue(KEY_1, VALUE_2);
        this.cache(0).replace((Object)KEY_1, (Object)VALUE_2, (Object)VALUE_4);
        this.assertCacheValue(KEY_1, VALUE_4);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testRemoveUnexistingEntry() {
        this.assertEmpty(KEY_1);
        this.cache(0).remove((Object)KEY_1);
        this.assertCacheValue(KEY_1, null);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    protected void createCacheManagers() throws Throwable {
        for (int i = 0; i < 2; ++i) {
            ConfigurationBuilder builder = BaseClusteredExtendedStatisticTest.getDefaultClusteredCacheConfig((CacheMode)this.mode, (boolean)true);
            builder.transaction().syncCommitPhase(this.sync2ndPhase).syncRollbackPhase(this.sync2ndPhase);
            if (this.totalOrder) {
                builder.transaction().transactionProtocol(TransactionProtocol.TOTAL_ORDER);
            }
            builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(this.writeSkew);
            builder.clustering().hash().numOwners(1);
            if (this.writeSkew) {
                builder.versioning().enable().scheme(VersioningScheme.SIMPLE);
            }
            builder.transaction().recovery().disable();
            builder.customInterceptors().addInterceptor().interceptor((CommandInterceptor)new ExtendedStatisticInterceptor()).position(InterceptorConfiguration.Position.FIRST);
            this.addClusterEnabledCacheManager(builder);
        }
        this.waitForClusterToForm();
    }

    protected void assertEmpty(Object ... keys) {
        for (Cache cache : this.caches()) {
            for (Object key : keys) {
                Assert.assertNull((Object)cache.get(key));
            }
        }
    }

    protected void assertCacheValue(Object key, Object value) {
        for (int index = 0; index < this.caches().size(); ++index) {
            if (this.mode.isSynchronous() && this.sync2ndPhase) {
                this.assertEquals(index, key, value);
                continue;
            }
            this.assertEventuallyEquals(index, key, value);
        }
    }

    private void assertNoTxStats() {
        final ExtendedStatisticInterceptor[] statisticInterceptors = new ExtendedStatisticInterceptor[this.caches().size()];
        for (int i = 0; i < this.caches().size(); ++i) {
            statisticInterceptors[i] = this.getExtendedStatistic(this.cache(i));
        }
        this.eventually(new AbstractInfinispanTest.Condition(){

            public boolean isSatisfied() throws Exception {
                for (ExtendedStatisticInterceptor interceptor : statisticInterceptors) {
                    if (!interceptor.getCacheStatisticManager().hasPendingTransactions()) continue;
                    return false;
                }
                return true;
            }
        });
    }

    private void assertEquals(int index, Object key, Object value) {
        Assert.assertEquals((Object)this.cache(index).get(key), (Object)value);
    }

    private ExtendedStatisticInterceptor getExtendedStatistic(Cache<?, ?> cache) {
        for (CommandInterceptor commandInterceptor : cache.getAdvancedCache().getInterceptorChain()) {
            if (!(commandInterceptor instanceof ExtendedStatisticInterceptor)) continue;
            ((ExtendedStatisticInterceptor)commandInterceptor).resetStatistics();
            return (ExtendedStatisticInterceptor)commandInterceptor;
        }
        return null;
    }
}

