/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.wrappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.stats.CacheStatisticManager;
import org.infinispan.stats.container.ExtendedStatistic;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.LockManager;

public class ExtendedStatisticLockManager
implements LockManager {
    private final LockManager actual;
    private final CacheStatisticManager cacheStatisticManager;
    private final ConcurrentMap<Object, LockInfo> lockInfoMap = CollectionFactory.makeConcurrentMap();
    private final TimeService timeService;

    public ExtendedStatisticLockManager(LockManager actual, CacheStatisticManager cacheStatisticManager, TimeService timeService) {
        this.cacheStatisticManager = cacheStatisticManager;
        this.actual = actual;
        this.timeService = timeService;
    }

    public final LockManager getActual() {
        return this.actual;
    }

    public boolean lockAndRecord(Object key, InvocationContext ctx, long timeoutMillis) throws InterruptedException {
        return this.actual.lockAndRecord(key, ctx, timeoutMillis);
    }

    public void unlock(Collection<Object> lockedKeys, Object lockOwner) {
        long timestamp = this.timeService.time();
        for (Object key : lockedKeys) {
            LockInfo lockInfo = (LockInfo)this.lockInfoMap.get(key);
            if (lockInfo == null || !lockInfo.owner.equals(lockOwner)) continue;
            lockInfo.updateStats(timestamp);
            this.lockInfoMap.remove(key);
        }
        this.actual.unlock(lockedKeys, lockOwner);
    }

    public void unlockAll(InvocationContext ctx) {
        ArrayList<LockInfo> acquiredLockInfo = new ArrayList<LockInfo>();
        for (Object key : ctx.getLockedKeys()) {
            LockInfo lockInfo = (LockInfo)this.lockInfoMap.get(key);
            if (lockInfo == null || !lockInfo.owner.equals(ctx.getLockOwner())) continue;
            acquiredLockInfo.add(lockInfo);
            this.lockInfoMap.remove(key);
        }
        this.actual.unlockAll(ctx);
        long timestamp = this.timeService.time();
        for (LockInfo lockInfo : acquiredLockInfo) {
            lockInfo.updateStats(timestamp);
        }
    }

    public boolean ownsLock(Object key, Object owner) {
        return this.actual.ownsLock(key, owner);
    }

    public boolean isLocked(Object key) {
        return this.actual.isLocked(key);
    }

    public Object getOwner(Object key) {
        return this.actual.getOwner(key);
    }

    public String printLockInfo() {
        return this.actual.printLockInfo();
    }

    public boolean possiblyLocked(CacheEntry entry) {
        return this.actual.possiblyLocked(entry);
    }

    public int getNumberOfLocksHeld() {
        return this.actual.getNumberOfLocksHeld();
    }

    public int getLockId(Object key) {
        return this.actual.getLockId(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireLock(InvocationContext ctx, Object key, long timeoutMillis, boolean skipLocking) throws InterruptedException, TimeoutException {
        LockInfo lockInfo = new LockInfo(ctx);
        this.updateContentionStats(key, lockInfo);
        boolean locked = false;
        long start = this.timeService.time();
        try {
            locked = this.actual.acquireLock(ctx, key, timeoutMillis, skipLocking);
        }
        finally {
            long end = this.timeService.time();
            lockInfo.lockTimeStamp = end;
            if (lockInfo.contention) {
                lockInfo.lockWaiting = this.timeService.timeDuration(start, end, TimeUnit.NANOSECONDS);
            }
            if (locked) {
                this.lockInfoMap.putIfAbsent(key, lockInfo);
            } else {
                lockInfo.updateStats(null);
            }
        }
        return locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireLockNoCheck(InvocationContext ctx, Object key, long timeoutMillis, boolean skipLocking) throws InterruptedException, TimeoutException {
        LockInfo lockInfo = new LockInfo(ctx);
        this.updateContentionStats(key, lockInfo);
        boolean locked = false;
        long start = this.timeService.time();
        try {
            locked = this.actual.acquireLockNoCheck(ctx, key, timeoutMillis, skipLocking);
        }
        finally {
            long end = this.timeService.time();
            lockInfo.lockTimeStamp = end;
            if (lockInfo.contention) {
                lockInfo.lockWaiting = this.timeService.timeDuration(start, end, TimeUnit.NANOSECONDS);
            }
            if (locked) {
                this.lockInfoMap.putIfAbsent(key, lockInfo);
            } else {
                lockInfo.updateStats(null);
            }
        }
        return locked;
    }

    private void updateContentionStats(Object key, LockInfo lockInfo) {
        Object holder = this.getOwner(key);
        if (holder != null) {
            lockInfo.contention = !holder.equals(lockInfo.owner);
        }
    }

    private class LockInfo {
        private final GlobalTransaction owner;
        private final boolean local;
        private long lockTimeStamp = -1L;
        private boolean contention = false;
        private long lockWaiting = -1L;

        public LockInfo(InvocationContext ctx) {
            this.owner = ctx.getLockOwner() instanceof GlobalTransaction ? (GlobalTransaction)ctx.getLockOwner() : null;
            this.local = ctx.isOriginLocal();
        }

        public final void updateStats(Long releaseTimeStamp) {
            boolean locked = releaseTimeStamp != null;
            long holdTime = !locked ? 0L : ExtendedStatisticLockManager.this.timeService.timeDuration(this.lockTimeStamp, releaseTimeStamp.longValue(), TimeUnit.NANOSECONDS);
            ExtendedStatisticLockManager.this.cacheStatisticManager.add(ExtendedStatistic.LOCK_HOLD_TIME, holdTime, this.owner, this.local);
            if (this.lockWaiting != -1L) {
                ExtendedStatisticLockManager.this.cacheStatisticManager.add(ExtendedStatistic.LOCK_WAITING_TIME, this.lockWaiting, this.owner, this.local);
                ExtendedStatisticLockManager.this.cacheStatisticManager.increment(ExtendedStatistic.NUM_WAITED_FOR_LOCKS, this.owner, this.local);
            }
            if (locked) {
                ExtendedStatisticLockManager.this.cacheStatisticManager.increment(ExtendedStatistic.NUM_HELD_LOCKS, this.owner, this.local);
            }
        }
    }
}

